/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.tape;

import com.agitar.lib.mockingbird.MethodCache;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Utils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TapeForConstructor {
    private final Map map = new HashMap();

    public Value get(Constructor constructor) {
        List list;
        String signature = MethodCache.getFullSignature(constructor);
        if (this.map != null && (list = (List)this.map.get(signature)) != null && list.size() > 0) {
            Value answer = (Value)list.remove(0);
            if (list.size() == 0) {
                this.map.remove(signature);
            }
            return answer;
        }
        return null;
    }

    public void add(Constructor constructor, Object object, boolean keepOriginal) {
        if (constructor == null) {
            throw new MockingbirdError("Cannot use null constructor for recording");
        }
        if (object == null) {
            throw new MockingbirdError("Cannot use null object for recording");
        }
        if (!constructor.getDeclaringClass().isInstance(object)) {
            throw new MockingbirdError("Cannot use object of type '" + object.getClass().getName() + "' on constructor " + MethodCache.getFullSignature(constructor));
        }
        List list = this.getList(constructor);
        list.add(new Value(object, keepOriginal));
    }

    public void add(Constructor constructor, Throwable exception) {
        if (constructor == null) {
            throw new MockingbirdError("Cannot use null constructor for recording");
        }
        if (exception == null) {
            throw new MockingbirdError("Cannot use null object for exception");
        }
        this.checkException(constructor, exception);
        List list = this.getList(constructor);
        list.add(new Value(exception));
    }

    private void checkException(Constructor constructor, Throwable exception) {
        if (!Utils.isDeclaredException(exception, constructor.getExceptionTypes())) {
            throw new MockingbirdError(exception.getClass().getName() + " is not a declared exception of method: " + MethodCache.getFullSignature(constructor));
        }
    }

    private List getList(Constructor constructor) {
        String signature = MethodCache.getFullSignature(constructor);
        ArrayList list = (ArrayList)this.map.get(signature);
        if (list == null) {
            list = new ArrayList();
            this.map.put(signature, list);
        }
        return list;
    }

    public void clear() {
        this.map.clear();
    }

    public static class Value {
        private final boolean keepOriginal;
        private final Object newObject;
        private final Throwable exception;

        public boolean getKeepOriginal() {
            return this.keepOriginal;
        }

        public Object get() throws Throwable {
            if (this.exception == null) {
                return this.newObject;
            }
            throw this.exception;
        }

        private Value(Throwable exception) {
            this.newObject = null;
            this.exception = exception;
            this.keepOriginal = true;
        }

        private Value(Object newObject, boolean keepOriginal) {
            this.newObject = newObject;
            this.keepOriginal = keepOriginal;
            this.exception = null;
        }
    }
}

