/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.tape;

import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Tape;
import com.agitar.lib.mockingbird.tape.ValueList;
import java.util.HashMap;
import java.util.Map;

public class ParameterTapes
implements Tape {
    private final Map methodMap = new HashMap();

    public Object playback(String signature, Object[] params, boolean isInPeekMode) {
        MethodRecord record = (MethodRecord)this.methodMap.get(signature);
        if (record == null) {
            return null;
        }
        return record.playback(params, isInPeekMode);
    }

    public void record(String signature, Object[] params, Object value, boolean persit) {
        MethodRecord record = (MethodRecord)this.methodMap.get(signature);
        if (record == null) {
            record = new MethodRecord(signature);
            this.methodMap.put(signature, record);
        }
        record.record(params, value == null ? Tape.NULL_OBJECT : value, persit);
    }

    public void clear() {
        Object[] objects = this.methodMap.values().toArray();
        for (int i = 0; i < objects.length; ++i) {
            MethodRecord record = (MethodRecord)objects[i];
            record.clear();
        }
        this.methodMap.clear();
    }

    public void checkTapeEndReached() throws MockingbirdError.LeftOverInTape {
        Object[] objects = this.methodMap.values().toArray();
        for (int i = 0; i < objects.length; ++i) {
            MethodRecord record = (MethodRecord)objects[i];
            record.checkTapeEndReached();
        }
    }

    static class MethodRecord {
        private String signature;
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
        private Map paramMap = new HashMap();

        MethodRecord(String signature) {
            this.signature = signature;
        }

        private Object playback(Object[] params, boolean isInPeekMode) {
            Tape.ArrayWrapper array;
            ValueList list;
            if (params == null) {
                params = EMPTY_OBJECT_ARRAY;
            }
            if ((list = (ValueList)this.paramMap.get(array = new Tape.ArrayWrapper(params))) == null) {
                return null;
            }
            return list.get(isInPeekMode);
        }

        private void record(Object[] params, Object value, boolean persit) {
            if (params == null) {
                params = EMPTY_OBJECT_ARRAY;
            }
            if (params != null && value != null) {
                Tape.ArrayWrapper array = new Tape.ArrayWrapper(params);
                ValueList list = (ValueList)this.paramMap.get(array);
                if (list == null) {
                    list = new ValueList(this.signature);
                    this.paramMap.put(array, list);
                }
                list.add(value);
                if (persit) {
                    list.setLastRecordIsPersistent();
                }
            }
        }

        public void clear() {
            this.paramMap.clear();
        }

        public void checkTapeEndReached() {
            Object[] objects = this.paramMap.values().toArray();
            for (int i = 0; i < objects.length; ++i) {
                MockingbirdError.LeftOverInTape error;
                ValueList list = (ValueList)objects[i];
                if (list.isLastRecordIsPersistent() || (error = list.leftOverInTape()) == null) continue;
                throw (MockingbirdError)error.fillInStackTrace();
            }
        }
    }
}

