/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.tape;

import java.lang.reflect.Array;

public abstract class HashCodeUtil {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int aSeed, boolean aBoolean) {
        return HashCodeUtil.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return HashCodeUtil.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return HashCodeUtil.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return HashCodeUtil.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return HashCodeUtil.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return HashCodeUtil.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(int aSeed, Object aObject) {
        int result = aSeed;
        if (aObject == null) {
            result = HashCodeUtil.hash(result, 0);
        } else if (!HashCodeUtil.isArray(aObject)) {
            result = aObject instanceof String ? HashCodeUtil.hash(result, aObject.hashCode()) : (aObject instanceof Boolean ? HashCodeUtil.hash(result, (Boolean)aObject) : (aObject instanceof Byte ? HashCodeUtil.hash(result, ((Byte)aObject).byteValue()) : (aObject instanceof Character ? HashCodeUtil.hash(result, ((Character)aObject).charValue()) : (aObject instanceof Short ? HashCodeUtil.hash(result, ((Short)aObject).shortValue()) : (aObject instanceof Integer ? HashCodeUtil.hash(result, (Integer)aObject) : (aObject instanceof Long ? HashCodeUtil.hash(result, (Long)aObject) : (aObject instanceof Float ? HashCodeUtil.hash(result, ((Float)aObject).floatValue()) : (aObject instanceof Double ? HashCodeUtil.hash(result, (Double)aObject) : HashCodeUtil.hash(result, System.identityHashCode(aObject))))))))));
        } else {
            int length = Array.getLength(aObject);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(aObject, idx);
                result = HashCodeUtil.hash(result, item);
            }
        }
        return result;
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }

    private HashCodeUtil() {
    }
}

