/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.java.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ThreadController {
    public static final boolean CONTROL_ON = ThreadController.isControlOn();
    private static int count;
    private static final Set traces;
    private static final Set tracesInString;

    public static void start(Thread thread) {
        if (thread != null) {
            StackTraceElement[] stackTrace = new Trace().fillInStackTrace().getStackTrace();
            if (stackTrace != null && count < 50 && tracesInString.add(ThreadController.getText(stackTrace))) {
                ++count;
                StackTraceElement[] clean = new StackTraceElement[stackTrace.length - 1];
                System.arraycopy(stackTrace, 1, clean, 0, clean.length);
                traces.add(Arrays.asList(clean));
            }
            if (CONTROL_ON) {
                thread.run();
            } else {
                thread.start();
            }
        }
    }

    private static Object getText(StackTraceElement[] stackTrace) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            buffer.append(element.toString());
        }
        return buffer.toString();
    }

    private static boolean isControlOn() {
        String[] CONTROL_TEXT = new String[]{"ThreadControl", "threadcontrol", "ThreadController", "threadcontroller"};
        String property = null;
        for (int i = 0; property == null && i < CONTROL_TEXT.length; ++i) {
            property = System.getProperty(CONTROL_TEXT[i]);
        }
        return property != null && ("on".equals(property) || "1".equals(property) || "true".equals(property));
    }

    private ThreadController() {
    }

    public static StackTraceElement[][] getTraces() {
        StackTraceElement[][] result = new StackTraceElement[traces.size()][];
        int n = 0;
        Iterator iter = traces.iterator();
        while (iter.hasNext()) {
            List trace = (List)iter.next();
            result[n++] = trace.toArray(new StackTraceElement[trace.size()]);
        }
        return result;
    }

    public static void clearTraces() {
        traces.clear();
        count = 0;
        tracesInString.clear();
    }

    static {
        traces = new HashSet();
        tracesInString = new HashSet();
    }

    private static class Trace
    extends Exception {
        private Trace() {
        }
    }
}

