/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.invocation;

import com.agitar.common.util.ClassCacheMap;
import com.agitar.common.util.DefiningClassLoader;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.lib.mockingbird.MockingbirdError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Map;

public class Invoke {
    private static final Map memberMap = new ClassCacheMap(Invoke.class.getName() + ".memberMap");
    private static final String INTERNAL_INTERPOSER_CLASS_NAME = "user.agitar.invocation.Interposer";
    private static final String INTERNAL_INTERPOSER_CLASS__FILE_NAME = "user.agitar.invocation.Interposer".replace('.', '/') + ".class";
    private static Method specialInvokeMethod = null;
    private static boolean dontTryAnyMore = false;

    public static Object execute(Method method, Object thisObject, Object[] params) throws Throwable {
        if (method == null) {
            throw new MockingbirdError("method is null");
        }
        if (thisObject == null && !Modifier.isStatic(method.getModifiers())) {
            throw new NullPointerException();
        }
        if (method.getDeclaringClass() == Class.class && method.getName().equals("newInstance")) {
            try {
                Constructor c = ((Class)thisObject).getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(c.getModifiers())) {
                    c.setAccessible(true);
                }
                return c.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new InstantiationException(method.getDeclaringClass().getName());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Throwable e) {
                throw e;
            }
        }
        try {
            if (thisObject != null && Proxy.class.isInstance(thisObject)) {
                return Proxy.getInvocationHandler(thisObject).invoke(thisObject, method, params);
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            try {
                if (thisObject == null) {
                    if (!dontTryAnyMore && specialInvokeMethod == null) {
                        specialInvokeMethod = Invoke.loadSpecialInvokeMethod();
                    }
                    if (specialInvokeMethod != null) {
                        return specialInvokeMethod.invoke(null, method, thisObject, params);
                    }
                }
            }
            catch (InvocationTargetException t) {
                throw t.getTargetException();
            }
            catch (Throwable t) {
                throw t;
            }
            return method.invoke(thisObject, params);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Throwable e) {
            throw e;
        }
    }

    public static void clear() {
        specialInvokeMethod = null;
        dontTryAnyMore = false;
        memberMap.clear();
    }

    private static Method loadSpecialInvokeMethod() throws IOException, ClassNotFoundException {
        try {
            ClassLoader cl = ReflectionCacheRegistry.getContextClassLoader();
            if (cl instanceof DefiningClassLoader) {
                Class interposerClass;
                byte[] classBytes = null;
                classBytes = Invoke.readInterposerClass();
                if (classBytes != null && (interposerClass = ((DefiningClassLoader)cl).loadClassFromBytes(INTERNAL_INTERPOSER_CLASS_NAME, classBytes)) != null) {
                    return interposerClass.getDeclaredMethod("invokeUsingThreadClassLoader", Method.class, Object.class, new Object[0].getClass());
                }
            }
            return null;
        }
        catch (Throwable t) {
            dontTryAnyMore = true;
            return null;
        }
    }

    private static byte[] readInterposerClass() throws IOException {
        byte[] classBytes = null;
        InputStream resourceAsStream = Invoke.class.getClassLoader().getResourceAsStream(INTERNAL_INTERPOSER_CLASS__FILE_NAME);
        if (resourceAsStream != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtility.copy((InputStream)resourceAsStream, (OutputStream)baos);
            classBytes = baos.toByteArray();
            resourceAsStream.close();
            baos.close();
        }
        return classBytes;
    }

    private Invoke() {
    }
}

