/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.invocation;

import com.agitar.lib.mockingbird.invocation.InvocationRecordList;
import java.util.IdentityHashMap;
import java.util.Map;

public class InvocationTraceMap {
    private static boolean recording = true;
    private final Map objectMap = new IdentityHashMap();
    private long total;

    public boolean find(Object target, String signature, Object[] params, int count) {
        InvocationRecordList records;
        if (target != null && (records = (InvocationRecordList)this.objectMap.get(target)) != null) {
            return records.find(signature, params, count);
        }
        return false;
    }

    public boolean find(Object target, String signature, int count) {
        InvocationRecordList records;
        if (target != null && (records = (InvocationRecordList)this.objectMap.get(target)) != null) {
            return records.find(signature, count);
        }
        return false;
    }

    public InvocationRecordList findTrace(Object target) {
        return (InvocationRecordList)this.objectMap.get(target);
    }

    public void add(Object target, String methodName, String descriptor, Object[] params) {
        if (recording && target != null) {
            InvocationRecordList records = (InvocationRecordList)this.objectMap.get(target);
            if (records == null) {
                records = new InvocationRecordList();
                this.objectMap.put(target, records);
            }
            records.add(methodName, descriptor, params);
            ++this.total;
        }
    }

    public static void stopRecording() {
        recording = false;
    }

    public static void startRecording() {
        recording = true;
    }

    public long getTotal() {
        return this.total;
    }

    public void clear() {
        this.objectMap.clear();
    }
}

