/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird.invocation;

import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Tape;
import com.agitar.lib.mockingbird.Utils;
import java.util.ArrayList;

public class InvocationRecordList
extends ArrayList {
    private int startIndex = 0;

    public void add(String methodName, String descriptor, Object[] params) {
        this.add(new InvocationRecord(methodName, descriptor, params));
    }

    private String checkSignature(String signature) throws MockingbirdError {
        int right = signature.indexOf(41);
        int left = signature.indexOf(40);
        if (left >= 0 ? left == 0 || right < 0 || right <= left : right >= 0) {
            throw new MockingbirdError("Mal-formed signature: " + signature);
        }
        return left > 0 ? signature.substring(0, right + 1).trim() : signature.trim();
    }

    private boolean find(InvocationRecord record, int count) {
        int previousValue = this.startIndex;
        for (int cnt = 0; cnt < count; ++cnt) {
            boolean found = false;
            for (int i = this.startIndex; i < this.size(); ++i) {
                if (!record.match((InvocationRecord)this.get(i))) continue;
                this.startIndex = i + 1;
                found = true;
                break;
            }
            if (found) continue;
            this.startIndex = previousValue;
            return false;
        }
        return true;
    }

    public boolean find(String signature, int count) {
        InvocationRecord record = new InvocationRecord(this.checkSignature(signature), null);
        return this.find(record, count);
    }

    public boolean find(String signature, Object[] params, int count) {
        InvocationRecord record = new InvocationRecord(this.checkSignature(signature), params);
        return this.find(record, count);
    }

    public void resetIndex() {
        this.startIndex = 0;
    }

    public static class InvocationRecord {
        private final boolean hasDescriptor;
        private final String descriptor;
        private final String methodName;
        private final Tape.ArrayWrapper params;
        private String signature;

        private InvocationRecord(String signature, Object[] objs) {
            this.signature = signature;
            int left = signature.indexOf("(");
            if (left < 0) {
                this.hasDescriptor = false;
                this.methodName = signature;
            } else {
                this.hasDescriptor = true;
                this.methodName = signature.substring(0, left);
            }
            this.descriptor = null;
            this.params = objs == null ? null : new Tape.ArrayWrapper(objs);
        }

        private InvocationRecord(String name, String descriptor, Object[] objs) {
            this.methodName = name;
            this.hasDescriptor = true;
            this.descriptor = descriptor;
            this.params = objs == null ? null : new Tape.ArrayWrapper(objs);
        }

        public Object[] getParams() {
            return this.params.getArrayObject();
        }

        public String getSignature() {
            if (this.signature == null) {
                this.signature = this.hasDescriptor ? Utils.convertToPrettySignature(this.methodName, this.descriptor) : this.methodName;
            }
            return this.signature;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public boolean match(InvocationRecord other) {
            if (other == this) {
                return true;
            }
            if (this.methodName.equals(other.methodName)) {
                if (this.hasDescriptor) {
                    if (this.getSignature().equals(other.getSignature())) {
                        return this.matchParams(other);
                    }
                } else {
                    return this.matchParams(other);
                }
            }
            return false;
        }

        private boolean matchParams(InvocationRecord other) {
            if (this.params == null || other.params == null) {
                return true;
            }
            return this.params.equals(other.params);
        }
    }
}

