/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.StringUtility;
import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.MethodCache;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.Tape;
import com.agitar.lib.mockingbird.TypeMismatchedError;
import com.agitar.lib.mockingbird.tape.ExceptionHolder;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.asm.Type;

public abstract class Utils {
    private static Logger logger;
    private static final String MOCKINGBIRD_CLASS_NAME;
    private static final Class[][] PRIMITIVE_PAIRS;
    private static final Map PRIMITIVE_TYPES;
    public static final String SUFFIX = "_Mock";
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static Class[] getExceptions(boolean isStatic, Object target, String signature) {
        try {
            int idx = signature.indexOf(40);
            String methodName = signature.substring(0, idx);
            String desc = signature.substring(idx);
            Class<?> targetClass = isStatic ? (Class<?>)target : target.getClass();
            Member member = MethodCache.find(isStatic ? null : target, Type.getInternalName(targetClass), methodName, desc, targetClass.getClassLoader());
            if (member instanceof Constructor) {
                return ((Constructor)member).getExceptionTypes();
            }
            if (member instanceof Method) {
                return ((Method)member).getExceptionTypes();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Class[0];
    }

    public static String canBeInherited(Class type) {
        String reason = null;
        int modifiers = type.getModifiers();
        if (type.isPrimitive()) {
            reason = "Primitive type";
        } else if (type.isArray()) {
            reason = "Array type";
        } else if (Proxy.isProxyClass(type)) {
            reason = "Proxy class";
        } else if (Modifier.isPrivate(modifiers)) {
            reason = "Private class";
        } else if (Modifier.isFinal(modifiers)) {
            reason = "Final class";
        }
        if (reason == null && Utils.isSystemClass(type) && (Modifier.isPrivate(modifiers) || !Modifier.isPublic(modifiers))) {
            reason = "Non-public system class";
        }
        if (reason != null) {
            reason = reason + " cannot be inherited";
        }
        return reason;
    }

    public static void checkIsAssignable(Class type, Object value) {
        Utils.initPrimitiveMap();
        Class cls = (Class)PRIMITIVE_TYPES.get(type);
        if (cls != null) {
            if (value == null) {
                throw new MockingbirdError("Cannot assign null to primitive types");
            }
            if (!cls.isAssignableFrom(value.getClass())) {
                throw new MockingbirdError("Cannot assign " + value.getClass().getName() + " to primitive type \"" + cls.getName() + "\"");
            }
        }
        if (value != null && !type.isAssignableFrom(value.getClass())) {
            throw new MockingbirdError("Cannot assign object of type \"" + value.getClass().getName() + "\" to type \"" + cls.getName() + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPrimitiveMap() {
        if (PRIMITIVE_TYPES.size() == 0) {
            Map map = PRIMITIVE_TYPES;
            synchronized (map) {
                for (int i = 0; i < PRIMITIVE_PAIRS.length; ++i) {
                    PRIMITIVE_TYPES.put(PRIMITIVE_PAIRS[i][0], PRIMITIVE_PAIRS[i][1]);
                }
            }
        }
    }

    private static void checkPrimitive(Object value, String signature, Class answerCls, Class type) {
        if (value == Tape.NULL_OBJECT) {
            throw new MockingbirdError("Tape.NULL_OBJECT is not allowed for primitive return type of method: " + Utils.getPrettySignature(signature));
        }
        Utils.initPrimitiveMap();
        Class cls = (Class)PRIMITIVE_TYPES.get(type);
        if (cls != null && !cls.isAssignableFrom(answerCls)) {
            Utils.throwTapeError(signature, answerCls, cls);
        }
    }

    public static void checkReturnValue(Object value, String signature) {
        if (value != null) {
            String expectedReturnType = signature.substring(signature.lastIndexOf(41) + 1);
            if ("V".equals(expectedReturnType) && Tape.DO_NOTHING != value) {
                throw new MockingbirdError("Invalid return value for void method: " + Utils.getPrettySignature(signature));
            }
            Class type = ClassCache.getClassFromInternalName(expectedReturnType);
            if (type.isPrimitive()) {
                Utils.checkPrimitive(value, signature, value.getClass(), type);
            } else if (!type.isInstance(value)) {
                Utils.throwTapeError(signature, value.getClass(), type);
            }
        }
    }

    public static String computeToString(Object object) {
        return Utils.computeToString(object.getClass().getName(), object);
    }

    public static String computeToString(String className, Object object) {
        return object.getClass().getName() + "@" + System.identityHashCode(object);
    }

    public static Object convertPrimitive(Class type, Object value) {
        if (type.equals(Void.TYPE)) {
            return "";
        }
        if (Boolean.TYPE.equals(type) && Boolean.class.isInstance(value) || Character.TYPE.equals(type) && Character.class.isInstance(value)) {
            return value;
        }
        return NumberConverter.convertPrimitiveNumber(type, value);
    }

    public static String convertToPrettySignature(String methodName, String byteocdeFormat) {
        if (StringUtility.nullOrEmpty((String)byteocdeFormat) || byteocdeFormat.indexOf(40) != 0 || byteocdeFormat.indexOf(41) < 0) {
            return methodName + "()";
        }
        StringBuffer buffer = new StringBuffer();
        MethodSignature.convertParams((String)methodName, (String)byteocdeFormat.substring(1, byteocdeFormat.indexOf(41)), (StringBuffer)buffer);
        return buffer.toString();
    }

    private static int findMockingbirdInvoke(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            String methodName = element.getMethodName();
            String className = element.getClassName();
            if (!MOCKINGBIRD_CLASS_NAME.equals(className) || !methodName.equals("invoke")) continue;
            return i;
        }
        return -1;
    }

    public static StackTraceElement firstUserClassInTrace(Throwable exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            return null;
        }
        if (Utils.isNewInstaceCall(stackTrace[0])) {
            int idx = Utils.findMockingbirdInvoke(stackTrace);
            if (idx < 0) {
                return null;
            }
            return stackTrace[idx + 1];
        }
        return stackTrace[0];
    }

    public static Logger getLogger() {
        return logger;
    }

    private static Object getPlainName(Class cl) {
        return cl.getName().replace('$', '.');
    }

    public static StringBuffer getPrettyName(Class type, StringBuffer buffer) {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                buffer.append(Utils.getPlainName(cl));
                for (int i = 0; i < dimensions; ++i) {
                    buffer.append("[]");
                }
            }
            catch (Throwable throwable) {}
        } else {
            buffer.append(Utils.getPlainName(type));
        }
        return buffer;
    }

    public static String getPrettyShortSignature(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getName());
        buffer.append('(');
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            ClassName cn = ClassName.get(parameterTypes[i]);
            buffer.append(cn.getFullTypeName());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getPrettySignature(String byteocdeFormat) {
        int idx = byteocdeFormat.indexOf(40);
        if (idx > 0) {
            return Utils.convertToPrettySignature(byteocdeFormat.substring(0, byteocdeFormat.charAt(idx - 1) == '.' ? idx - 1 : idx), byteocdeFormat.substring(idx));
        }
        return byteocdeFormat;
    }

    public static String getSubclassName(Class type) {
        String className = (Utils.isSystemClass(type) ? AsmMockingbirdUtility.getJDKMockClassName(type) : type.getName()) + SUFFIX;
        return className;
    }

    public static void handleExceptions(Object value, Class[] exceptionTypes, String signature) throws Throwable {
        if (value instanceof ExceptionHolder) {
            Throwable exceptionVar = ((ExceptionHolder)value).getException();
            if (exceptionVar == null) {
                throw new MockingbirdError("Exception cannot be null");
            }
            if (exceptionVar instanceof Error) {
                throw (Error)exceptionVar;
            }
            if (exceptionVar instanceof RuntimeException) {
                throw (RuntimeException)exceptionVar;
            }
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class excClass = exceptionTypes[i];
                if (!excClass.isInstance(exceptionVar)) continue;
                throw exceptionVar;
            }
            throw new MockingbirdError("undeclared exception: " + exceptionVar.getClass().getName() + " for method: " + Utils.getPrettySignature(signature));
        }
    }

    public static boolean isDeclaredException(Throwable exception, Class[] declaredExceptions) {
        if (Error.class.isInstance(exception) || RuntimeException.class.isInstance(exception)) {
            return true;
        }
        Class<?> excCls = exception.getClass();
        for (int i = 0; declaredExceptions != null && i < declaredExceptions.length; ++i) {
            Class cls = declaredExceptions[i];
            if (!cls.isAssignableFrom(excCls)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewInstaceCall(StackTraceElement element) {
        String methodName = element.getMethodName();
        String className = element.getClassName();
        return methodName.startsWith("newInstance") && (className.equals("sun.reflect.NativeConstructorAccessorImpl") || className.startsWith("sun.reflect.GeneratedConstructorAccessor")) || methodName.startsWith("invoke") && (className.equals("sun.reflect.NativeMethodAccessorImpl") || className.startsWith("sun.reflect.GeneratedMethodAccessor"));
    }

    public static boolean isSystemClass(Class type) {
        ClassLoader classLoader = type.getClassLoader();
        return classLoader == null;
    }

    public static Throwable popStackTrace(final Throwable exception) {
        try {
            return (Throwable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    StackTraceElement[] stackTrace = exception.getStackTrace();
                    if (stackTrace.length == 0) {
                        return exception;
                    }
                    StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - 1];
                    System.arraycopy(stackTrace, 1, newStackTrace, 0, newStackTrace.length);
                    exception.setStackTrace(newStackTrace);
                    return exception;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static void setLogger(Logger logger) {
        Utils.logger = logger;
    }

    private static void throwTapeError(String signature, Class valueCls, Class type) {
        throw new MockingbirdError("Return value of type " + valueCls.getName() + " is not allowed for return type " + type.getName() + " of method: " + Utils.getPrettySignature(signature));
    }

    public static String toInternalSignature(String signature) {
        String afterTrim = signature.trim();
        int space = afterTrim.indexOf(32);
        if (space < 0) {
            throw new IllegalArgumentException("return type is missing");
        }
        MethodSignature sig = new MethodSignature(afterTrim.substring(0, space) + " Foo." + afterTrim.substring(space + 1));
        return sig.getName() + sig.getBytecodeForm();
    }

    public static Object wrap(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object wrap(byte value) {
        return new Byte(value);
    }

    public static Object wrap(char value) {
        return new Character(value);
    }

    public static Object wrap(double value) {
        return new Double(value);
    }

    public static Object wrap(float value) {
        return new Float(value);
    }

    public static Object wrap(int value) {
        return new Integer(value);
    }

    public static Object wrap(long value) {
        return new Long(value);
    }

    public static Object wrap(Object value) {
        return value;
    }

    public static Object wrap(short value) {
        return new Short(value);
    }

    private Utils() {
    }

    static {
        MOCKINGBIRD_CLASS_NAME = Mockingbird.class.getName();
        PRIMITIVE_PAIRS = new Class[][]{{Boolean.TYPE, Boolean.class}, {Byte.TYPE, Number.class}, {Character.TYPE, Character.class}, {Short.TYPE, Number.class}, {Integer.TYPE, Number.class}, {Long.TYPE, Number.class}, {Float.TYPE, Number.class}, {Double.TYPE, Number.class}};
        PRIMITIVE_TYPES = new HashMap();
    }

    private static class NumberConverter {
        private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
        private static final Map primitiveConverters = new HashMap();
        private Constructor constrcutor;
        private Method method;
        private final Class primitive;
        private final Class wrapper;

        static Object convertPrimitiveNumber(Class returnType, Object value) {
            if ((class$java$lang$Number == null ? (class$java$lang$Number = Utils.class$("java.lang.Number")) : class$java$lang$Number).isInstance(value)) {
                if (NumberConverter.exactPrimitiveMatch(returnType, value)) {
                    return value;
                }
                NumberConverter converter = (NumberConverter)primitiveConverters.get(returnType);
                if (converter != null) {
                    try {
                        return converter.convert((Number)value);
                    }
                    catch (Exception e) {
                        throw new MockingbirdError(e);
                    }
                }
            }
            throw new TypeMismatchedError(returnType, value.getClass());
        }

        private static boolean exactPrimitiveMatch(Class returnType, Object value) {
            Iterator iter = primitiveConverters.values().iterator();
            while (iter.hasNext()) {
                NumberConverter converter = (NumberConverter)iter.next();
                if (!converter.exactMatch(returnType, value)) continue;
                return true;
            }
            return false;
        }

        private NumberConverter(Class primitive, Class wrapper) throws SecurityException, NoSuchMethodException {
            this.primitive = primitive;
            this.wrapper = wrapper;
            this.constrcutor = wrapper.getConstructor(primitive);
            this.method = (class$java$lang$Number == null ? (class$java$lang$Number = Utils.class$("java.lang.Number")) : class$java$lang$Number).getMethod(primitive.getName() + "Value", EMPTY_CLASS_ARRAY);
        }

        private Object convert(Number value) throws Exception {
            return this.constrcutor.newInstance(this.method.invoke((Object)value, EMPTY_OBJECT_ARRAY));
        }

        private boolean exactMatch(Class returnType, Object value) {
            return this.primitive.equals(returnType) && this.wrapper.isInstance(value);
        }

        static {
            try {
                primitiveConverters.put(Byte.TYPE, new NumberConverter(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Utils.class$("java.lang.Byte")) : class$java$lang$Byte));
                primitiveConverters.put(Short.TYPE, new NumberConverter(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Utils.class$("java.lang.Short")) : class$java$lang$Short));
                primitiveConverters.put(Integer.TYPE, new NumberConverter(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Utils.class$("java.lang.Integer")) : class$java$lang$Integer));
                primitiveConverters.put(Long.TYPE, new NumberConverter(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Utils.class$("java.lang.Long")) : class$java$lang$Long));
                primitiveConverters.put(Float.TYPE, new NumberConverter(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Utils.class$("java.lang.Float")) : class$java$lang$Float));
                primitiveConverters.put(Double.TYPE, new NumberConverter(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Utils.class$("java.lang.Double")) : class$java$lang$Double));
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

