/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.common.types.ClassName;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.common.util.TimeoutController;
import com.agitar.lib.interceptor.Interceptor;
import com.agitar.lib.mockingbird.AgitarProxyMarker;
import com.agitar.lib.mockingbird.Caller;
import com.agitar.lib.mockingbird.DefaultValueMap;
import com.agitar.lib.mockingbird.MethodCache;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.MockingbirdProxyMarker;
import com.agitar.lib.mockingbird.MockingbirdSubclassProxyMarker;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.lib.mockingbird.Value;
import com.agitar.lib.mockingbird.invocation.CallRecord;
import com.agitar.lib.mockingbird.java.io.File_Mock;
import com.agitar.lib.mockingbird.java.io.RandomAccessFile_Mock;
import com.agitar.mockingbird.instrumenter.MockingbirdSubclassCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import sun.reflect.ReflectionFactory;

public final class MockingbirdProxy
extends ClassCacheMap {
    private static final IdentityHashMap blankObjectMap = new IdentityHashMap();
    private static final Map currentConstructorMap = Collections.synchronizedMap(new ClassCacheMap());
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
    private static final Set PRIMITIVE_CLASSES = new HashSet();
    private static final Set PRIMITIVE_WRAPPERS;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static void addBlankObject(Object object) {
        blankObjectMap.put(object, "");
    }

    static void clearMap() {
        currentConstructorMap.clear();
        blankObjectMap.clear();
    }

    private static Constructor getBlankConstructor(Class type) throws NoSuchMethodException {
        Constructor<?> constructor = (Constructor<?>)currentConstructorMap.get(type);
        if (constructor == null) {
            Constructor javaLangObjectConstructor = Object.class.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            constructor = reflectionFactory.newConstructorForSerialization(type, javaLangObjectConstructor);
            currentConstructorMap.put(type, constructor);
        }
        return constructor;
    }

    private static Object createBlankObject(Class type) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (PRIMITIVE_CLASSES.contains(type)) {
            throw new MockingbirdError("cannot get blank object for primitive type: " + type.getName());
        }
        Object obj = MockingbirdProxy.getBlankConstructor(type).newInstance(new Object[0]);
        MockingbirdProxy.addBlankObject(obj);
        return obj;
    }

    private static Object getInterfaceObject(final Class type, ClassLoader loader) {
        return Proxy.newProxyInstance(loader, new Class[]{type, MockingbirdProxyMarker.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
                Class<?> returnType = method.getReturnType();
                String signature = MethodCache.getSignature(method);
                Value returnValue = null;
                try {
                    returnValue = Caller.checkMockingbird(null, signature, proxy, params, returnType);
                }
                catch (Throwable e) {
                    throw Utils.popStackTrace(e.fillInStackTrace());
                }
                if (returnValue != null) {
                    return returnValue.getValue();
                }
                returnValue = Interceptor.intercept(method, proxy, params);
                if (returnValue != null) {
                    return returnValue.getValue();
                }
                if (method.getParameterTypes().length == 0) {
                    String name = method.getName();
                    if ("toString".equals(name)) {
                        return Utils.computeToString("MockingbirdProxyObject", proxy);
                    }
                    if ("hashCode".equals(name)) {
                        return new Integer(System.identityHashCode(proxy));
                    }
                    if ("getClass".equals(name)) {
                        return type;
                    }
                }
                if (Mockingbird.isInTestMode() && Thread.currentThread().getThreadGroup().getParent() != null) {
                    if (Void.TYPE.equals(method.getReturnType())) {
                        return "";
                    }
                    throw new MockingbirdError.NoRecordingInTapeError(Utils.getPrettySignature(signature));
                }
                Object defaultValue = DefaultValueMap.getDefaultValue(returnType);
                Mockingbird.getInvocationHandler().recordCall(new CallRecord(method, proxy, params, returnValue), true);
                return defaultValue;
            }
        });
    }

    public static Object createNewInstance(Class type) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (PRIMITIVE_CLASSES.contains(type)) {
            throw new MockingbirdError("cannot get blank object for primitive type: " + type.getName());
        }
        Object obj = MockingbirdProxy.createRegularObject(type);
        if (obj != null) {
            return obj;
        }
        return MockingbirdProxy.createBlankObject(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(Class type) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, ClassNotFoundException {
        if (PRIMITIVE_CLASSES.contains(type)) {
            throw new MockingbirdError("cannot get blank object for primitive type: " + type.getName());
        }
        String reason = MockingbirdProxy.isBlankObjectAllowed(type);
        if (reason != null) {
            throw new MockingbirdError("cannot get blank object for " + reason);
        }
        if (type.isArray()) {
            return MockingbirdProxy.createArrayObject(type);
        }
        Object obj = MockingbirdProxy.createRegularObject(type);
        if (obj != null) {
            return obj;
        }
        obj = MockingbirdProxy.getSpecialClassObject(type);
        if (obj != null) {
            return obj;
        }
        int modifiers = type.getModifiers();
        Class classToGenerate = type;
        boolean isAbstract = Modifier.isAbstract(modifiers);
        int token = TimeoutController.stopTime((String)"mockingbird-proxy");
        try {
            if (Proxy.isProxyClass(type) || MockingbirdSubclassProxyMarker.class.isAssignableFrom(type)) {
                classToGenerate = type;
            } else if (isAbstract || !Modifier.isFinal(modifiers) && !AgitarProxyMarker.class.isAssignableFrom(type)) {
                reason = Utils.canBeInherited(type);
                if (reason != null) {
                    throw new MockingbirdError(reason + ": " + type.getName());
                }
                if (isAbstract || !MockingbirdProxy.isSynthetic(type)) {
                    classToGenerate = MockingbirdSubclassCache.generate(type, !AgitarProxyMarker.class.isAssignableFrom(type));
                }
            }
            Object object = MockingbirdProxy.createBlankObject(classToGenerate);
            return object;
        }
        finally {
            TimeoutController.resumeTime((int)token);
        }
    }

    public static Object createArrayObject(Class type) {
        int dim = 1;
        Class<?> componentType = type.getComponentType();
        while (componentType.isArray()) {
            ++dim;
            componentType = componentType.getComponentType();
        }
        return Array.newInstance(componentType, new int[dim]);
    }

    private static Object createRegularObject(Class type) {
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        if (Class.class.equals(type)) {
            return type;
        }
        if (type.isInterface()) {
            try {
                return MockingbirdProxy.getInterfaceObject(type, type.getClassLoader());
            }
            catch (IllegalArgumentException e) {
                return MockingbirdProxy.getInterfaceObject(type, ReflectionCacheRegistry.getContextClassLoader());
            }
        }
        if (String.class.equals(type)) {
            return new String();
        }
        if (StringBuffer.class.equals(type)) {
            return new StringBuffer();
        }
        return null;
    }

    private static Object getSpecialClassObject(Class type) {
        MockingbirdSubclassProxyMarker obj = null;
        if (File.class.equals(type)) {
            obj = new File_Mock();
        } else if (RandomAccessFile.class.equals(type)) {
            try {
                File file = File.createTempFile("agitar", "xyz");
                file.deleteOnExit();
                obj = new RandomAccessFile_Mock(file);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (obj != null) {
            MockingbirdProxy.addBlankObject(obj);
        }
        return obj;
    }

    public static boolean isAgitarSubclassProxy(Object object) {
        return MockingbirdSubclassProxyMarker.class.isInstance(object);
    }

    public static boolean isBlankObject(Object object) {
        return blankObjectMap.get(object) != null;
    }

    public static String isBlankObjectAllowed(Class type) {
        if (type.isPrimitive()) {
            return "primitive types";
        }
        return null;
    }

    public static boolean isMockingbirdObject(Object object) {
        return object != null && !PRIMITIVE_CLASSES.contains(object.getClass()) && !PRIMITIVE_WRAPPERS.contains(object.getClass()) && (MockingbirdProxy.isBlankObject(object) || MockingbirdProxy.isMockingbirdType(object.getClass()) || Mockingbird.objectHasRecording(object));
    }

    public static boolean isMockingbirdProxy(Object object) {
        return object != null && MockingbirdProxyMarker.class.isInstance(object);
    }

    public static boolean isMockingbirdType(Class type) {
        return type != null && (Proxy.isProxyClass(type) || MockingbirdSubclassProxyMarker.class.isAssignableFrom(type));
    }

    private static boolean isSynthetic(Class type) {
        ClassName cn = ClassName.get((Class)type);
        if (cn.isAnonymous()) {
            return type.getDeclaredConstructors().length == 0;
        }
        return false;
    }

    private MockingbirdProxy() {
    }

    public void clear() {
        MockingbirdProxy.clearMap();
    }

    static {
        PRIMITIVE_CLASSES.add(Void.TYPE);
        PRIMITIVE_CLASSES.add(Boolean.TYPE);
        PRIMITIVE_CLASSES.add(Byte.TYPE);
        PRIMITIVE_CLASSES.add(Character.TYPE);
        PRIMITIVE_CLASSES.add(Short.TYPE);
        PRIMITIVE_CLASSES.add(Integer.TYPE);
        PRIMITIVE_CLASSES.add(Long.TYPE);
        PRIMITIVE_CLASSES.add(Float.TYPE);
        PRIMITIVE_CLASSES.add(Double.TYPE);
        PRIMITIVE_WRAPPERS = new HashSet(){
            {
                this.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = MockingbirdProxy.class$("java.lang.Boolean")) : class$java$lang$Boolean);
                this.add(class$java$lang$Character == null ? (class$java$lang$Character = MockingbirdProxy.class$("java.lang.Character")) : class$java$lang$Character);
                this.add(class$java$lang$Byte == null ? (class$java$lang$Byte = MockingbirdProxy.class$("java.lang.Byte")) : class$java$lang$Byte);
                this.add(class$java$lang$Short == null ? (class$java$lang$Short = MockingbirdProxy.class$("java.lang.Short")) : class$java$lang$Short);
                this.add(class$java$lang$Integer == null ? (class$java$lang$Integer = MockingbirdProxy.class$("java.lang.Integer")) : class$java$lang$Integer);
                this.add(class$java$lang$Long == null ? (class$java$lang$Long = MockingbirdProxy.class$("java.lang.Long")) : class$java$lang$Long);
                this.add(class$java$lang$Float == null ? (class$java$lang$Float = MockingbirdProxy.class$("java.lang.Float")) : class$java$lang$Float);
                this.add(class$java$lang$Double == null ? (class$java$lang$Double = MockingbirdProxy.class$("java.lang.Double")) : class$java$lang$Double);
            }
        };
    }
}

