/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.Utility;
import com.agitar.lib.interceptor.InterceptorWithDefaultValue;
import com.agitar.lib.mockingbird.Caller;
import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.MethodCache;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.MockingbirdProxy;
import com.agitar.lib.mockingbird.Tape;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.lib.mockingbird.invocation.InvocationHandler;
import com.agitar.lib.mockingbird.invocation.InvocationRecordList;
import com.agitar.lib.mockingbird.invocation.InvocationTraceMap;
import com.agitar.lib.mockingbird.tape.TapeForConstructor;
import com.agitar.lib.mockingbird.tape.TapeVault;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Mockingbird {
    public static final ClinitState CLINIT_ALWAYS_THROWS;
    public static final ClinitState CLINIT_THROWS_SUPPRESSED;
    public static final ClinitState CLINIT_THROWS_SUPPRESSED_AND_INTERCEPT;
    private static final Set clinitCanThrowSet;
    private static final Set noMethodInterceptorSet;
    private static ClinitState clinitState;
    private static InvocationHandler invocationHandler;
    private static final InvocationTraceMap invocationTraceMap;
    private static final int NORMAL_MODE = 0;
    private static int mode;
    private static boolean peekMode;
    private static final int PLAYBACK_MODE = 2;
    private static int previousMode;
    private static final Set constructorExceptionsIgnoredSet;
    private static final int RECORD_MODE = 1;
    private static final TapeForConstructor tapeForConstructor;
    private static final TapeVault tapes;
    private static final int TEST_MODE = 3;
    private static boolean topLevel;
    private static Member lastCall;
    private static Set cutClinitException;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Set clinitSet;
    private static final Object clinitCountLock;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean checkInvocationRecord(Object target, String signature) {
        return Mockingbird.checkInvocationRecord(target, signature, 1);
    }

    public static boolean checkInvocationRecord(Object target, String signature, int count) {
        if (mode != 3 || target == null || signature == null || count <= 0) {
            return false;
        }
        return invocationTraceMap.find(target, signature, count);
    }

    public static boolean checkInvocationRecord(Object target, String signature, Object[] parameters) {
        return Mockingbird.checkInvocationRecord(target, signature, parameters, 1);
    }

    public static boolean checkInvocationRecord(Object target, String signature, Object[] parameters, int count) {
        if (mode != 3 || target == null || signature == null || parameters == null || count <= 0) {
            return false;
        }
        return invocationTraceMap.find(target, signature, parameters, count);
    }

    public static void clear() {
        invocationTraceMap.clear();
        tapes.clear();
        tapeForConstructor.clear();
        mode = 0;
        peekMode = false;
        clinitCanThrowSet.clear();
        cutClinitException.clear();
        constructorExceptionsIgnoredSet.clear();
        MockingbirdProxy.clearMap();
        clinitSet.clear();
    }

    public static void clinitExceptionsNotIgnored(String className) {
        clinitCanThrowSet.add(className.replace('.', '/'));
    }

    public static void methodInterceptorNotAllowed(String className) {
        noMethodInterceptorSet.add(className.replace('.', '/'));
    }

    public static void clinitShouldThrow(String className, Throwable exception) throws Throwable {
        boolean addMethodInterceptors;
        if (!($assertionsDisabled || className != null && className.length() > 0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && exception == null) {
            throw new AssertionError();
        }
        String internalClassName = className.replace('.', '/');
        if (clinitState == CLINIT_ALWAYS_THROWS || clinitCanThrowSet.contains(internalClassName)) {
            clinitSet.remove(internalClassName);
            throw exception;
        }
        ClassName cn = ClassName.get((String)className);
        boolean bl = addMethodInterceptors = !noMethodInterceptorSet.contains(internalClassName) && clinitState == CLINIT_THROWS_SUPPRESSED_AND_INTERCEPT;
        if (addMethodInterceptors) {
            InterceptorWithDefaultValue.addInterceptor(ClassCache.getClassFromInternalName(cn.getBytecodeName()));
        } else {
            cutClinitException.add(cn);
        }
        AgitarLogger.getUserLogger().warning("Exception suppressed" + (addMethodInterceptors ? " and intercepted" : "") + " in static initializer of " + className + ": " + exception);
        Utility.logRealCause((Throwable)exception, (Logger)AgitarLogger.getUserLogger());
        AgitarLogger.getDiagnosticLogger().warning(StringUtility.cleanTrace((Throwable)exception));
        Diagnostics.getKey((String)(addMethodInterceptors ? "clinit.error" : "cut.clinit.error")).setError(cn, "suppressed exception in static initializer", exception);
    }

    public static void ignoreConstructorExceptions(Class type) {
        Mockingbird.ignoreAllConstructors(type);
        Class superClass = type.getSuperclass();
        while (!(class$java$lang$Object == null ? Mockingbird.class$("java.lang.Object") : class$java$lang$Object).equals(superClass) && superClass.getClassLoader() != null) {
            Mockingbird.ignoreAllConstructors(type);
            superClass = superClass.getSuperclass();
        }
    }

    private static void ignoreAllConstructors(Class type) {
        Constructor<?>[] declaredConstructors = type.getDeclaredConstructors();
        for (int i = 0; i < declaredConstructors.length; ++i) {
            Mockingbird.ignoreConstructorExceptions(declaredConstructors[i]);
        }
    }

    public static void ignoreConstructorExceptions(Class type, String signature) throws NoSuchMethodException {
        Mockingbird.ignoreConstructorExceptions(MethodCache.findConstructor(type, signature));
    }

    public static void ignoreConstructorExceptions(Constructor constructor) {
        constructorExceptionsIgnoredSet.add(MethodCache.getFullSignature(constructor));
    }

    public static void constructorShouldThrowException(String internalName, String methodDescriptor, Throwable exception) throws Throwable {
        String signature = internalName + ".<init>" + methodDescriptor;
        if (!constructorExceptionsIgnoredSet.contains(signature)) {
            throw exception;
        }
    }

    public static Object dub(Constructor constructor) throws Throwable {
        TapeForConstructor.Value answer;
        if (Mockingbird.isInPlaybackMode() && !Mockingbird.isInClinit() && (answer = tapeForConstructor.get(constructor)) != null) {
            Object objectFromTape = answer.get();
            return objectFromTape;
        }
        return null;
    }

    public static void endPeekMode() {
        peekMode = false;
        mode = previousMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endTestCase() {
        try {
            if (Mockingbird.isInTestMode()) {
                tapes.checkTapeEndReached();
            }
        }
        finally {
            Mockingbird.clear();
        }
    }

    public static void enterNormalMode() {
        mode = 0;
        peekMode = false;
    }

    public static void enterPlaybackMode() {
        mode = 2;
        tapes.clearRecord();
    }

    public static void enterRecordingMode() {
        mode = 1;
        peekMode = false;
        tapes.clearRecord();
    }

    public static void enterTestMode() {
        Mockingbird.enterTestMode(null);
    }

    public static void enterTestMode(Class classUnderTest) {
        mode = 3;
        tapes.clearRecord();
        InvocationTraceMap.startRecording();
        if (classUnderTest != null && Modifier.isInterface(classUnderTest.getModifiers())) {
            throw new MockingbirdError("Class under test cannot be an interfcae.");
        }
        tapes.setClassUnderTest(classUnderTest);
    }

    public static InvocationRecordList findInvocationTrace(Object target) {
        if (mode != 3 || target == null) {
            return null;
        }
        return invocationTraceMap.findTrace(target);
    }

    public static InvocationHandler getInvocationHandler() {
        return invocationHandler;
    }

    public static Object getNewObjectForRecording(Class type, String signature) throws SecurityException, NoSuchMethodException {
        Constructor constructor = MethodCache.findConstructor(type, signature);
        return Mockingbird.getNewObjectForRecording(constructor);
    }

    public static Object getNewObjectForRecording(Constructor constructor) {
        try {
            Class declaringClass = constructor.getDeclaringClass();
            Object object = Mockingbird.getProxyObject(declaringClass);
            tapeForConstructor.add(constructor, object, declaringClass.getClassLoader() == null && Modifier.isFinal(declaringClass.getModifiers()));
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getProxyObject(Class type) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, ClassNotFoundException {
        return MockingbirdProxy.getObject(type);
    }

    public static Object getProxyObject(String className) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException {
        return Mockingbird.getProxyObject(Class.forName(className));
    }

    public static TapeVault getTapes() {
        return tapes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(String internalClassName, String methodName, String methodDesciption, boolean isStaticOrConstructor, Object thisObject, Object[] params, ClassLoader classLoader) throws Throwable {
        if (thisObject == null && !isStaticOrConstructor) {
            NullPointerException npe = new NullPointerException();
            throw Utils.popStackTrace(npe.fillInStackTrace());
        }
        boolean savedTopLevel = topLevel;
        Member method = MethodCache.find(thisObject, internalClassName, methodName, methodDesciption, classLoader);
        if (mode == 3) {
            Class<?> target = thisObject == null ? method.getDeclaringClass() : thisObject;
            invocationTraceMap.add(target, method.getName(), methodDesciption, params);
            if (topLevel) {
                lastCall = method;
                topLevel = false;
            }
        }
        if (method instanceof AccessibleObject) {
            ((AccessibleObject)((Object)method)).setAccessible(true);
        }
        if (params == null) {
            params = EMPTY_OBJECT_ARRAY;
        }
        try {
            Object object = invocationHandler.invoke(method, thisObject, params, internalClassName, methodName, methodDesciption);
            return object;
        }
        finally {
            if (mode == 3) {
                topLevel = savedTopLevel;
            }
        }
    }

    public static final Member getLastCall() {
        return lastCall;
    }

    public static void resetLastCall() {
        lastCall = null;
    }

    public static boolean isInNormalMode() {
        return mode == 0 || Mockingbird.isInClinit();
    }

    public static boolean isInPeekMode() {
        return peekMode;
    }

    public static boolean isInPlaybackMode() {
        return (mode == 2 || mode == 3) && !Mockingbird.isInClinit();
    }

    public static boolean isInRecordingMode() {
        return mode == 1 && !Mockingbird.isInClinit();
    }

    public static boolean isInTestMode() {
        return mode == 3 && !Mockingbird.isInClinit();
    }

    public static boolean objectHasRecording(Object targetObject) {
        return tapes.objectHasRecording(targetObject);
    }

    public static void replaceObjectForRecording(Class type, String signature, Object newObject) throws NoSuchMethodException {
        Constructor constructor = MethodCache.findConstructor(type, signature);
        tapeForConstructor.add(constructor, newObject, false);
    }

    public static void replaceObjectForRecording(Constructor constructor, Object newObject) {
        if (newObject == null) {
            throw new MockingbirdError("cannot replace object with null");
        }
        if (!constructor.getDeclaringClass().isInstance(newObject)) {
            throw new MockingbirdError("cannot replace with object of type '" + newObject.getClass().getName() + "'");
        }
        tapeForConstructor.add(constructor, newObject, false);
    }

    public static void setClinitThrowState(ClinitState value) {
        clinitState = value;
    }

    public static void setConstructorForException(Class type, String signature, Throwable exception) throws SecurityException, NoSuchMethodException {
        Constructor constructor = MethodCache.findConstructor(type, signature);
        Mockingbird.setConstructorForException(constructor, exception);
    }

    public static void setConstructorForException(Constructor constructor, Throwable exception) {
        tapeForConstructor.add(constructor, exception);
    }

    public static void setException(boolean ignoreParam, boolean ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, boolean ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, byte ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, byte ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, char ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, char ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, double ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, double ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, float ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, float ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, int ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, int ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, long ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, long ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, Object ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, Object ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignoreParam, short ignored, Throwable exception) {
        tapes.setException(ignoreParam, exception, 1);
    }

    public static void setException(boolean ignoreParam, short ignored, Throwable exception, int times) {
        tapes.setException(ignoreParam, exception, times);
    }

    public static void setException(boolean ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(boolean ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(byte ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(byte ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(char ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(char ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(double ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(double ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(float ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(float ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(int ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(int ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(long ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(long ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(Object ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(Object ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setException(short ignored, Throwable exception) {
        tapes.setException(false, exception, 1);
    }

    public static void setException(short ignored, Throwable exception, int times) {
        tapes.setException(false, exception, times);
    }

    public static void setExceptionForVoid(boolean ignoreParam, Throwable exception) {
        Mockingbird.setExceptionForVoid(ignoreParam, exception, 1);
    }

    public static void setExceptionForVoid(boolean ignoreParam, Throwable exception, int times) {
        if (exception == null) {
            tapes.setReturnValue(ignoreParam, Tape.DO_NOTHING, times);
        } else {
            tapes.setException(ignoreParam, exception, times);
        }
    }

    public static void setExceptionForVoid(Throwable exception) {
        Mockingbird.setExceptionForVoid(false, exception, 1);
    }

    public static void setExceptionForVoid(Throwable exception, int times) {
        Mockingbird.setException(false, exception, times);
    }

    public static void setInvocationHandler(InvocationHandler handler) {
        if (!$assertionsDisabled && handler == null) {
            throw new AssertionError();
        }
        invocationHandler = handler;
    }

    public static void setNormalReturnForVoid() {
        tapes.setReturnValue(false, null, 1);
    }

    public static void setNormalReturnForVoid(boolean ignoreParam) {
        tapes.setReturnValue(ignoreParam, null, 1);
    }

    public static void setReturnValue(boolean isStatic, Object target, String signature, Object[] params, Object value, int times) {
        tapes.setRecordForSetReturnValue(isStatic, target, signature, params);
        tapes.setReturnValue(false, value, times);
    }

    public static void setReturnValue(Class target, String signature, Object value, int times) {
        tapes.setRecordForSetReturnValue(true, target, signature, new Object[0]);
        tapes.setReturnValue(true, value, times);
    }

    public static void setReturnValue(boolean isStatic, Object target, String signature, Object value, int times) {
        tapes.setRecordForSetReturnValue(isStatic, target, signature, new Object[0]);
        tapes.setReturnValue(true, value, times);
    }

    public static void setException(boolean isStatic, Object target, String signature, Object[] params, Throwable exception, int times) {
        tapes.setRecordForSetReturnValue(isStatic, target, signature, params);
        tapes.setException(false, exception, times);
    }

    public static void setException(boolean isStatic, Object target, String signature, Throwable exception, int times) {
        tapes.setRecordForSetReturnValue(isStatic, target, signature, new Object[0]);
        tapes.setException(true, exception, times);
    }

    public static void setException(Class target, String signature, Throwable exception, int times) {
        tapes.setRecordForSetReturnValue(true, target, signature, new Object[0]);
        tapes.setException(true, exception, times);
    }

    public static void setReturnValue(boolean ignored, boolean value) {
        tapes.setReturnValue(false, value ? Boolean.TRUE : Boolean.FALSE, 1);
    }

    public static void setReturnValue(boolean ignoreParam, boolean ignored, boolean value) {
        tapes.setReturnValue(ignoreParam, value ? Boolean.TRUE : Boolean.FALSE, 1);
    }

    public static void setReturnValue(boolean ignoreParam, boolean ignored, boolean value, int times) {
        tapes.setReturnValue(ignoreParam, value ? Boolean.TRUE : Boolean.FALSE, times);
    }

    public static void setReturnValue(boolean ignored, boolean value, int times) {
        tapes.setReturnValue(false, value ? Boolean.TRUE : Boolean.FALSE, times);
    }

    public static void setReturnValue(boolean ignoreParam, byte ignored, byte value) {
        tapes.setReturnValue(ignoreParam, new Byte(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, byte ignored, byte value, int times) {
        tapes.setReturnValue(ignoreParam, new Byte(value), times);
    }

    public static void setReturnValue(boolean ignoreParam, char ignored, char value) {
        tapes.setReturnValue(ignoreParam, new Character(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, char ignored, char value, int times) {
        tapes.setReturnValue(ignoreParam, new Character(value), times);
    }

    public static void setReturnValue(boolean ignoreParam, double ignored, double value) {
        tapes.setReturnValue(ignoreParam, new Double(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, double ignored, double value, int times) {
        tapes.setReturnValue(ignoreParam, new Double(value), times);
    }

    public static void setReturnValue(boolean ignoreParam, float ignored, float value) {
        tapes.setReturnValue(ignoreParam, new Float(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, float ignored, float value, int times) {
        tapes.setReturnValue(ignoreParam, new Float(value), times);
    }

    public static void setReturnValue(boolean ignoreParam, int ignored, int value) {
        tapes.setReturnValue(ignoreParam, new Integer(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, int ignored, int value, int times) {
        tapes.setReturnValue(ignoreParam, new Integer(value), times);
    }

    public static void setReturnValue(boolean ignoreParam, long ignored, long value) {
        tapes.setReturnValue(ignoreParam, new Long(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, long ignored, long value, int times) {
        tapes.setReturnValue(ignoreParam, new Long(value), times);
    }

    public static void setReturnValue(boolean ignoreParam, Object ignored, Object value) {
        tapes.setReturnValue(ignoreParam, value, 1);
    }

    public static void setReturnValue(boolean ignoreParam, Object ignored, Object value, int times) {
        tapes.setReturnValue(ignoreParam, value, times);
    }

    public static void setReturnValue(boolean ignoreParam, short ignored, short value) {
        tapes.setReturnValue(ignoreParam, new Short(value), 1);
    }

    public static void setReturnValue(boolean ignoreParam, short ignored, short value, int times) {
        tapes.setReturnValue(ignoreParam, new Short(value), times);
    }

    public static void setReturnValue(byte ignored, byte value) {
        tapes.setReturnValue(false, new Byte(value), 1);
    }

    public static void setReturnValue(byte ignored, byte value, int times) {
        tapes.setReturnValue(false, new Byte(value), times);
    }

    public static void setReturnValue(char ignored, char value) {
        tapes.setReturnValue(false, new Character(value), 1);
    }

    public static void setReturnValue(char ignored, char value, int times) {
        tapes.setReturnValue(false, new Character(value), times);
    }

    public static void setReturnValue(double ignored, double value) {
        tapes.setReturnValue(false, new Double(value), 1);
    }

    public static void setReturnValue(double ignored, double value, int times) {
        tapes.setReturnValue(false, new Double(value), times);
    }

    public static void setReturnValue(float ignored, float value) {
        tapes.setReturnValue(false, new Float(value), 1);
    }

    public static void setReturnValue(float ignored, float value, int times) {
        tapes.setReturnValue(false, new Float(value), times);
    }

    public static void setReturnValue(int ignored, int value) {
        tapes.setReturnValue(false, new Integer(value), 1);
    }

    public static void setReturnValue(int ignored, int value, int times) {
        tapes.setReturnValue(false, new Integer(value), times);
    }

    public static void setReturnValue(long ignored, long value) {
        tapes.setReturnValue(false, new Long(value), 1);
    }

    public static void setReturnValue(long ignored, long value, int times) {
        tapes.setReturnValue(false, new Long(value), times);
    }

    public static void setReturnValue(Object ignored, Object value) {
        tapes.setReturnValue(false, value, 1);
    }

    public static void setReturnValue(Object ignored, Object value, int times) {
        tapes.setReturnValue(false, value, times);
    }

    public static void setReturnValue(short ignored, short value) {
        tapes.setReturnValue(false, new Short(value), 1);
    }

    public static void setReturnValue(short ignored, short value, int times) {
        tapes.setReturnValue(false, new Short(value), times);
    }

    public static void startPeekMode() {
        peekMode = true;
        previousMode = mode;
        mode = 2;
    }

    public static boolean isCutClinitExceptionThrown() {
        return cutClinitException.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterClinit(String internalClassName) {
        Object object = clinitCountLock;
        synchronized (object) {
            clinitSet.add(internalClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitClinit(String internalClassName) {
        Object object = clinitCountLock;
        synchronized (object) {
            clinitSet.remove(internalClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInClinit() {
        Object object = clinitCountLock;
        synchronized (object) {
            return !clinitSet.isEmpty();
        }
    }

    private Mockingbird() {
    }

    static {
        $assertionsDisabled = !Mockingbird.class.desiredAssertionStatus();
        CLINIT_ALWAYS_THROWS = new ClinitState("Clinit always throws");
        CLINIT_THROWS_SUPPRESSED = new ClinitState("Clinit suppressed");
        CLINIT_THROWS_SUPPRESSED_AND_INTERCEPT = new ClinitState("Clinit suppressed and the class is replaced with an interceptor");
        clinitCanThrowSet = new HashSet();
        noMethodInterceptorSet = new HashSet();
        clinitState = CLINIT_THROWS_SUPPRESSED_AND_INTERCEPT;
        invocationHandler = new Caller();
        invocationTraceMap = new InvocationTraceMap();
        mode = 0;
        constructorExceptionsIgnoredSet = new HashSet();
        tapeForConstructor = new TapeForConstructor();
        tapes = new TapeVault();
        topLevel = true;
        lastCall = null;
        cutClinitException = new HashSet();
        EMPTY_OBJECT_ARRAY = new Object[0];
        clinitSet = new HashSet();
        clinitCountLock = new Object();
    }

    private static class ClinitState {
        private String name;

        private ClinitState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

