/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.MockingbirdError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.asm.Type;

public abstract class MethodCache {
    private static final Map memberMap = new ClassCacheMap(MethodCache.class.getName() + ".memberMap");
    private static final Object NO_SUCH_METHOD_MARKER = new Object();
    private static final Map stringToMethodMap = new ClassCacheMap(MethodCache.class.getName() + ".stringToMethodMap");
    private static final Map stringToStaticMethodMap = new ClassCacheMap(MethodCache.class.getName() + ".stringToStaticMethodMap");

    private static void addMemberToMap(Member member, boolean isStaticOrConstrcutor, Class type, String name, String descriptor) {
        HashMap<String, Object> memberMap;
        Map map = isStaticOrConstrcutor ? stringToStaticMethodMap : stringToMethodMap;
        HashMap<String, HashMap<String, Object>> clsMap = (HashMap<String, HashMap<String, Object>>)map.get(type);
        if (clsMap == null) {
            clsMap = new HashMap<String, HashMap<String, Object>>();
            map.put(type, clsMap);
        }
        if ((memberMap = (HashMap<String, Object>)clsMap.get(name)) == null) {
            memberMap = new HashMap<String, Object>();
            clsMap.put(name, memberMap);
        }
        memberMap.put(descriptor, member == null ? NO_SUCH_METHOD_MARKER : member);
    }

    public static void clear() {
        memberMap.clear();
        MethodCache.clearMap(stringToMethodMap);
        MethodCache.clearMap(stringToStaticMethodMap);
    }

    private static void clearMap(Map stringMap) {
        Iterator iter = stringMap.values().iterator();
        while (iter.hasNext()) {
            Map map = (Map)iter.next();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Map map2 = (Map)iterator.next();
                map2.clear();
            }
            map.clear();
        }
        stringMap.clear();
    }

    public static String computeDescriptor(Class[] parameters, Class returnType) {
        StringBuffer buffer = new StringBuffer();
        MethodCache.computeDescriptor(parameters, returnType, buffer);
        return buffer.toString();
    }

    public static void computeDescriptor(Class[] parameters, Class returnType, StringBuffer buffer) {
        buffer.append("(");
        for (int i = 0; i < parameters.length; ++i) {
            Class type = parameters[i];
            ClassCache.getInternalName(type, buffer);
        }
        buffer.append(")");
        ClassCache.getInternalName(returnType, buffer);
    }

    private static Signature computeSignature(Class type, String methodName, Class[] params, Class returnType) {
        StringBuffer shortBuf = new StringBuffer();
        shortBuf.append(methodName);
        MethodCache.computeDescriptor(params, returnType, shortBuf);
        StringBuffer fullBuf = new StringBuffer();
        fullBuf.append(type.getName().replace('.', '/'));
        fullBuf.append(".");
        fullBuf.append(shortBuf.toString());
        return new Signature(shortBuf.toString(), fullBuf.toString());
    }

    private static Method find(Class thisClass, String methodName, Class[] paramTypes) {
        if (thisClass == null) {
            return null;
        }
        Method declaredMethod = null;
        try {
            declaredMethod = thisClass.getDeclaredMethod(methodName, paramTypes);
            if (Modifier.isAbstract(declaredMethod.getModifiers())) {
                declaredMethod = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (declaredMethod == null) {
            return MethodCache.find(thisClass.getSuperclass(), methodName, paramTypes);
        }
        return declaredMethod;
    }

    public static Member find(Object thisObject, String internalClassName, String methodName, String methodDescription, ClassLoader classLoader) {
        Class thisClass;
        if (thisObject == null && internalClassName == null) {
            throw new MockingbirdError("Both object and class name are null");
        }
        boolean isStaticOrConstructor = thisObject == null || methodName.equals("<init>");
        Object obj = MethodCache.findMemberFromMap(isStaticOrConstructor, thisClass = MethodCache.findClass(thisObject, internalClassName, classLoader), methodName, methodDescription);
        if (obj == null) {
            Member method = null;
            if (isStaticOrConstructor) {
                method = MethodCache.findConstructorOrStaticMethod(methodName, methodDescription, thisClass);
            } else if (Proxy.class.isInstance(thisObject)) {
                try {
                    method = thisClass.getMethod(methodName, MethodCache.getParamTypes(methodDescription, classLoader));
                }
                catch (Exception e) {
                    method = null;
                }
            } else {
                method = MethodCache.find(thisClass, methodName, MethodCache.getParamTypes(methodDescription, classLoader));
            }
            MethodCache.addMemberToMap(method, isStaticOrConstructor, thisClass, methodName, methodDescription);
            if (method == null) {
                if (thisObject != null) {
                    AgitarLogger.getUserLogger().warning(thisObject.getClass().getName());
                }
                throw new MockingbirdError("Cannot find method: " + MethodCache.getFullSignature(internalClassName, methodName, methodDescription));
            }
            return method;
        }
        if (obj == NO_SUCH_METHOD_MARKER) {
            throw new MockingbirdError("Cannot find method: " + MethodCache.getFullSignature(internalClassName, methodName, methodDescription));
        }
        return (Member)obj;
    }

    private static Class findClass(Object thisObject, String className, ClassLoader classLoader) {
        if (thisObject == null && className == null) {
            throw new IllegalArgumentException("Both class and internal name cannot be null");
        }
        boolean isProxyObject = Proxy.class.isInstance(thisObject);
        if (isProxyObject && className == null) {
            throw new IllegalArgumentException("Class name of proxy object cannot be null");
        }
        if (thisObject == null || isProxyObject) {
            return ClassCache.getClassFromInternalName(className, classLoader, false);
        }
        return thisObject.getClass();
    }

    public static Constructor findConstructor(Class type, String descriptor) throws NoSuchMethodException {
        if (type == null || type.isPrimitive() || type.isArray()) {
            throw new MockingbirdError("Class cannot be null or primitive or array types");
        }
        if (type == null || descriptor == null || descriptor.length() == 0) {
            throw new MockingbirdError("Descriptor cannot be null or empty");
        }
        int left = descriptor.indexOf(40);
        int right = descriptor.indexOf(41);
        if (left < 0 || right < 0 || right < left) {
            throw new MockingbirdError("mal-formed method signature: " + descriptor);
        }
        String signature = type.getName() + ".<init>" + descriptor.substring(left, right + 1);
        Class[] params = null;
        try {
            ClassName[] paramTypes = new MethodSignature(signature).getParamTypes();
            params = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                ClassName name = paramTypes[i];
                params[i] = ClassCache.getClassFromInternalName(name.getBytecodeName(), type.getClassLoader(), true);
            }
        }
        catch (RuntimeException e) {
            throw new MockingbirdError(e);
        }
        Constructor constructor = type.getDeclaredConstructor(params);
        return constructor;
    }

    private static Member findConstructorOrStaticMethod(String methodName, String methodDescription, Class thisClass) throws MockingbirdError {
        Executable method;
        try {
            ClassLoader classLoader;
            ClassLoader classLoader2 = classLoader = thisClass == null ? null : thisClass.getClassLoader();
            method = methodName.equals("<init>") ? thisClass.getDeclaredConstructor(MethodCache.getParamTypes(methodDescription, classLoader)) : MethodCache.find(thisClass, methodName, MethodCache.getParamTypes(methodDescription, classLoader));
        }
        catch (Exception e) {
            throw new MockingbirdError(e);
        }
        return method;
    }

    private static Object findMemberFromMap(boolean isStaticOrConstrcutor, Class type, String name, String descriptor) {
        Map memberMap;
        Map map = isStaticOrConstrcutor ? stringToStaticMethodMap : stringToMethodMap;
        Map clsMap = (Map)map.get(type);
        if (clsMap != null && (memberMap = (Map)clsMap.get(name)) != null) {
            return memberMap.get(descriptor);
        }
        return null;
    }

    private static Signature findSignature(Constructor constructor) {
        Signature sig = (Signature)memberMap.get(constructor);
        if (sig == null) {
            Class declaringClass = constructor.getDeclaringClass();
            sig = MethodCache.computeSignature(declaringClass, "<init>", constructor.getParameterTypes(), Void.TYPE);
            memberMap.put(constructor, sig);
        }
        return sig;
    }

    private static Signature findSignature(Method method) {
        Signature sig = (Signature)memberMap.get(method);
        if (sig == null) {
            Class<?> declaringClass = method.getDeclaringClass();
            sig = MethodCache.computeSignature(declaringClass, method.getName(), method.getParameterTypes(), method.getReturnType());
            memberMap.put(method, sig);
        }
        return sig;
    }

    public static String getFullSignature(Constructor constructor) {
        return MethodCache.findSignature(constructor).fullSignature;
    }

    public static String getFullSignature(Method method) {
        return MethodCache.findSignature(method).fullSignature;
    }

    public static String getFullSignature(String internalClassName, String methodName, String methodDesciption) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(internalClassName);
        buffer.append('.');
        buffer.append(methodName);
        buffer.append(methodDesciption);
        return buffer.toString();
    }

    public static String getInternalSignature(Constructor constructor) {
        StringBuffer buf = new StringBuffer();
        buf.append("<init>");
        MethodCache.computeDescriptor(constructor.getParameterTypes(), Void.TYPE, buf);
        return buf.toString();
    }

    public static String getInternalSignature(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getName());
        MethodCache.computeDescriptor(method.getParameterTypes(), method.getReturnType(), buf);
        return buf.toString();
    }

    private static Class[] getParamTypes(String methodDescription, ClassLoader classLoader) {
        Type[] types = Type.getArgumentTypes((String)methodDescription);
        Class[] params = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            params[i] = ClassCache.getClassFromInternalName(types[i].getDescriptor(), classLoader, true);
        }
        return params;
    }

    public static String getSignature(Constructor constructor) {
        return MethodCache.findSignature(constructor).shortSignature;
    }

    public static String getSignature(Method method) {
        return MethodCache.findSignature(method).shortSignature;
    }

    private MethodCache() {
    }

    private static class Signature {
        private final String fullSignature;
        private final String shortSignature;

        Signature(String shortSignature, String fullSignature) {
            this.shortSignature = shortSignature;
            this.fullSignature = fullSignature;
        }
    }
}

