/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.common.logging.AgitarLogger;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class FileNameMap {
    private static final Properties map;
    private static final Set reported;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileNameMap() {
    }

    public static void clear() {
        map.clear();
        reported.clear();
    }

    public static String findFileName(final File file) {
        if (map.isEmpty()) {
            return file.getPath();
        }
        try {
            String canonicalPath = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return file.getCanonicalFile().getAbsolutePath();
                }
            });
            String subsitute = (String)map.get(canonicalPath);
            if (subsitute != null) {
                if (reported.add(canonicalPath)) {
                    String subs = FileNameMap.getSimpePath(subsitute);
                    AgitarLogger.getUserLogger().info("File '" + canonicalPath + "' is mapped to '" + subs + "'");
                }
                return subsitute;
            }
        }
        catch (IOException e) {
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        return file.getPath();
    }

    private static String getCanonicalPath(String name) {
        File file = new File(name);
        try {
            return file.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static Properties getMap() {
        return map;
    }

    static String getSimpePath(String subsitute) throws IOException {
        String abs = new File(".").getAbsolutePath();
        try {
            abs = new File(".").getCanonicalFile().getAbsolutePath();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String subs = subsitute.substring(abs.length() + 1);
        return subs;
    }

    public static void put(String name, String subsitute) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && subsitute == null) {
            throw new AssertionError();
        }
        map.put(FileNameMap.getCanonicalPath(name), FileNameMap.getCanonicalPath(subsitute));
    }

    public static void putAll(Properties prop) {
        map.putAll((Map<?, ?>)prop);
    }

    static {
        $assertionsDisabled = !FileNameMap.class.desiredAssertionStatus();
        map = new Properties();
        reported = new HashSet();
    }
}

