/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.invocation.CallRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.SocketHandler;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public abstract class DefaultValueMap {
    public static final Byte BYTE_ZERO = new Byte(0);
    private static final Map defaultValueMap = new HashMap();
    public static final Double DOUBLE_ZERO = new Double(0.0);
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Float FLOAT_ZERO = new Float(0.0f);
    public static final Integer INTEGER_ZERO = new Integer(0);
    public static final Long LONG_ZERO = new Long(0L);
    public static int MARKER_FOR_INTERCEPTOR_END = 0;
    public static int MARKER_FOR_INTERCEPTOR_START = 0;
    private static Method mockingbirdGetProxyObjectMethod;
    public static final Short SHORT_ZERO;
    public static final Character SPACE_CHAR;
    static /* synthetic */ Class array$B;

    private static void addClassConstructorToMap(Class constructorClass) {
        DefaultValueMap.addClassConstructorToMap(constructorClass, new Class[]{constructorClass});
    }

    private static void addClassConstructorToMap(Class constructorClass, Class[] classes) {
        Constructor constructor = DefaultValueMap.getDefaultConstructor(constructorClass);
        if (constructor != null) {
            ValueGeneratorUsingDefaultConstructor generator = new ValueGeneratorUsingDefaultConstructor(constructor);
            DefaultValueMap.addGeneratorToMap(generator, classes);
        }
    }

    private static void addClassMethodToMap(final Class type, final String methodName) {
        defaultValueMap.put(type, new ValueGenerator(){

            public CallRecord getCallRecord() {
                return DefaultValueMap.createCallRecord(type, methodName);
            }
        });
    }

    private static void addConstantValueToMap(Object value, Class[] classes) {
        DefaultValueMap.addGeneratorToMap(new ConstantValueGenerator(value), classes);
    }

    private static void addGeneratorToMap(ValueGenerator generator, Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            defaultValueMap.put(classes[i], generator);
        }
    }

    private static void addJavaIO() {
        DefaultValueMap.addClassConstructorToMap(StringWriter.class, new Class[]{Writer.class, StringWriter.class});
        DefaultValueMap.addClassConstructorToMap(ByteArrayOutputStream.class, new Class[]{OutputStream.class, ByteArrayOutputStream.class});
        DefaultValueMap.addGeneratorToMap(new ValueGenerator(){

            public CallRecord getCallRecord() {
                CallRecord callRecord = DefaultValueMap.createCallRecord(class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = DefaultValueMap.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array, "newInstance", new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = DefaultValueMap.class$("java.lang.Class")) : class$java$lang$Class, Integer.TYPE}, new Object[]{Byte.TYPE, INTEGER_ZERO});
                callRecord.setNext(DefaultValueMap.createCallRecordForConstructor(class$java$io$ByteArrayInputStream == null ? (class$java$io$ByteArrayInputStream = DefaultValueMap.class$("java.io.ByteArrayInputStream")) : class$java$io$ByteArrayInputStream, new Class[]{array$B == null ? (array$B = DefaultValueMap.class$("[B")) : array$B}, new Object[]{callRecord.getReturnValue()}));
                return callRecord;
            }
        }, new Class[]{InputStream.class, ByteArrayInputStream.class});
        DefaultValueMap.addGeneratorToMap(new ValueGenerator(){
            private final Object[] value = new Object[]{""};

            public CallRecord getCallRecord() {
                return DefaultValueMap.createCallRecordForConstructor(class$java$io$StringReader == null ? (class$java$io$StringReader = DefaultValueMap.class$("java.io.StringReader")) : class$java$io$StringReader, new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultValueMap.class$("java.lang.String")) : class$java$lang$String}, this.value);
            }
        }, new Class[]{Reader.class, StringReader.class});
    }

    private static void addJavaLogging() {
        DefaultValueMap.addClassMethodToMap(Logger.class, "getAnonymousLogger");
        DefaultValueMap.addClassConstructorToMap(ErrorManager.class);
        DefaultValueMap.addClassConstructorToMap(FileHandler.class, new Class[]{Handler.class, StreamHandler.class, FileHandler.class});
        DefaultValueMap.addClassConstructorToMap(SocketHandler.class);
        DefaultValueMap.addClassConstructorToMap(SimpleFormatter.class, new Class[]{Formatter.class, SimpleFormatter.class});
        DefaultValueMap.addClassConstructorToMap(XMLFormatter.class);
    }

    private static void addJavaNet() {
        DefaultValueMap.addClassConstructorToMap(Socket.class);
        DefaultValueMap.addClassConstructorToMap(ServerSocket.class);
    }

    private static void addJavaUtil() {
        DefaultValueMap.addClassConstructorToMap(LinkedHashSet.class, new Class[]{Collection.class, AbstractCollection.class, Set.class, AbstractSet.class, HashSet.class, LinkedHashSet.class});
        DefaultValueMap.addClassConstructorToMap(TreeSet.class, new Class[]{SortedSet.class, TreeSet.class});
        DefaultValueMap.addClassConstructorToMap(ArrayList.class, new Class[]{List.class, AbstractList.class, ArrayList.class});
        DefaultValueMap.addClassConstructorToMap(LinkedList.class, new Class[]{AbstractSequentialList.class, LinkedList.class});
        DefaultValueMap.addClassConstructorToMap(Vector.class);
        DefaultValueMap.addClassConstructorToMap(LinkedHashMap.class, new Class[]{Map.class, AbstractMap.class, HashMap.class, LinkedHashMap.class});
        DefaultValueMap.addClassConstructorToMap(IdentityHashMap.class);
        DefaultValueMap.addClassConstructorToMap(WeakHashMap.class);
        DefaultValueMap.addClassConstructorToMap(TreeMap.class, new Class[]{SortedMap.class, TreeMap.class});
        DefaultValueMap.addClassConstructorToMap(Hashtable.class, new Class[]{Dictionary.class, Hashtable.class});
        DefaultValueMap.addClassConstructorToMap(BitSet.class);
        DefaultValueMap.addClassConstructorToMap(Stack.class);
        DefaultValueMap.addClassConstructorToMap(Date.class);
        DefaultValueMap.addClassConstructorToMap(Properties.class);
        DefaultValueMap.addClassConstructorToMap(Random.class);
        DefaultValueMap.addClassConstructorToMap(Timer.class);
        DefaultValueMap.addClassMethodToMap(Calendar.class, "getInstance");
        DefaultValueMap.addClassMethodToMap(Locale.class, "getDefault");
        DefaultValueMap.addClassMethodToMap(TimeZone.class, "getDefault");
        defaultValueMap.put(Currency.class, new ValueGenerator(){

            public CallRecord getCallRecord() {
                CallRecord record = DefaultValueMap.createCallRecord(class$java$util$Locale == null ? (class$java$util$Locale = DefaultValueMap.class$("java.util.Locale")) : class$java$util$Locale, "getDefault");
                record.setNext(DefaultValueMap.createCallRecord(class$java$util$Currency == null ? (class$java$util$Currency = DefaultValueMap.class$("java.util.Currency")) : class$java$util$Currency, "getInstance", new Class[]{class$java$util$Locale == null ? (class$java$util$Locale = DefaultValueMap.class$("java.util.Locale")) : class$java$util$Locale}, new Object[]{record.getReturnValue()}));
                return record;
            }
        });
        defaultValueMap.put(Enumeration.class, new ValueGenerator(){

            public CallRecord getCallRecord() {
                CallRecord record = DefaultValueMap.createCallRecordForConstructor(class$java$util$Vector == null ? (class$java$util$Vector = DefaultValueMap.class$("java.util.Vector")) : class$java$util$Vector, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
                record.setNext(DefaultValueMap.createCallRecord(class$java$util$Vector == null ? (class$java$util$Vector = DefaultValueMap.class$("java.util.Vector")) : class$java$util$Vector, "elements", record.getReturnValue(), EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY));
                return record;
            }
        });
        defaultValueMap.put(Iterator.class, new ValueGenerator(){

            public CallRecord getCallRecord() {
                CallRecord record = DefaultValueMap.createCallRecordForConstructor(class$java$util$HashSet == null ? (class$java$util$HashSet = DefaultValueMap.class$("java.util.HashSet")) : class$java$util$HashSet, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
                record.setNext(DefaultValueMap.createCallRecord(class$java$util$HashSet == null ? (class$java$util$HashSet = DefaultValueMap.class$("java.util.HashSet")) : class$java$util$HashSet, "iterator", record.getReturnValue(), EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY));
                return record;
            }
        });
    }

    private static CallRecord createCallRecord(Class type, String name) {
        return DefaultValueMap.createCallRecord(type, name, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    private static CallRecord createCallRecord(Class type, String name, Class[] paramTypes, Object[] paramValues) {
        return DefaultValueMap.createCallRecord(type, name, null, paramTypes, paramValues);
    }

    private static CallRecord createCallRecord(Class type, String name, Object thisObject, Class[] paramTypes, Object[] paramValues) {
        try {
            Method method = type.getMethod(name, paramTypes);
            return new CallRecord(method, thisObject, paramValues, method.invoke(thisObject, paramValues));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static CallRecord createCallRecordForConstructor(Class type, Class[] paramTypes, Object[] paramValues) {
        try {
            Constructor constructor = type.getConstructor(paramTypes);
            return new CallRecord(constructor, null, paramValues, constructor.newInstance(paramValues));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class type) {
        try {
            return type.getConstructor(EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getDefaultValue(Class type) {
        return DefaultValueMap.getDefaultValue(type, true);
    }

    public static Object getDefaultValue(Class type, boolean allowProxy) {
        if (type.isArray()) {
            CallRecord callRecord = DefaultValueMap.createCallRecord(Array.class, "newInstance", new Class[]{Class.class, Integer.TYPE}, new Object[]{type.getComponentType(), INTEGER_ZERO});
            Mockingbird.getInvocationHandler().recordCall(callRecord, false);
            return callRecord.getReturnValue();
        }
        DefaultValueMap.initDefaultValueMap();
        ValueGenerator generator = (ValueGenerator)defaultValueMap.get(type);
        if (generator != null) {
            if (generator instanceof ConstantValueGenerator) {
                return ((ConstantValueGenerator)generator).value;
            }
            CallRecord callRecord = generator.getCallRecord();
            if (callRecord != null) {
                Mockingbird.getInvocationHandler().recordCall(callRecord, false);
                Object returnValue = callRecord.getReturnValue();
                for (CallRecord next = callRecord.getNext(); next != null; next = next.getNext()) {
                    Mockingbird.getInvocationHandler().recordCall(next, false);
                    returnValue = next.getReturnValue();
                }
                return returnValue;
            }
            return null;
        }
        if (allowProxy && Modifier.isInterface(type.getModifiers())) {
            try {
                Object proxyObject = Mockingbird.getProxyObject(type);
                Mockingbird.getInvocationHandler().recordCall(new CallRecord(DefaultValueMap.getMockingbirdGetProxyObjectMethod(), null, new Object[]{type}, proxyObject), false);
                return proxyObject;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public static Object getDefaultValue(String internalName) {
        return DefaultValueMap.getDefaultValue(ClassCache.getClassFromInternalName(internalName));
    }

    private static Method getMockingbirdGetProxyObjectMethod() {
        if (mockingbirdGetProxyObjectMethod == null) {
            try {
                mockingbirdGetProxyObjectMethod = Mockingbird.class.getMethod("getProxyObject", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mockingbirdGetProxyObjectMethod;
    }

    private static void initDefaultValueMap() {
        if (defaultValueMap.size() > 0) {
            return;
        }
        DefaultValueMap.addConstantValueToMap("", new Class[]{Void.TYPE, String.class});
        DefaultValueMap.addClassConstructorToMap(StringBuffer.class, new Class[]{StringBuffer.class});
        DefaultValueMap.addClassMethodToMap(Runtime.class, "getRuntime");
        DefaultValueMap.addConstantValueToMap(Boolean.FALSE, new Class[]{Boolean.class, Boolean.TYPE});
        DefaultValueMap.addConstantValueToMap(SPACE_CHAR, new Class[]{Character.class, Character.TYPE});
        DefaultValueMap.addConstantValueToMap(BYTE_ZERO, new Class[]{Byte.class, Byte.TYPE});
        DefaultValueMap.addConstantValueToMap(SHORT_ZERO, new Class[]{Short.class, Short.TYPE});
        DefaultValueMap.addConstantValueToMap(INTEGER_ZERO, new Class[]{Number.class, Integer.TYPE, Integer.class});
        DefaultValueMap.addConstantValueToMap(LONG_ZERO, new Class[]{Long.class, Long.TYPE});
        DefaultValueMap.addConstantValueToMap(FLOAT_ZERO, new Class[]{Float.class, Float.TYPE});
        DefaultValueMap.addConstantValueToMap(DOUBLE_ZERO, new Class[]{Double.class, Double.TYPE});
        DefaultValueMap.addClassConstructorToMap(SimpleDateFormat.class, new Class[]{Format.class, DateFormat.class, SimpleDateFormat.class});
        DefaultValueMap.addClassConstructorToMap(DecimalFormat.class, new Class[]{NumberFormat.class, DecimalFormat.class});
        DefaultValueMap.addJavaUtil();
        DefaultValueMap.addJavaIO();
        DefaultValueMap.addJavaNet();
        DefaultValueMap.addJavaLogging();
    }

    private DefaultValueMap() {
    }

    static {
        SHORT_ZERO = new Short(0);
        SPACE_CHAR = new Character(' ');
    }

    private static class ValueGeneratorUsingDefaultConstructor
    implements ValueGenerator {
        private final Constructor constructor;

        ValueGeneratorUsingDefaultConstructor(Constructor constructor) {
            this.constructor = constructor;
            this.constructor.setAccessible(true);
        }

        public CallRecord getCallRecord() {
            try {
                return new CallRecord(this.constructor, null, EMPTY_OBJECT_ARRAY, this.constructor.newInstance(EMPTY_OBJECT_ARRAY));
            }
            catch (Throwable e) {
                return null;
            }
        }
    }

    private static interface ValueGenerator {
        public CallRecord getCallRecord();
    }

    private static class ConstantValueGenerator
    implements ValueGenerator {
        private final Object value;

        ConstantValueGenerator(Object value) {
            this.value = value;
        }

        public CallRecord getCallRecord() {
            throw new UnsupportedOperationException();
        }
    }
}

