/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import com.agitar.common.util.ClassCacheMap;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.lib.mockingbird.MockingbirdError;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassCache {
    private static final Map classToInternalNameMap = new ClassCacheMap(ClassCache.class.getName() + ".classToInternalNameMap");
    private static final Map internalNameToClassMap = new ClassCacheMap(ClassCache.class.getName() + ".internalNameToClassMap");
    private static final Map primitiveInternalNameToClassMap = new ClassCacheMap(ClassCache.class.getName() + ".primitiveInternalNameToClassMap");
    private static final Object[][] primitiveTypes = new Object[][]{{"V", Void.TYPE}, {"Z", Boolean.TYPE}, {"B", Byte.TYPE}, {"C", Character.TYPE}, {"S", Short.TYPE}, {"I", Integer.TYPE}, {"J", Long.TYPE}, {"F", Float.TYPE}, {"D", Double.TYPE}};

    public static void clear() {
        Map[] maps = internalNameToClassMap.values().toArray(new Map[internalNameToClassMap.values().size()]);
        for (int i = 0; i < maps.length; ++i) {
            Map map = maps[i];
            map.clear();
        }
        internalNameToClassMap.clear();
        primitiveInternalNameToClassMap.clear();
        classToInternalNameMap.clear();
    }

    public static Class getClassFromInternalName(String internalName) {
        return ClassCache.getClassFromInternalName(internalName, null, true);
    }

    public static Class getClassFromInternalName(String internalName, ClassLoader classLoader, boolean maybePrimitive) {
        int lastBracket;
        String className;
        ClassCache.init();
        Class<?> type = null;
        if (maybePrimitive && (type = (Class<?>)primitiveInternalNameToClassMap.get(internalName)) != null) {
            return type;
        }
        ClassLoader contextClassLoader = classLoader == null ? ReflectionCacheRegistry.getContextClassLoader() : classLoader;
        HashMap map = (HashMap)internalNameToClassMap.get(contextClassLoader);
        if (map == null) {
            map = new HashMap();
            internalNameToClassMap.put(contextClassLoader, map);
        }
        if (!internalName.endsWith(";") && !primitiveInternalNameToClassMap.containsKey(className = internalName.substring((lastBracket = internalName.lastIndexOf(91)) + 1))) {
            internalName = internalName.substring(0, lastBracket + 1) + 'L' + className + ';';
        }
        if ((type = (Class)map.get(internalName)) == null) {
            String name = internalName.replace('/', '.');
            if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
                name = name.substring(1, name.length() - 1);
            }
            try {
                type = Class.forName(name, false, contextClassLoader);
                map.put(internalName, type);
                classToInternalNameMap.put(type, internalName);
            }
            catch (ClassNotFoundException e) {
                throw new MockingbirdError(e.toString() + " using ClassLoader: " + contextClassLoader.toString(), e);
            }
        }
        return type;
    }

    public static void getInternalName(Class type, StringBuffer buffer) {
        ClassCache.init();
        String name = (String)classToInternalNameMap.get(type);
        if (name == null) {
            StringBuffer newBuffer;
            if (type.isArray()) {
                newBuffer = new StringBuffer();
                newBuffer.append('[');
                ClassCache.getInternalName(type.getComponentType(), newBuffer);
                name = newBuffer.toString();
            } else {
                newBuffer = new StringBuffer();
                newBuffer.append('L');
                newBuffer.append(type.getName().replace('.', '/'));
                newBuffer.append(';');
                name = newBuffer.toString();
            }
            classToInternalNameMap.put(type, name);
            ClassLoader classLoader = type.getClassLoader();
            HashMap<String, Class> map = (HashMap<String, Class>)internalNameToClassMap.get(classLoader);
            if (map == null) {
                map = new HashMap<String, Class>();
                internalNameToClassMap.put(classLoader, map);
            }
            map.put(name, type);
        }
        buffer.append(name);
    }

    private static void init() {
        if (classToInternalNameMap.size() == 0 || primitiveInternalNameToClassMap.size() == 0) {
            for (int i = 0; i < primitiveTypes.length; ++i) {
                primitiveInternalNameToClassMap.put(primitiveTypes[i][0], primitiveTypes[i][1]);
                classToInternalNameMap.put(primitiveTypes[i][1], primitiveTypes[i][0]);
            }
        }
    }

    private ClassCache() {
    }
}

