/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.mockingbird;

import [Ljava.lang.StackTraceElement;;
import com.agitar.common.asm.GettersAndSetters;
import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.DefaultValueMap;
import com.agitar.lib.mockingbird.MethodCache;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.MockingbirdError;
import com.agitar.lib.mockingbird.MockingbirdProxy;
import com.agitar.lib.mockingbird.Tape;
import com.agitar.lib.mockingbird.TypeMismatchedError;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.lib.mockingbird.Value;
import com.agitar.lib.mockingbird.invocation.CallRecord;
import com.agitar.lib.mockingbird.invocation.InvocationHandler;
import com.agitar.lib.mockingbird.invocation.Invoke;
import com.agitar.lib.mockingbird.java.util.ThreadController;
import com.agitar.lib.mockingbird.tape.ExceptionHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Caller
implements InvocationHandler {
    private static String TO_STRING_SIGNATURE;
    private static Object SET_STACK_TRACE;
    private static Object GET_STACK_TRACE;

    public static Value check(String internalClassName, Object thisObjectOrClass, String signature, Object[] parameters) throws Throwable {
        String descriptor;
        Class returnType;
        Class declaringClass;
        Value returnValue;
        if (Thread.currentThread().getThreadGroup().getParent() == null) {
            return null;
        }
        if (!Mockingbird.isInNormalMode() && (returnValue = Caller.checkMockingbird(declaringClass = internalClassName == null ? null : ClassCache.getClassFromInternalName(internalClassName, null, false), signature, thisObjectOrClass, parameters, returnType = ClassCache.getClassFromInternalName(descriptor = signature.substring(signature.lastIndexOf(41) + 1)))) != null) {
            return returnValue;
        }
        return null;
    }

    public static Value checkMockingbird(Class declaringClass, String signature, Object thisObject, Object[] parameters, Class returnType) throws Throwable {
        return Caller.checkMockingbird(declaringClass, signature, thisObject, parameters, returnType, false);
    }

    private static Value checkMockingbird(Class declaringClass, String signature, Object thisObject, Object[] parameters, Class returnType, boolean isNative) throws Throwable {
        boolean isStatic;
        if (Thread.currentThread().getThreadGroup().getParent() == null) {
            return null;
        }
        boolean bl = isStatic = declaringClass != null;
        if (Mockingbird.isInRecordingMode()) {
            Mockingbird.getTapes().setRecordForSetReturnValue(isStatic, isStatic ? declaringClass : thisObject, signature, parameters);
            return new Value(DefaultValueMap.getDefaultValue(returnType));
        }
        if (Mockingbird.isInPlaybackMode()) {
            Value returnValue = Caller.playback(declaringClass, signature, thisObject, parameters, returnType);
            if (Value.DO_ORIGINAL == returnValue) {
                return null;
            }
            if (returnValue != null) {
                return returnValue;
            }
            if (isNative) {
                return null;
            }
            if (thisObject != null && MockingbirdProxy.isBlankObject(thisObject)) {
                if (signature.endsWith(")V")) {
                    return Value.NULL;
                }
                if (!isStatic && Caller.isToStringMethod(signature)) {
                    return new Value(Utils.computeToString(thisObject));
                }
                throw new MockingbirdError.NoRecordingInTapeError(Utils.getPrettySignature(signature));
            }
        }
        if (ThreadController.CONTROL_ON && thisObject instanceof Thread && "start()V".equals(signature)) {
            ThreadController.start((Thread)thisObject);
        }
        return null;
    }

    public static Object convertValue(Class type, Object value) throws TypeMismatchedError {
        if (Void.TYPE.equals(type)) {
            return null;
        }
        if (value == Tape.NULL_OBJECT) {
            if (type.isPrimitive()) {
                throw new TypeMismatchedError(type, Object.class);
            }
            return null;
        }
        if (type.isPrimitive()) {
            return Utils.convertPrimitive(type, value);
        }
        if (type.isInstance(value)) {
            return value;
        }
        throw new TypeMismatchedError(type, value.getClass());
    }

    private static boolean isSystemCall(Object thisObject, Method method) {
        Class<?> type = null;
        if (method.equals(Caller.getSetStackTraceMethod()) || method.equals(Caller.getGetStackTraceMethod())) {
            return true;
        }
        type = thisObject == null || Modifier.isFinal(method.getModifiers()) ? method.getDeclaringClass() : thisObject.getClass();
        ClassLoader cl = type.getClassLoader();
        return cl == null || cl == ClassLoader.getSystemClassLoader();
    }

    private static Object getSetStackTraceMethod() {
        if (SET_STACK_TRACE == null) {
            try {
                SET_STACK_TRACE = Throwable.class.getDeclaredMethod("setStackTrace", StackTraceElement;.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SET_STACK_TRACE;
    }

    private static Object getGetStackTraceMethod() {
        if (GET_STACK_TRACE == null) {
            try {
                GET_STACK_TRACE = Throwable.class.getDeclaredMethod("getStackTrace", new Class[0]);
            }
            catch (Exception exc) {
                GET_STACK_TRACE = new Object();
            }
        }
        return GET_STACK_TRACE;
    }

    private static boolean isToStringMethod(String signature) {
        if (TO_STRING_SIGNATURE == null) {
            try {
                TO_STRING_SIGNATURE = MethodCache.getSignature(Object.class.getMethod("toString", new Class[0]));
            }
            catch (Throwable e) {
                TO_STRING_SIGNATURE = "";
            }
        }
        return TO_STRING_SIGNATURE.equals(signature);
    }

    private static Value playback(Class declaringClass, String signature, Object thisObject, Object[] params, Class returnType) throws Throwable {
        String className;
        GettersAndSetters gettersAndSetters;
        boolean isStatic = declaringClass != null;
        Object target = isStatic ? declaringClass : thisObject;
        Object value = Mockingbird.getTapes().playback(isStatic, target, signature, params);
        if (Value.DO_ORIGINAL == value) {
            return Value.DO_ORIGINAL;
        }
        if (value != null) {
            if (value instanceof ExceptionHolder) {
                Utils.handleExceptions(value, Utils.getExceptions(isStatic, target, signature), signature);
            } else {
                return new Value(Caller.convertValue(returnType, value));
            }
        }
        if (!isStatic && thisObject != null && MockingbirdProxy.isBlankObject(thisObject) && ((gettersAndSetters = GettersAndSetters.getInstance()).isGetter(className = thisObject.getClass().getName(), signature) || gettersAndSetters.isSetter(className, signature))) {
            return Value.DO_ORIGINAL;
        }
        return null;
    }

    protected Object callConstructor(Constructor constructor, Object[] parameters, String internalClassName, String methodName, String methodDesciption) throws Throwable {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (InvocationTargetException throwable) {
            throw throwable.getTargetException();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected Value intercept(Method member, Object thisObject, Object[] parameters, String internalClassName, String methodName, String methodDesciption) throws Throwable {
        return null;
    }

    public Object invoke(Member member, Object thisObject, Object[] parameters, String internalClassName, String methodName, String methodDesciption) throws Throwable {
        if (member == null) {
            throw new MockingbirdError("member is null");
        }
        if (member instanceof Constructor) {
            Object dubbedObject;
            Constructor constructor = (Constructor)member;
            constructor.setAccessible(true);
            if (!Mockingbird.isInClinit() && (dubbedObject = Mockingbird.dub(constructor)) != null) {
                return dubbedObject;
            }
            return this.callConstructor(constructor, parameters, internalClassName, methodName, methodDesciption);
        }
        Method method = (Method)member;
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (thisObject == null && !isStatic) {
            throw new NullPointerException();
        }
        method.setAccessible(true);
        if (!Mockingbird.isInClinit()) {
            Value returnValue = this.intercept(method, thisObject, parameters, internalClassName, methodName, methodDesciption);
            if (returnValue != null) {
                return returnValue.getValue();
            }
            boolean isNative = Modifier.isNative(method.getModifiers());
            if (Caller.isSystemCall(thisObject, method) || MockingbirdProxy.isMockingbirdProxy(thisObject) || isNative) {
                String signature;
                if (parameters == null) {
                    parameters = DefaultValueMap.EMPTY_OBJECT_ARRAY;
                }
                if ((returnValue = Caller.checkMockingbird(isStatic ? method.getDeclaringClass() : null, signature = MethodCache.getSignature(method), thisObject, parameters, method.getReturnType(), isNative)) != null) {
                    return returnValue.getValue();
                }
            }
        }
        if (ThreadController.CONTROL_ON && !Mockingbird.isInClinit() && thisObject instanceof Thread && "start".equals(methodName) && "()V".equals(methodDesciption)) {
            ThreadController.start((Thread)thisObject);
            return Void.TYPE;
        }
        return Invoke.execute(method, thisObject, parameters);
    }

    public void recordCall(CallRecord callRecord, boolean setExpectation) {
    }

    public void recordGetProxyObject(Class type, Object returnValue) {
    }
}

