/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.junit;

import com.agitar.common.types.ClassName;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.lib.junit.AgitarTestCase;
import com.agitar.lib.mockingbird.FileNameMap;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.MockingbirdSystem;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.security.AgPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class AgitarTestUtility {
    public static double EPSILON;
    private static Object[] NO_PARMS;
    private static final Map staticFields;
    private static final String DEFAULT_MESSAGE = "expected: <current date> but was: <{0}>";
    private static final TimeZone originalTimeZone;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void setUp() {
        try {
            AgPolicy.setEnableTestCasePolicy((boolean)true);
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            Mockingbird.clear();
            AgitarTestUtility.resetNamingContext();
            MockingbirdSystem.setToNulllStream();
        }
        catch (Throwable e) {
            throw new RuntimeException("Please use Agitar Unit Test Runner to run the test.");
        }
    }

    private static void resetNamingContext() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = AgitarTestCase.class.getClassLoader();
            }
            Class.forName("org.agitar.mock.naming.MockContext", true, loader);
        }
        catch (Throwable x) {
            // empty catch block
        }
        try {
            new InitialContext().addToEnvironment("agitar$clear$context", new Object());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void tearDown() {
        AgPolicy.setEnableTestCasePolicy((boolean)false);
        TimeZone.setDefault(originalTimeZone);
        AgitarTestUtility.restoreStaticState();
        Mockingbird.endTestCase();
        MockingbirdSystem.restoreSystemInOutErr();
    }

    public static void storeStaticField(Class cls, String fieldName) throws NoSuchFieldException {
        Field field = AgitarTestUtility.findField(cls, fieldName);
        if (!staticFields.containsKey(field) && !Modifier.isFinal(field.getModifiers())) {
            try {
                field.setAccessible(true);
                staticFields.put(field, field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void restoreStaticState() {
        Iterator iterator = staticFields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Field field = (Field)entry.getKey();
            Object value = entry.getValue();
            try {
                field.setAccessible(true);
                field.set(null, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        staticFields.clear();
    }

    public static Object field(Object thisOrClass, String fieldName) throws NoSuchFieldException {
        return AgitarTestUtility.getPrivateField(thisOrClass, fieldName);
    }

    public static Object getPrivateField(Object thisOrClass, String fieldName) throws NoSuchFieldException {
        Class<?> declaringClass = thisOrClass instanceof Class ? thisOrClass : thisOrClass.getClass();
        Field fld = AgitarTestUtility.findField(declaringClass, fieldName);
        fld.setAccessible(true);
        try {
            return fld.get(thisOrClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object thisOrClass, String fieldName, Object newValue) throws NoSuchFieldException {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, Object newValue) throws NoSuchFieldException {
        Class<?> declaringClass = thisOrClass instanceof Class ? thisOrClass : thisOrClass.getClass();
        Field fld = AgitarTestUtility.findField(declaringClass, fieldName);
        fld.setAccessible(true);
        try {
            fld.set(thisOrClass, newValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object thisOrClass, String fieldName, int newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, int newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Integer(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, boolean newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, boolean newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Boolean(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, byte newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, byte newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Byte(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, char newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, char newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Character(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, double newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, double newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Double(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, float newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, float newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Float(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, long newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, long newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Long(newValue));
    }

    public static void setField(Object thisOrClass, String fieldName, short newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, newValue);
    }

    public static void setPrivateField(Object thisOrClass, String fieldName, short newValue) throws Exception {
        AgitarTestUtility.setPrivateField(thisOrClass, fieldName, new Short(newValue));
    }

    private static Field findField(Class c, String fieldName) throws NoSuchFieldException {
        while (c != null) {
            Field[] flds = c.getDeclaredFields();
            for (int i = 0; i < flds.length; ++i) {
                if (!flds[i].getName().equals(fieldName)) continue;
                return flds[i];
            }
            c = c.getSuperclass();
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static Object construct(String className) throws Exception {
        return AgitarTestUtility.method(className, "<init>", new Class[0], null, new Object[0]);
    }

    public static Object construct(String className, Class[] paramTypes, Object[] params) throws Exception {
        return AgitarTestUtility.method(className, "<init>", paramTypes, null, params);
    }

    public static Object method(String className, String methodName, Class[] paramTypes, Object instance, Object[] params) throws Exception {
        return AgitarTestUtility.callPrivateMethod(className, methodName, paramTypes, instance, params);
    }

    public static Object callPrivateMethod(String className, String methodName, Class[] paramTypes, Object instance, Object[] params) throws Exception {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && methodName == null) {
            throw new AssertionError();
        }
        if (params == null) {
            params = NO_PARMS;
        }
        try {
            Class<?> clazz = ReflectionCacheRegistry.getContextClassLoader().loadClass(className);
            if (methodName.equals("<init>")) {
                return AgitarTestUtility.callPrivateConstructor(clazz, paramTypes, params);
            }
            return AgitarTestUtility.callPrivateMethod(clazz, instance, methodName, paramTypes, params);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
    }

    private static Object callPrivateMethod(Class clazz, Object instance, String methodName, Class[] paramTypes, Object[] params) throws Exception {
        ArrayList next = new ArrayList();
        next.add(clazz);
        while (!next.isEmpty()) {
            Class c = (Class)next.remove(0);
            try {
                Method meth = c.getDeclaredMethod(methodName, paramTypes);
                meth.setAccessible(true);
                return meth.invoke(instance, params);
            }
            catch (NoSuchMethodException e) {
                if (c.isInterface()) {
                    Class<?>[] interfaces = c.getInterfaces();
                    if (interfaces == null) continue;
                    next.addAll(Arrays.asList(interfaces));
                    continue;
                }
                if (c.getSuperclass() == null) continue;
                next.add(c.getSuperclass());
            }
        }
        throw new NoSuchMethodException(clazz.getName() + "." + methodName);
    }

    private static Object callPrivateConstructor(Class clazz, Class[] paramTypes, Object[] parms) throws Exception {
        Class c = clazz;
        while (true) {
            try {
                Constructor ctor = clazz.getDeclaredConstructor(paramTypes);
                ctor.setAccessible(true);
                return ctor.newInstance(parms);
            }
            catch (NoSuchMethodException e) {
                if ((c = c.getSuperclass()) != null) continue;
                throw new NoSuchMethodException(clazz.getName() + ".<init>");
            }
            break;
        }
    }

    public static void assertInvoked(Object mockInstance, String signature) {
        Assert.assertTrue((String)("expected <" + signature + "> to have been invoked"), (boolean)Mockingbird.checkInvocationRecord(mockInstance, signature));
    }

    public static void assertInvoked(Object mockInstance, String signature, int times) {
        if (times <= 0) {
            throw new IllegalArgumentException("times must be greater than zero");
        }
        Assert.assertTrue((String)("expected <" + signature + "> to have been invoked " + times + " times"), (boolean)Mockingbird.checkInvocationRecord(mockInstance, signature, times));
    }

    public static void assertInvoked(Object mockInstance, String signature, Object[] parameters) {
        Assert.assertTrue((String)("expected <" + signature + "> to have been invoked with " + AgitarTestUtility.paramString(parameters)), (boolean)Mockingbird.checkInvocationRecord(mockInstance, signature, parameters));
    }

    public static void assertInvoked(Object mockInstance, String signature, Object[] parameters, int times) {
        Assert.assertTrue((String)("expected <" + signature + "> to have been invoked " + times + " times with " + AgitarTestUtility.paramString(parameters)), (boolean)Mockingbird.checkInvocationRecord(mockInstance, signature, parameters, times));
    }

    private static String paramString(Object[] params) {
        StringBuffer buf = new StringBuffer("(");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (params[i] == null || params[i].getClass().getName().startsWith("java.lang.")) {
                    buf.append(params[i]);
                    continue;
                }
                buf.append('<').append(params[i].getClass().getName()).append('>');
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public static void assertCurrentDate(String message, Date date, long millisecondPrecision) {
        if (date == null || Math.abs(System.currentTimeMillis() - date.getTime()) > millisecondPrecision) {
            Object[] formattedDate = new String[]{date != null ? Long.toString(date.getTime()) : "null"};
            String formattedMessage = MessageFormat.format(DEFAULT_MESSAGE, formattedDate);
            if (message != null) {
                formattedMessage = message + ' ' + formattedMessage;
            }
            Assert.fail((String)formattedMessage);
        }
    }

    public static void assertCurrentDate(Date date, long millisecondPrecision) {
        AgitarTestUtility.assertCurrentDate(null, date, millisecondPrecision);
    }

    public static void assertThrownBy(String message, Class expectedThrower, Throwable thrown) {
        Assert.assertNotNull((String)"expectedThrower cannot be null", (Object)expectedThrower);
        Assert.assertNotNull((String)"thrown cannot be null", (Object)thrown);
        StackTraceElement firstUserClassInTrace = Utils.firstUserClassInTrace(thrown);
        if (firstUserClassInTrace != null) {
            String actualThrowerName = firstUserClassInTrace.getClassName();
            Assert.assertEquals((String)message, (String)expectedThrower.getName(), (String)actualThrowerName);
        }
    }

    public static void assertThrownBy(Class expectedThrower, Throwable thrown) {
        AgitarTestUtility.assertThrownBy(null, expectedThrower, thrown);
    }

    public static void addFileNameMapping(String originalFileName, String newFileName) {
        FileNameMap.put(originalFileName, newFileName);
    }

    public static void clearFileNameMapping() {
        FileNameMap.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void bindJndi(String jndiName, Object value) {
        InitialContext root = null;
        try {
            try {
                int i;
                root = new InitialContext();
                root.addToEnvironment("agitar$context$setup$start", new Object());
                CompositeName name = new CompositeName(jndiName);
                Context copy = root;
                for (i = 0; i < name.size() - 1; ++i) {
                    String subname = name.get(i);
                    try {
                        Object obj = copy.lookup(subname);
                        if (!(obj instanceof Context)) {
                            throw new NameAlreadyBoundException(MessageFormat.format("Name [{0}] already bound", name.getPrefix(i + 1)));
                        }
                        copy = (Context)obj;
                        continue;
                    }
                    catch (NameNotFoundException e) {
                        copy = copy.createSubcontext(subname);
                    }
                }
                String last = name.get(i);
                try {
                    copy.bind(last, value);
                }
                catch (NameAlreadyBoundException e) {
                    Object obj = copy.lookup(last);
                    if (obj instanceof Context) {
                        throw new NamingException(MessageFormat.format("Cannot replace context at [{0}] with [{1}].", jndiName, value.toString()));
                    }
                    copy.rebind(last, value);
                }
                Object var10_12 = null;
                if (root == null) return;
            }
            catch (NamingException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (root == null) throw throwable;
            try {
                root.addToEnvironment("agitar$context$setup$end", new Object());
                throw throwable;
            }
            catch (NamingException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (NamingException e) {}
        root.addToEnvironment("agitar$context$setup$end", new Object());
        return;
    }

    public static void addPermission(final Permission permission) {
        if (permission instanceof AllPermission) {
            throw new IllegalArgumentException();
        }
        AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ((AgPolicy)Policy.getPolicy()).addAuxiliaryPermission(permission);
                return null;
            }
        });
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        ClassName className = ClassName.get((String)name);
        return AgitarTestUtility.classForName(className);
    }

    private static Class classForName(ClassName className) throws ClassNotFoundException {
        if (className.isArray()) {
            Class component = AgitarTestUtility.classForName(className.getComponentType());
            return Array.newInstance(component, 0).getClass();
        }
        return className.toClass();
    }

    public static void assertClassesLoaded(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            try {
                Class.forName(classes[i].getName(), true, classes[i].getClassLoader());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new AssertionFailedError(e.toString());
            }
        }
    }

    static {
        $assertionsDisabled = !AgitarTestUtility.class.desiredAssertionStatus();
        EPSILON = 1.0E-6;
        NO_PARMS = new Object[0];
        staticFields = new HashMap();
        originalTimeZone = TimeZone.getDefault();
    }
}

