/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.interceptor;

import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.lib.interceptor.Interceptor;
import com.agitar.lib.interceptor.MethodInterceptor;
import com.agitar.lib.mockingbird.DefaultValueMap;
import java.lang.reflect.Method;

public class InterceptorWithDefaultValue
implements MethodInterceptor {
    private final Method method;

    private InterceptorWithDefaultValue(Method method) {
        this.method = method;
    }

    public Object invoke(Object object, Object[] args) throws Throwable {
        return DefaultValueMap.getDefaultValue(this.method.getReturnType(), false);
    }

    public static void addInterceptor(Class type) {
        try {
            Method[] declaredMethods = type.getDeclaredMethods();
            Interceptor.addToNoWarningClasses(ClassName.get((Class)type));
            for (int i = 0; i < declaredMethods.length; ++i) {
                Interceptor.add(new InterceptorWithDefaultValue(declaredMethods[i]));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addInterceptor(Method method) {
        Interceptor.add(new InterceptorWithDefaultValue(method));
    }

    public String getDeclaringClass() {
        return this.method.getDeclaringClass().getName();
    }

    public String getReturnType() {
        return ClassName.get(this.method.getReturnType()).getName();
    }

    public String getSignature() {
        return MethodSignature.fromMethod((Method)this.method).getShortFormNoNames();
    }
}

