/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib.interceptor;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.common.util.StringUtility;
import com.agitar.lib.interceptor.MethodInterceptor;
import com.agitar.lib.mockingbird.Caller;
import com.agitar.lib.mockingbird.ClassCache;
import com.agitar.lib.mockingbird.MethodCache;
import com.agitar.lib.mockingbird.TypeMismatchedError;
import com.agitar.lib.mockingbird.Utils;
import com.agitar.lib.mockingbird.Value;
import com.agitar.lib.mockingbird.tape.ExceptionHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

public abstract class Interceptor {
    private static Map map = new ClassCacheMap(Interceptor.class.getName() + ".classMap");
    private static Set noWaringClasses = new HashSet();
    private static Listener listener;

    private Interceptor() {
    }

    public static void addToNoWarningClasses(ClassName name) {
        noWaringClasses.add(name);
    }

    public static void add(MethodInterceptor interceptor) {
        String descriptor;
        if (interceptor.getSignature().startsWith("$agitar_inc")) {
            return;
        }
        String declaringClass = interceptor.getDeclaringClass();
        if (declaringClass == null || declaringClass.length() == 0) {
            AgitarLogger.getUserLogger().severe("getDeclaringClass() of method interceptor returns null or empty string.");
            return;
        }
        declaringClass = declaringClass.trim();
        String sig = interceptor.getSignature();
        if (sig == null || sig.length() == 0) {
            AgitarLogger.getUserLogger().severe("getSignature() of method interceptor returns null or empty string.");
            return;
        }
        if ((sig = sig.trim()).startsWith("<clinit>") || sig.startsWith("<init>")) {
            AgitarLogger.getUserLogger().severe("method interceptor for <init> or <clinit> are not allowed.");
            return;
        }
        String returnType = interceptor.getReturnType();
        if (returnType == null || returnType.length() == 0) {
            AgitarLogger.getUserLogger().severe("getReturnType() of method interceptor returns null or empty string.");
            return;
        }
        returnType = returnType.trim();
        ClassName className = ClassName.get((String)declaringClass);
        String name = declaringClass.replace('.', '/');
        HashMap methodMap = (HashMap)map.get(name);
        if (methodMap == null) {
            methodMap = new HashMap();
            map.put(name, methodMap);
        }
        MethodSignature signature = null;
        int right = sig.indexOf(41);
        ClassName returnClassName = ClassName.get((String)returnType);
        signature = right > 0 && right != sig.length() - 1 ? new MethodSignature(className, sig.substring(0, right + 1), returnClassName) : new MethodSignature(className, sig, returnClassName);
        String methodName = signature.getName();
        HashMap<String, Container> signatureMap = (HashMap<String, Container>)methodMap.get(methodName);
        if (signatureMap == null) {
            signatureMap = new HashMap<String, Container>();
            methodMap.put(methodName, signatureMap);
        }
        if (!signatureMap.containsKey(descriptor = signature.getBytecodeForm()) && !noWaringClasses.contains(className)) {
            AgitarLogger.getUserLogger().info("Interceptor added for method: " + signature.getLongFormNoNames());
        }
        signatureMap.put(descriptor, new Container(interceptor, signature));
    }

    public static void clear() {
        map.clear();
        noWaringClasses.clear();
    }

    public static String convertSignature(Method method) {
        String bytecodeForm = MethodSignature.fromMethod((Method)method).getBytecodeForm();
        return method.getName() + bytecodeForm;
    }

    public static Object findInterceptor(String internalClassName, String methodName, String descriptor) {
        Object object = map.get(internalClassName);
        if (object != null && (object = ((Map)object).get(methodName)) != null) {
            object = ((Map)object).get(descriptor);
        }
        return object;
    }

    public static Value intercept(Method method, Object thisObject, Object[] params) throws Throwable {
        String methodDescriptor;
        String methodName;
        String internalName = Type.getInternalName(method.getDeclaringClass());
        Object object = Interceptor.findInterceptor(internalName, methodName = method.getName(), methodDescriptor = Type.getMethodDescriptor((Method)method));
        if (object != null) {
            return Interceptor.intercept(object, thisObject, internalName, methodName, methodDescriptor, params, method.getDeclaringClass().getClassLoader());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value intercept(Object object, Object thisObject, String internalClassName, String methodName, String methodDescription, Object[] params, ClassLoader classLoader) throws Throwable {
        if (object == null) {
            return null;
        }
        Container container = (Container)object;
        Object value = null;
        Throwable exception = null;
        try {
            try {
                value = container.interceptor.invoke(thisObject, params);
                Value value2 = new Value(Caller.convertValue(container.getReturnType(classLoader), value));
                Object var13_13 = null;
                if (listener == null) return value2;
                listener.notify(container.signature, thisObject, params, value, exception);
                return value2;
            }
            catch (TypeMismatchedError err) {
                AgitarLogger.getUserLogger().warning(StringUtility.cleanTrace((Throwable)err));
                throw err;
            }
            catch (Throwable throwable) {
                exception = throwable;
                Utils.handleExceptions(new ExceptionHolder(exception), container.getExceptionTypes(thisObject, internalClassName, methodName, methodDescription, classLoader), container.signature.getLongFormNoNames());
                Value value3 = null;
                Object var13_14 = null;
                if (listener == null) return value3;
                listener.notify(container.signature, thisObject, params, value, exception);
                return value3;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (listener == null) throw throwable;
            listener.notify(container.signature, thisObject, params, value, exception);
            throw throwable;
        }
    }

    public static void setListener(Listener listener) {
        Interceptor.listener = listener;
    }

    public static interface Listener {
        public void notify(MethodSignature var1, Object var2, Object[] var3, Object var4, Throwable var5);
    }

    private static class Container {
        private Class[] exceptions;
        private final MethodInterceptor interceptor;
        private Class returnType;
        private final MethodSignature signature;

        private Container(MethodInterceptor interceptor, MethodSignature signature) {
            this.interceptor = interceptor;
            this.signature = signature;
        }

        private Class[] getExceptionTypes(Object thisObject, String internalClassName, String methodName, String methodDescription, ClassLoader classLoader) {
            if (this.exceptions == null) {
                try {
                    Method method = (Method)MethodCache.find(thisObject, internalClassName, methodName, methodDescription, classLoader);
                    this.exceptions = method.getExceptionTypes();
                }
                catch (Throwable exc) {
                    this.exceptions = new Class[0];
                }
            }
            return this.exceptions;
        }

        private Class getReturnType(ClassLoader classLoader) {
            if (this.returnType == null) {
                this.returnType = ClassCache.getClassFromInternalName(this.signature.getReturnType().getBytecodeName(), classLoader, true);
            }
            return this.returnType;
        }
    }
}

