/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.lib;

import [Ljava.lang.Object;;
import com.agitar.common.types.MethodSignature;
import com.agitar.lib.MockDisabledException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConcreteMocks {
    private static final Map mocks = new HashMap();
    private static Method notifyReturn;
    private static Method notifyException;
    private static Throwable notifyFailure;
    private static boolean enabled;

    public static void registerConcreteMock(Class originalClass, Class mockClass) {
        mocks.put(originalClass.getName(), mockClass.getName());
    }

    public static void registerConcreteMock(String originalClassName, String mockClassName) {
        mocks.put(originalClassName, mockClassName);
    }

    public static void createDefaultConcreteMock(Class originalClass) {
        mocks.put(originalClass.getName(), "(auto)");
    }

    public static void createDefaultConcreteMock(String originalClassName) {
        mocks.put(originalClassName, "(auto)");
    }

    public static Map getMappings() {
        return Collections.unmodifiableMap(mocks);
    }

    public static void clear() {
        mocks.clear();
    }

    public static void setMockingEnabled(boolean enabled) {
        ConcreteMocks.enabled = enabled;
    }

    public static void notifyConcreteMockReturn(Object value, String className, String methodName, String desc, Object thisObject, Object[] params) {
        if (!enabled) {
            throw new MockDisabledException();
        }
        MethodSignature msig = MethodSignature.fromRawForm((String)className, (String)methodName, (String)desc);
        ConcreteMocks.getInstrumentUtils();
        if (notifyReturn != null) {
            try {
                notifyReturn.invoke(null, value, msig, thisObject, params);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(msig + " returns " + value);
            if (msig.getParamTypes().length != params.length) {
                System.out.println("parameter length mismatch!");
            }
        }
    }

    public static void notifyConcreteMockException(Throwable exception, String className, String methodName, String desc, Object thisObject, Object[] params) {
        if (!enabled) {
            throw new MockDisabledException();
        }
        MethodSignature msig = MethodSignature.fromRawForm((String)className, (String)methodName, (String)desc);
        ConcreteMocks.getInstrumentUtils();
        if (notifyException != null) {
            try {
                notifyException.invoke(null, exception, msig, thisObject, params);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(msig + " throws " + exception);
            if (msig.getParamTypes().length != params.length) {
                System.out.println("parameter length mismatch!");
            }
        }
    }

    private static void getInstrumentUtils() {
        if (notifyReturn == null && notifyFailure == null) {
            try {
                Class<?> instrumentUtils = Class.forName("com.agitar.tbe.instrument.TBEInstrumentUtils");
                notifyReturn = instrumentUtils.getDeclaredMethod("notifyConcreteMockReturn", Object.class, MethodSignature.class, Object.class, Object;.class);
                notifyException = instrumentUtils.getDeclaredMethod("notifyConcreteMockException", Throwable.class, MethodSignature.class, Object.class, Object;.class);
            }
            catch (ClassNotFoundException e) {
                notifyFailure = e;
            }
            catch (NoSuchMethodException e) {
                notifyFailure = e;
            }
        }
    }

    static {
        enabled = true;
    }
}

