/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.types.ClassName;
import com.agitar.concretemock.StandardMockWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class StubbingMockWriter
extends StandardMockWriter {
    public void stubField(FieldNode field) {
        this.out.print("  ");
        this.writeModifiers(field.access & 0xFFFFFFEF);
        this.out.print(this.typeToSource(Type.getType((String)field.desc)));
        this.out.print(' ');
        this.out.print(field.name);
        this.out.println(';');
        this.out.println();
    }

    public void stubMethod(MethodNode method) {
        this.writeMethodSignature(method);
        this.out.print("    ");
        this.out.println(this.returnOriginal(Type.getReturnType((String)method.desc)));
        this.writeCloseMethod();
    }

    public void stubConstructor(MethodNode con) {
        this.writeConstructorSignature(con);
        this.out.println("    MockUtils.doOriginal();");
        this.writeCloseMethod();
    }

    private String returnOriginal(Type returnType) {
        switch (returnType.getSort()) {
            case 5: {
                return "return MockUtils.doOriginalInt();";
            }
            case 7: {
                return "return MockUtils.doOriginalLong();";
            }
            case 4: {
                return "return MockUtils.doOriginalShort();";
            }
            case 3: {
                return "return MockUtils.doOriginalByte();";
            }
            case 6: {
                return "return MockUtils.doOriginalFloat();";
            }
            case 8: {
                return "return MockUtils.doOriginalDouble();";
            }
            case 2: {
                return "return MockUtils.doOriginalChar();";
            }
            case 1: {
                return "return MockUtils.doOriginalBoolean();";
            }
            case 0: {
                return "MockUtils.doOriginal();";
            }
        }
        String packageName = ClassName.get((String)returnType.getClassName()).getPackageName();
        if (packageName != null && (packageName.equals(this.className.getPackageName()) || packageName.equals("java.lang"))) {
            ClassName cn = ClassName.get((String)returnType.getClassName());
            return "return (" + cn.getNameWithoutPackage().replace('$', '.') + ") MockUtils.doOriginal();";
        }
        ClassName cn = ClassName.get((String)returnType.getClassName());
        return "return (" + cn.getName().replace('$', '.') + ") MockUtils.doOriginal();";
    }
}

