/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.StringUtility;
import com.agitar.concretemock.MockWriter;
import com.agitar.concretemock.SignatureParser;
import com.agitar.lib.ConcreteMock;
import com.agitar.lib.MockUtils;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.SignatureAttribute;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class StandardMockWriter
implements MockWriter {
    protected static final String INDENT = "  ";
    protected PrintWriter out;
    protected ClassName className;
    protected ClassNode mockClass;
    protected String superCall;

    public void setClass(ClassNode c) {
        this.mockClass = c;
    }

    public void setClassName(ClassName className) {
        this.className = className;
    }

    public void setSuperCall(String superCall) {
        this.superCall = superCall;
    }

    public void setWriter(PrintWriter writer) {
        this.out = writer;
    }

    public void writeHeader() {
        if (!StringUtility.nullOrEmpty((String)this.className.getPackageName())) {
            this.writePackageHeader();
        }
        this.writeImports();
        this.writeClassDeclaration();
    }

    public void writeFooter() {
        this.out.println("}");
        this.out.flush();
    }

    public void stubField(FieldNode field) {
    }

    public void mockMethod(MethodNode method) {
        ClassName genericReturn = this.writeMethodSignature(method);
        if (!genericReturn.equals((Object)ClassName.VOID)) {
            this.out.print("    return ");
            this.out.print(this.generateValue(Type.getReturnType((String)method.desc), genericReturn));
            this.out.println(';');
        }
        this.writeCloseMethod();
    }

    public void mockConstructor(MethodNode con) {
        this.writeConstructorSignature(con);
        if (this.superCall != null) {
            this.out.println("    " + this.superCall);
        }
        this.out.println("    MockUtils.doNothing();");
        this.writeCloseMethod();
    }

    public void generateDefaultConstructor() {
        this.out.print(INDENT);
        this.writeModifiers(1);
        this.out.print(this.className.getNameWithoutPackage());
        this.out.println("() {");
        if (this.superCall != null) {
            this.out.println("    " + this.superCall);
        }
        this.out.println("    MockUtils.doNothing();");
        this.writeCloseMethod();
    }

    public void mockStaticInit() {
        this.out.println("  static {");
        this.out.println("    // if this block is left without any executable code, the compiler will omit it");
        this.out.println("    // and the static initializer of the real class will be used");
        this.out.println("    MockUtils.doNothing();");
        this.out.println("  }");
        this.out.println();
    }

    public void stubMethod(MethodNode method) {
    }

    public void stubConstructor(MethodNode con) {
    }

    protected void writeConstructorSignature(MethodNode constructor) {
        String name = this.className.getNameWithoutPackage();
        this.out.print(INDENT);
        boolean varArgs = this.writeModifiers(constructor.access);
        String sig = this.getSignature(constructor.attrs, constructor.desc);
        this.out.print(this.findGenericDeclarations(sig));
        sig = sig.substring(sig.indexOf(40));
        MethodSignature msig = MethodSignature.fromRawForm((String)this.className.toString(), (String)constructor.name, (String)sig);
        this.out.print(name);
        this.out.print('(');
        this.writeTypeList(msig.getParamTypes(), constructor.localVariables, varArgs, false);
        this.writeThrowsClause(StringUtility.strings((Collection)constructor.exceptions));
    }

    protected ClassName writeMethodSignature(MethodNode method) {
        this.out.print(INDENT);
        boolean varArgs = this.writeModifiers(method.access);
        String sig = this.getSignature(method.attrs, method.desc);
        this.out.print(this.findGenericDeclarations(sig));
        sig = sig.substring(sig.indexOf(40));
        MethodSignature msig = MethodSignature.fromRawForm((String)this.className.toString(), (String)method.name, (String)sig);
        this.out.print(this.classNameToSource(msig.getReturnType()));
        this.out.print(' ');
        this.out.print(method.name);
        this.out.print('(');
        this.writeTypeList(msig.getParamTypes(), method.localVariables, varArgs, Modifier.isStatic(method.access));
        this.writeThrowsClause(StringUtility.strings((Collection)method.exceptions));
        return msig.getReturnType();
    }

    private String findGenericDeclarations(String desc) {
        if (desc.startsWith("<")) {
            String vars = desc.substring(0, desc.indexOf(40)) + " ";
            vars = vars.replaceAll("\\:Ljava/lang/Object;", "");
            vars = vars.replaceAll("Ljava/lang/", "L");
            vars = vars.replace('/', '.');
            vars = vars.replaceAll("L" + this.className.getPackageName() + ".", "L");
            return vars;
        }
        return "";
    }

    private void writeThrowsClause(String[] exceptions) {
        if (exceptions == null || exceptions.length == 0) {
            this.out.println(") {");
        } else {
            this.out.print(") throws ");
            this.out.print(this.slashNameToSource(exceptions[0]));
            for (int i = 1; i < exceptions.length; ++i) {
                this.out.print(", ");
                this.out.print(this.slashNameToSource(exceptions[i]));
            }
            this.out.println(" {");
        }
    }

    protected boolean writeModifiers(int access) {
        String modString;
        boolean varArgs = false;
        int modifiers = access & 0xFFFFFAEF;
        if ((modifiers & 0x80) != 0) {
            modifiers &= 0xFFFFFF7F;
            varArgs = true;
        }
        if ((modString = Modifier.toString(modifiers)).length() > 0) {
            this.out.print(modString);
            this.out.print(' ');
        }
        return varArgs;
    }

    private String generateValue(Type returnType, ClassName castCN) {
        String typeName;
        String packageName = castCN.getPackageName();
        switch (returnType.getSort()) {
            case 5: {
                return "MockUtils.getRandom().nextInt()";
            }
            case 7: {
                return "MockUtils.getRandom().nextLong()";
            }
            case 4: {
                return "(short) MockUtils.getRandom().nextInt()";
            }
            case 3: {
                return "(byte) MockUtils.getRandom().nextInt()";
            }
            case 6: {
                return "MockUtils.getRandom().nextFloat()";
            }
            case 8: {
                return "MockUtils.getRandom().nextDouble()";
            }
            case 2: {
                return "(char) MockUtils.getRandom().nextInt()";
            }
            case 1: {
                return "MockUtils.getRandom().nextBoolean()";
            }
        }
        String string = typeName = castCN.getFullTypeName().indexOf(60) >= 0 ? castCN.getFullTypeName() : returnType.getClassName();
        if (packageName != null && (packageName.equals(this.className.getPackageName()) || packageName.equals("java.lang"))) {
            return '(' + castCN.getSourceNameWithoutPackage().replace('$', '.') + ") MockUtils.getObject(\"" + typeName + "\")";
        }
        return '(' + castCN.getSourceName().replace('$', '.') + ") MockUtils.getObject(\"" + typeName + "\")";
    }

    protected void writeCloseMethod() {
        this.out.println("  }");
        this.out.println();
    }

    private void writeTypeList(ClassName[] types, List names, boolean varArgs, boolean isStatic) {
        int first = 0;
        if (types.length > 0 && types[0].equals((Object)ClassName.get((String)this.mockClass.name).getContainingClass())) {
            first = 1;
        }
        for (int i = first; i < types.length; ++i) {
            if (i > first) {
                this.out.print(", ");
            }
            String typeString = this.classNameToSource(types[i]);
            if (varArgs && i + 1 == types.length && types[i].isArray()) {
                this.out.print(typeString.substring(0, typeString.length() - 2));
                this.out.print("...");
            } else {
                this.out.print(typeString);
            }
            this.out.print(' ');
            if (names != null && !names.isEmpty()) {
                int offset = isStatic ? 0 : 1;
                LocalVariableNode var = null;
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    LocalVariableNode lvn = (LocalVariableNode)iter.next();
                    if (lvn.index != i - first + offset) continue;
                    var = lvn;
                    break;
                }
                this.out.print(var == null ? "param" + (i + 1) : var.name);
                continue;
            }
            this.out.print("param");
            this.out.print(i + 1);
        }
    }

    protected String typeToSource(Type type) {
        return this.classNameToSource(ClassName.get((String)type.getClassName()));
    }

    protected String slashNameToSource(String slashName) {
        return this.classNameToSource(ClassName.get((String)slashName.replace('/', '.')));
    }

    private String classNameToSource(ClassName typeName) {
        String packageName = typeName.getPackageName();
        if (packageName.equals(this.className.getPackageName()) || packageName.equals("java.lang")) {
            return typeName.getSourceNameWithoutPackage().replace('$', '.');
        }
        return typeName.getSourceName().replace('$', '.');
    }

    private void writePackageHeader() {
        this.out.print("package ");
        this.out.print(this.className.getPackageName());
        this.out.println(';');
        this.out.println();
    }

    private void writeImports() {
        this.out.print("import ");
        this.out.print(Random.class.getName());
        this.out.println(';');
        this.out.print("import ");
        this.out.print(ConcreteMock.class.getName());
        this.out.println(';');
        this.out.print("import ");
        this.out.print(MockUtils.class.getName());
        this.out.println(';');
        this.out.println();
    }

    private void writeClassDeclaration() {
        int modifiers = this.mockClass.access & 1 | 0x400;
        this.out.print(Modifier.toString(modifiers));
        this.out.print(" class ");
        String sig = this.getSignature(this.mockClass.attrs, null);
        if (sig != null) {
            SignatureParser parsedSig = new SignatureParser(this.className, sig);
            this.out.print(parsedSig.getGenericName());
            if (!parsedSig.getGenericSuper().equals("Object")) {
                this.out.print(" extends ");
                this.out.print(parsedSig.getGenericSuper());
            }
            List interfaces = parsedSig.getGenericInterfaces();
            this.out.print(" implements ConcreteMock");
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                String face = (String)iterator.next();
                this.out.print(", ");
                this.out.print(face);
            }
        } else {
            this.out.print(this.className.getNameWithoutPackage());
            if (!this.mockClass.superName.equals("java/lang/Object")) {
                this.out.print(" extends ");
                this.out.print(this.slashNameToSource(this.mockClass.superName));
            }
            List interfaces = this.mockClass.interfaces;
            this.out.print(" implements ConcreteMock");
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                String face = (String)iterator.next();
                this.out.print(", ");
                this.out.print(this.slashNameToSource(face));
            }
        }
        this.out.println(" {");
    }

    private String getSignature(Attribute attrs, String dft) {
        String sig = dft;
        while (attrs != null) {
            if (attrs instanceof SignatureAttribute) {
                sig = ((SignatureAttribute)attrs).signature;
            }
            attrs = attrs.next;
        }
        return sig;
    }
}

