/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.types.ClassName;
import java.util.ArrayList;
import java.util.List;

public class SignatureParser {
    private final String genericName;
    private final String genericSuper;
    private final List genericInterfaces;

    public SignatureParser(ClassName name, String signature) {
        signature = name.getSourceNameWithoutPackage() + signature;
        signature = signature.replaceAll("\\:Ljava/lang/Object;", "");
        signature = signature.replaceAll("Ljava/lang/", "L");
        signature = signature.replace('/', '.');
        signature = signature.replaceAll("L" + name.getPackageName() + ".", "L");
        char[] chars = signature.toCharArray();
        int depth = 0;
        StringBuffer buf = new StringBuffer();
        ArrayList<String> parts = new ArrayList<String>();
        boolean first = false;
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    buf.append(c);
                    ++depth;
                    first = parts.size() > 0;
                    continue block7;
                }
                case '>': {
                    buf.append(c);
                    if (--depth == 0) {
                        parts.add(buf.toString());
                        buf = new StringBuffer();
                    }
                    first = true;
                    continue block7;
                }
                case ':': {
                    buf.append(" extends ");
                    continue block7;
                }
                case '$': {
                    buf.append('.');
                    continue block7;
                }
                case ';': {
                    if (depth == 0 && buf.length() > 0) {
                        parts.add(buf.toString());
                        buf = new StringBuffer();
                    }
                    first = true;
                    continue block7;
                }
                default: {
                    if (first) {
                        first = false;
                        continue block7;
                    }
                    buf.append(c);
                }
            }
        }
        this.genericName = (String)parts.remove(0);
        this.genericSuper = (String)parts.remove(0);
        this.genericInterfaces = parts;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public String getGenericSuper() {
        return this.genericSuper;
    }

    public List getGenericInterfaces() {
        return this.genericInterfaces;
    }
}

