/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.concretemock.DescriptorAdjuster;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TreeCodeAdapter;

class RealClassVisitor
implements ClassVisitor {
    private final ClassVisitor delegate;
    private final ClassNode realClass;
    private final ClassNode mockClass;
    private final Map realBodies = new HashMap();
    private final DescriptorAdjuster adjuster;

    public RealClassVisitor(ClassVisitor delegate, ClassNode realClass, ClassNode mockClass, DescriptorAdjuster adjuster) {
        this.delegate = delegate;
        this.realClass = realClass;
        this.mockClass = mockClass;
        this.adjuster = adjuster;
    }

    public Map getRealBodies() {
        return this.realBodies;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        boolean mocked = false;
        List fields = this.mockClass.fields;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldNode field = (FieldNode)iterator.next();
            mocked |= field.name.equals(name);
        }
        if (!mocked) {
            this.delegate.visitField(access, name, desc, value, attrs);
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        boolean mocked = false;
        int mockAccess = access;
        List methods = this.mockClass.methods;
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            String mockDesc = this.adjuster.adjust(name, method.desc);
            if (!method.name.equals(name) || !mockDesc.equals(desc) || Modifier.isAbstract(method.access)) continue;
            mocked = true;
            mockAccess = access & 0xFFFFFEFF | method.access & 0x100;
        }
        if (mocked) {
            MethodNode node = new MethodNode(mockAccess, name, desc, exceptions, attrs);
            this.realBodies.put(name + desc, node);
            return new TreeCodeAdapter(node);
        }
        return this.delegate.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitAttribute(Attribute attrs) {
        this.delegate.visitAttribute(attrs);
    }

    public void visitEnd() {
    }
}

