/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.asm.AsmUtil;
import com.agitar.lib.mockingbird.MockingbirdError;
import java.lang.reflect.Modifier;
import java.util.Stack;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class NotifyCodeAdapter
extends CodeAdapter {
    private final String className;
    private final String name;
    private final String desc;
    private final int access;
    private final Label start = new Label();
    private Stack stack;
    private final String superClassName;

    public NotifyCodeAdapter(CodeVisitor codeVisitor, String superClassName, String className, String name, String desc, int access) {
        super(codeVisitor);
        this.className = className;
        this.name = name;
        this.desc = desc;
        this.access = access;
        this.superClassName = superClassName;
        if (!name.equals("<init>")) {
            super.visitLabel(this.start);
        } else {
            this.stack = new Stack();
        }
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.notifyReturnValue();
        }
        super.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.notifyException();
        super.visitMaxs(maxStack, maxLocals);
    }

    private void notifyReturnValue() {
        Type returnType = Type.getReturnType((String)this.desc);
        if (this.name.equals("<init>")) {
            super.visitVarInsn(25, 0);
        } else {
            AsmUtil.boxStack((CodeVisitor)this.cv, (Type)returnType);
        }
        super.visitLdcInsn((Object)this.className);
        super.visitLdcInsn((Object)this.name);
        super.visitLdcInsn((Object)this.desc);
        if (Modifier.isStatic(this.access)) {
            super.visitInsn(1);
            AsmUtil.createArgumentArray((CodeVisitor)this.cv, (String)this.desc, (int)0);
        } else {
            super.visitVarInsn(25, 0);
            AsmUtil.createArgumentArray((CodeVisitor)this.cv, (String)this.desc, (int)1);
        }
        String O = "Ljava/lang/Object;";
        String S = "Ljava/lang/String;";
        super.visitMethodInsn(184, "com/agitar/lib/ConcreteMocks", "notifyConcreteMockReturn", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V");
    }

    private void notifyException() {
        Label end = new Label();
        super.visitLabel(end);
        super.visitInsn(89);
        super.visitLdcInsn((Object)this.className);
        super.visitLdcInsn((Object)this.name);
        super.visitLdcInsn((Object)this.desc);
        if (Modifier.isStatic(this.access)) {
            super.visitInsn(1);
            AsmUtil.createArgumentArray((CodeVisitor)this.cv, (String)this.desc, (int)0);
        } else if (this.name.equals("<init>")) {
            super.visitInsn(1);
            AsmUtil.createArgumentArray((CodeVisitor)this.cv, (String)this.desc, (int)1);
        } else {
            super.visitVarInsn(25, 0);
            AsmUtil.createArgumentArray((CodeVisitor)this.cv, (String)this.desc, (int)1);
        }
        String O = "Ljava/lang/Object;";
        String S = "Ljava/lang/String;";
        super.visitMethodInsn(184, "com/agitar/lib/ConcreteMocks", "notifyConcreteMockException", "(Ljava/lang/Throwable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V");
        super.visitInsn(191);
        super.visitTryCatchBlock(this.start, end, end, "java/lang/Throwable");
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.stack == null || opcode != 183 || !"<init>".equals(name)) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        if (this.stack.isEmpty()) {
            if (owner.equals(this.className) || owner.equals(this.superClassName)) {
                super.visitMethodInsn(opcode, owner, name, desc);
                this.cv.visitLabel(this.start);
                return;
            }
            throw new MockingbirdError("unknown bytecode pattern in constructor " + this.className + ".<init>" + desc + " (super class: " + this.superClassName + "  owner: " + owner + ")");
        }
        Object object = this.stack.pop();
        if (owner.equals(object)) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        throw new MockingbirdError("unknown bytecode pattern in constructor " + this.className + ".<init>" + desc + " (new: " + object.toString() + "  owner: " + owner + ")");
    }

    public void visitTypeInsn(int opcode, String desc) {
        super.visitTypeInsn(opcode, desc);
        if (this.stack != null && opcode == 187) {
            this.stack.push(desc);
        }
    }
}

