/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.StringUtility;
import java.util.logging.Logger;

public abstract class Mocker
implements Runnable {
    private final Logger log;
    private final ClassName realClassName;

    protected Mocker(Logger log, String realClassName) {
        if (log == null) {
            throw new NullPointerException();
        }
        this.log = log;
        this.realClassName = ClassName.get((String)realClassName);
    }

    public abstract void run();

    protected Logger getLog() {
        return this.log;
    }

    protected ClassName getRealName() {
        return this.realClassName;
    }

    protected void logError(Throwable e, String msg) {
        String message = StringUtility.nullOrEmpty((String)msg) ? "Mocking error" : msg;
        this.log.log(AgitarLevel.WARNING, message, e);
        Diagnostics.getKey((String)"mocks.unused").setError(this.realClassName, message, e);
    }
}

