/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.concretemock.AutoClassMocker;
import com.agitar.concretemock.AutoInterfaceMocker;
import com.agitar.concretemock.BufferedHandler;
import com.agitar.concretemock.ClassFileWriter;
import com.agitar.concretemock.MergeClassMocker;
import com.agitar.concretemock.MockBytecodeUtil;
import com.agitar.concretemock.Mocker;
import com.agitar.concretemock.StandardClassFileWriter;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.asm.tree.ClassNode;

public class MockReplacer {
    private Logger log;

    public MockReplacer() {
        this(AgitarLogger.getDiagnosticLogger((String)"concretemock"));
    }

    public MockReplacer(Logger log) {
        this.log = log;
    }

    public final void replaceAll(Map replacements, File outputFile) {
        Iterator iterator = replacements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String realName = (String)entry.getKey();
            String mockName = (String)entry.getValue();
            this.replace(realName, mockName, outputFile);
        }
    }

    public final void replace(String realName, String mockName, File outputFile) {
        ClassNode realClass = null;
        try {
            AgitarLogger.getUserLogger().info("Mocking " + realName + " with " + mockName);
            realClass = MockBytecodeUtil.parseClass(realName);
            StandardClassFileWriter cfw = new StandardClassFileWriter(outputFile);
            Mocker replacer = Modifier.isInterface(realClass.access) ? new AutoInterfaceMocker(realClass, this.log, cfw) : (mockName.equals("(auto)") ? new AutoClassMocker(realClass, this.log, cfw) : new MergeClassMocker(realClass, MockBytecodeUtil.parseClass(mockName), this.log, (ClassFileWriter)cfw));
            ((Mocker)replacer).run();
        }
        catch (ClassNotFoundException x) {
            String msg = realClass != null ? DiagnosticResources.getResource((String)"problem.mock.class.not.found", (Object[])new Object[]{realName, mockName, mockName}) : DiagnosticResources.getResource((String)"problem.mock.class.not.found", (Object[])new Object[]{realName, mockName, realName});
            Diagnostics.getKey((String)"mocks.unused").set(ClassName.get((String)realName), msg);
            this.log.log(AgitarLevel.WARNING, msg, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List test(String realName, String mockName, File outputFile) {
        Logger oldLog = this.log;
        try {
            this.log = Logger.getAnonymousLogger();
            BufferedHandler handler = BufferedHandler.bufferLog(this.log);
            this.replace(realName, mockName, outputFile);
            List list = handler.getMessages();
            return list;
        }
        finally {
            this.log = oldLog;
        }
    }
}

