/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.types.ClassName;
import com.agitar.common.util.IOUtility;
import com.agitar.concretemock.MockBytecodeUtil;
import com.agitar.concretemock.MockWriter;
import com.agitar.concretemock.StandardMockWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class MockGenerator {
    public static final String INDENT = "  ";
    private final ClassNode cls;
    private ClassName mockClassName;
    private final Map methods = new HashMap();
    private boolean mockStaticInit = true;
    private MockWriter writer = new StandardMockWriter();
    public static final String MOCK_PREFIX = "AgMock";

    public MockGenerator(ClassName className) throws ClassNotFoundException {
        this(MockBytecodeUtil.parseClass(className.toString()));
    }

    public MockGenerator(ClassNode cls) {
        this.cls = cls;
        if (Modifier.isInterface(cls.access)) {
            throw new IllegalArgumentException("cannot mock an interface");
        }
        Iterator iterator = cls.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (method.name.equals("<init>")) {
                this.methods.put(method, Boolean.TRUE);
                continue;
            }
            if (Modifier.isAbstract(method.access) || (0x1000 & method.access) != 0) continue;
            this.methods.put(method, Boolean.FALSE);
        }
        ClassName cn = this.getOriginalClassName();
        this.mockClassName = cn.getPackageName().equals("") ? ClassName.get((String)(MOCK_PREFIX + cls.name.replace('$', '_'))) : ClassName.get((String)(cn.getPackageName() + "." + MOCK_PREFIX + cn.getNameWithoutPackage().replace('$', '_')));
    }

    public void setMockWriter(MockWriter writer) {
        this.writer = writer;
    }

    public void setMock(MethodNode method, boolean mock) {
        this.methods.put(method, mock);
    }

    public boolean getMockStaticInit() {
        return this.mockStaticInit;
    }

    public void setMockStaticInit(boolean mockStaticInit) {
        this.mockStaticInit = mockStaticInit;
    }

    public ClassName getOriginalClassName() {
        return ClassName.get((String)this.cls.name);
    }

    public void setMockClassName(ClassName mockClassName) {
        this.mockClassName = mockClassName;
    }

    public ClassName getMockClassName() {
        return this.mockClassName;
    }

    public File getGeneratedMockSourceFile(File mockSourceDir) throws IOException {
        return new File(mockSourceDir, this.getMockClassName().getSourceFileName());
    }

    public boolean getMock(MethodNode method) {
        return this.methods.get(method) == Boolean.TRUE;
    }

    public Map getAllMocks() {
        HashMap visibleMocks = new HashMap(this.methods);
        Iterator iterator = visibleMocks.keySet().iterator();
        while (iterator.hasNext()) {
            MethodNode mn = (MethodNode)iterator.next();
            if (!mn.name.equals("<init>") && !mn.name.equals("<clinit>") && (0x1000 & mn.access) == 0) continue;
            iterator.remove();
        }
        return visibleMocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File mockSourceDir) throws IOException, ClassNotFoundException {
        BufferedOutputStream out = null;
        try {
            File sourceFile = this.getGeneratedMockSourceFile(mockSourceDir);
            sourceFile.getParentFile().mkdirs();
            out = new BufferedOutputStream(new FileOutputStream(sourceFile));
            this.write(out);
        }
        catch (Throwable throwable) {
            IOUtility.close(out, (boolean)true);
            throw throwable;
        }
        IOUtility.close((OutputStream)out, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    public void write(OutputStream out) throws ClassNotFoundException {
        PrintWriter pout = new PrintWriter(new OutputStreamWriter(out));
        this.writer.setClass(this.cls);
        this.writer.setClassName(this.getMockClassName());
        this.writer.setWriter(pout);
        this.writer.writeHeader();
        List fields = this.cls.fields;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldNode field = (FieldNode)iterator.next();
            this.writer.stubField(field);
        }
        MethodNode bestSuper = MockBytecodeUtil.findBestSuperConstructor(this.cls);
        if (Type.getArgumentTypes((String)bestSuper.desc).length > 0 && !this.hasMockConstructors()) {
            this.writer.setSuperCall(this.generateSuperCall(null, bestSuper));
            this.writer.generateDefaultConstructor();
        }
        Iterator methodIterator = this.cls.methods.iterator();
        while (methodIterator.hasNext()) {
            MethodNode method = (MethodNode)methodIterator.next();
            if (method.name.equals("<init>")) {
                void var7_7;
                MethodNode superCon;
                try {
                    ClassNode superClass = MockBytecodeUtil.parseClass(this.cls.superName);
                    superCon = MockBytecodeUtil.findMethod(superClass, method.name, method.desc);
                }
                catch (NoSuchMethodException e) {
                    superCon = bestSuper;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.writer.setSuperCall(this.generateSuperCall(method, (MethodNode)var7_7));
                if (this.methods.get(method) == Boolean.TRUE) {
                    this.writer.mockConstructor(method);
                    continue;
                }
                this.writer.stubConstructor(method);
                continue;
            }
            if (!Modifier.isAbstract(method.access) && this.methods.get(method) == Boolean.TRUE) {
                this.writer.mockMethod(method);
                continue;
            }
            this.writer.stubMethod(method);
        }
        if (this.mockStaticInit) {
            this.writer.mockStaticInit();
        }
        this.writer.writeFooter();
    }

    private boolean hasMockConstructors() {
        Iterator iterator = this.methods.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MethodNode method = (MethodNode)entry.getKey();
            Boolean mocked = (Boolean)entry.getValue();
            if (!method.name.equals("<init>") || !mocked.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private String generateSuperCall(MethodNode con, MethodNode bestSuper) {
        Type[] parameterTypes = Type.getArgumentTypes((String)bestSuper.desc);
        if (parameterTypes.length > 0) {
            StringBuffer superCall = new StringBuffer("super(");
            if (con != null && con.desc.equals(bestSuper.desc)) {
                this.generateSuperByNames(superCall, parameterTypes, con);
            } else {
                this.generateSuperByTypes(superCall, parameterTypes);
            }
            superCall.append(");");
            return superCall.toString();
        }
        return null;
    }

    private void generateSuperByTypes(StringBuffer superCall, Type[] parameterTypes) {
        block6: for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                superCall.append(", ");
            }
            Type parameterType = parameterTypes[i];
            switch (parameterType.getSort()) {
                case 1: {
                    superCall.append("false");
                    continue block6;
                }
                case 2: {
                    superCall.append("' '");
                    continue block6;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    superCall.append("0");
                    continue block6;
                }
                case 0: 
                case 9: 
                case 10: {
                    superCall.append("null");
                }
            }
        }
    }

    private void generateSuperByNames(StringBuffer superCall, Type[] parameterTypes, MethodNode con) {
        List locals = con.localVariables;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                superCall.append(", ");
            }
            if (locals.size() > parameterTypes.length) {
                LocalVariableNode local = (LocalVariableNode)locals.get(i + 1);
                superCall.append(local.name);
                continue;
            }
            superCall.append("param").append(i + 1);
        }
    }
}

