/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.util.StringUtility;
import com.agitar.concretemock.DescriptorAdjuster;
import com.agitar.concretemock.NotifyCodeAdapter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

class MockClassVisitor
implements ClassVisitor {
    private final ClassVisitor delegate;
    private final ClassNode realClass;
    private final Map realBodies;
    private final DescriptorAdjuster adjuster;

    public MockClassVisitor(ClassVisitor delegate, ClassNode realClass, Map realBodies, DescriptorAdjuster adjuster) {
        this.delegate = delegate;
        this.realClass = realClass;
        this.realBodies = realBodies;
        this.adjuster = adjuster;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        FieldNode realField = null;
        List fields = this.realClass.fields;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldNode field = (FieldNode)iterator.next();
            if (!field.name.equals(name)) continue;
            realField = field;
        }
        String adjustedDesc = this.adjuster.adjust(name, desc);
        if (realField == null) {
            this.delegate.visitField(access, name, adjustedDesc, value, attrs);
        } else {
            int modifiers = realField.access & 0xFFFFFF6F | access & 0x90;
            this.delegate.visitField(modifiers, name, adjustedDesc, value, attrs);
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        ReplacingCodeAdapter visitor;
        String adjustedDesc = this.adjuster.adjust(name, desc);
        if ((access & 0x400) != 0) {
            boolean mocked = false;
            List methods = this.realClass.methods;
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                MethodNode method = (MethodNode)iterator.next();
                mocked |= method.name.equals(name) && method.desc.equals(adjustedDesc);
            }
            return mocked ? null : new ReplacingCodeAdapter(this.realClass, new MethodNode(access, name, adjustedDesc, exceptions, attrs), access, false);
        }
        MethodNode mn = (MethodNode)this.realBodies.get(name + adjustedDesc);
        if (mn == null) {
            mn = new MethodNode(access, name, adjustedDesc, exceptions, attrs);
            visitor = new ReplacingCodeAdapter(this.realClass, mn, access, false);
        } else {
            visitor = new ReplacingCodeAdapter(this.realClass, mn, access, !name.equals("<clinit>"));
        }
        if (this.adjuster.isToInner() && name.equals("<init>")) {
            visitor.visitVarInsn(25, 0);
            visitor.visitVarInsn(25, 1);
            visitor.visitFieldInsn(181, this.adjuster.getRealNameSlashed(), "this$0", this.adjuster.getOuterDescriptor());
        }
        return visitor;
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitEnd() {
    }

    private CodeVisitor createNext(ClassNode cls, MethodNode mn, int mockAccess, boolean notify) {
        CodeVisitor nextVisitor = this.delegate.visitMethod(mockAccess, mn.name, mn.desc, StringUtility.strings((Collection)mn.exceptions), mn.attrs);
        if (notify) {
            return new NotifyCodeAdapter(nextVisitor, cls.superName, this.realClass.name, mn.name, mn.desc, mockAccess);
        }
        return nextVisitor;
    }

    private class ReplacingCodeAdapter
    extends CodeAdapter {
        private final MethodNode mn;
        private Label originalEnd;
        private boolean skipPop;

        public ReplacingCodeAdapter(ClassNode cls, MethodNode mn, int mockAccess, boolean notify) {
            super(MockClassVisitor.this.createNext(cls, mn, mockAccess, notify));
            this.mn = mn;
        }

        public void visitIntInsn(int opcode, int value) {
            super.visitIntInsn(opcode, value);
            this.skipPop = false;
        }

        public void visitVarInsn(int opcode, int index) {
            super.visitVarInsn(opcode, index);
            this.skipPop = false;
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            this.skipPop = false;
        }

        public void visitLdcInsn(Object constant) {
            super.visitLdcInsn(constant);
            this.skipPop = false;
        }

        public void visitIincInsn(int opcode, int amount) {
            super.visitIincInsn(opcode, amount);
            this.skipPop = false;
        }

        public void visitTableSwitchInsn(int opcode, int offset, Label defaultLabel, Label[] labels) {
            super.visitTableSwitchInsn(opcode, offset, defaultLabel, labels);
            this.skipPop = false;
        }

        public void visitLookupSwitchInsn(Label label, int[] values, Label[] labels) {
            super.visitLookupSwitchInsn(label, values, labels);
            this.skipPop = false;
        }

        public void visitMultiANewArrayInsn(String desc, int dimensions) {
            super.visitMultiANewArrayInsn(desc, dimensions);
            this.skipPop = false;
        }

        public void visitInsn(int opcode) {
            if (this.originalEnd != null && opcode >= 172 && opcode <= 177) {
                super.visitJumpInsn(167, this.originalEnd);
            } else if (!this.skipPop || opcode != 87) {
                super.visitInsn(opcode);
            }
            this.skipPop = false;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String adjustedDesc = MockClassVisitor.this.adjuster.adjust(owner, name, desc);
            String adjustedOwner = MockClassVisitor.this.adjuster.adjust(owner);
            super.visitFieldInsn(opcode, adjustedOwner, name, adjustedDesc);
            this.skipPop = false;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (owner.equals("com/agitar/lib/MockUtils") && name.startsWith("doOriginal") && this.originalEnd == null) {
                this.doOriginal();
                this.skipPop = true;
            } else {
                String adjustedDesc = MockClassVisitor.this.adjuster.adjust(owner, name, desc);
                String adjustedOwner = MockClassVisitor.this.adjuster.adjust(owner);
                super.visitMethodInsn(opcode, adjustedOwner, name, adjustedDesc);
                this.skipPop = false;
            }
        }

        public void visitTypeInsn(int opcode, String desc) {
            String adjustedDesc = MockClassVisitor.this.adjuster.adjust(desc);
            super.visitTypeInsn(opcode, adjustedDesc);
            this.skipPop = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doOriginal() {
            boolean superCall = this.mn.name.equals("<init>");
            try {
                this.originalEnd = new Label();
                this.doOriginalInstructions(superCall);
                this.doOriginalTryCatch();
                this.visitLabel(this.originalEnd);
            }
            finally {
                this.originalEnd = null;
            }
        }

        private void doOriginalTryCatch() {
            List tryCatchBlocks = this.mn.tryCatchBlocks;
            Iterator iterator = tryCatchBlocks.iterator();
            while (iterator.hasNext()) {
                TryCatchBlockNode tryCatch = (TryCatchBlockNode)iterator.next();
                tryCatch.accept((CodeVisitor)this);
            }
        }

        private void doOriginalInstructions(boolean superCall) {
            List instructions = this.mn.instructions;
            Iterator iterator = instructions.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof Label) {
                    this.visitLabel((Label)o);
                    continue;
                }
                AbstractInsnNode instruction = (AbstractInsnNode)o;
                int opcode = instruction.getOpcode();
                if (superCall && opcode == 183) {
                    superCall = false;
                    continue;
                }
                if (superCall && opcode != 89 && opcode != 92) continue;
                instruction.accept((CodeVisitor)this);
            }
        }
    }
}

