/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.common.util.StringUtility;
import com.agitar.concretemock.NotifyCodeAdapter;
import com.agitar.lib.MockUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TreeClassAdapter;

public class MockBytecodeUtil {
    public static String slashify(String className) {
        return className == null ? null : className.replace('.', '/');
    }

    public static String slashify(ClassName className) {
        return className == null ? null : MockBytecodeUtil.slashify(className.toString());
    }

    public static String[] slashify(String[] classNames) {
        String[] result = new String[classNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = MockBytecodeUtil.slashify(classNames[i]);
        }
        return result;
    }

    public static String dotify(String className) {
        return className == null ? null : className.replace('/', '.');
    }

    public static ClassNode parseClass(String name) throws ClassNotFoundException {
        URL url = MockBytecodeUtil.findClass(name);
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            URLConnection con = url.openConnection();
            byte[] classBytes = IOUtility.loadBytesFromURL((URLConnection)con);
            ClassReader reader = new ClassReader(classBytes);
            TreeClassAdapter tca = new TreeClassAdapter(null);
            reader.accept((ClassVisitor)tca, AsmUtil.getDefaultAttributes(), false);
            return tca.classNode;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    public static URL findClass(String name) {
        ClassLoader loader = MockBytecodeUtil.getClassLoader();
        String filename = ClassName.get((String)name).getClassFileName();
        return loader.getResource(filename);
    }

    public static boolean hasClinit(ClassNode c) {
        return !MockBytecodeUtil.findMethodsNamed(c, "<clinit>").isEmpty();
    }

    public static List findConstructors(ClassNode c) {
        return MockBytecodeUtil.findMethodsNamed(c, "<init>");
    }

    public static List findMethodsNamed(ClassNode c, String name) {
        List methods = c.methods;
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (!method.name.equals(name)) continue;
            result.add(method);
        }
        return result;
    }

    public static MethodNode findMethod(ClassNode c, String name, String desc) throws NoSuchMethodException {
        Iterator iterator = c.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (!method.name.equals(name) || !method.desc.equals(desc)) continue;
            return method;
        }
        throw new NoSuchMethodException(c.name + "." + name + desc);
    }

    public static List findMethods(ClassNode c) {
        List methods = c.methods;
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (method.name.startsWith("<") || (method.access & 0x1000) != 0) continue;
            result.add(method);
        }
        return result;
    }

    public static void generateMethodImpl(ClassNode cls, MethodNode method, ClassVisitor writer) throws ClassNotFoundException {
        String signature = method.desc;
        Type returnType = Type.getReturnType((String)signature);
        String[] exceptionClassNames = StringUtility.strings((Collection)method.exceptions);
        int access = method.access & 0xFFFFFAFF;
        NotifyCodeAdapter cv = new NotifyCodeAdapter(writer.visitMethod(access, method.name, signature, exceptionClassNames, null), cls.superName, cls.name, method.name, method.desc, access);
        if (method.name.equals("<init>")) {
            MockBytecodeUtil.generateSuperInitCall(cls, method, (CodeVisitor)cv);
        } else if (returnType.getSort() != 0) {
            cv.visitLdcInsn(AsmUtil.getWrapperClassName((Type)Type.getReturnType((String)method.desc)));
            cv.visitMethodInsn(184, MockUtils.class.getName().replace('.', '/'), "getObject", "(Ljava/lang/String;)Ljava/lang/Object;");
            AsmUtil.unbox((CodeVisitor)cv, (Type)returnType);
        }
        cv.visitInsn(returnType.getOpcode(172));
        cv.visitMaxs(0, 0);
    }

    public static MethodNode findBestSuperConstructor(ClassNode cls) throws ClassNotFoundException {
        ClassNode superClass = MockBytecodeUtil.parseClass(cls.superName);
        MethodNode bestSuper = null;
        Iterator iterator = superClass.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode con = (MethodNode)iterator.next();
            if (!con.name.equals("<init>")) continue;
            int conParams = Type.getArgumentTypes((String)con.desc).length;
            if (Modifier.isPrivate(con.access) || bestSuper != null && conParams >= Type.getArgumentTypes((String)bestSuper.desc).length) continue;
            bestSuper = con;
        }
        return bestSuper;
    }

    private static void generateSuperInitCall(ClassNode cls, MethodNode con, CodeVisitor cv) throws ClassNotFoundException {
        MethodNode bestSuper;
        cv.visitVarInsn(25, 0);
        try {
            bestSuper = MockBytecodeUtil.callMatchingSuper(cls, con, cv);
        }
        catch (NoSuchMethodException e) {
            bestSuper = MockBytecodeUtil.callShortestSuper(cls, cv);
        }
        cv.visitMethodInsn(183, cls.superName, bestSuper.name, bestSuper.desc);
    }

    private static MethodNode callShortestSuper(ClassNode jc, CodeVisitor cv) throws ClassNotFoundException {
        MethodNode bestSuper = MockBytecodeUtil.findBestSuperConstructor(jc);
        Type[] parameterTypes = Type.getArgumentTypes((String)bestSuper.desc);
        for (int i = 0; i < parameterTypes.length; ++i) {
            AsmUtil.loadZero((CodeVisitor)cv, (Type)parameterTypes[i]);
        }
        return bestSuper;
    }

    private static MethodNode callMatchingSuper(ClassNode cls, MethodNode con, CodeVisitor cv) throws NoSuchMethodException, ClassNotFoundException {
        ClassNode superClass = MockBytecodeUtil.parseClass(cls.superName);
        MethodNode superCon = MockBytecodeUtil.findMethod(superClass, con.name, con.desc);
        Type[] parameterTypes = Type.getArgumentTypes((String)con.desc);
        for (int i = 0; i < parameterTypes.length; ++i) {
            cv.visitVarInsn(parameterTypes[i].getOpcode(21), i + 1);
        }
        return superCon;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = ReflectionCacheRegistry.getContextClassLoader();
        return loader == null ? ClassLoader.getSystemClassLoader() : loader;
    }
}

