/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.SerialIDInstrumenter;
import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.StringUtility;
import com.agitar.concretemock.ClassFileWriter;
import com.agitar.concretemock.DescriptorAdjuster;
import com.agitar.concretemock.IncompatibleMockException;
import com.agitar.concretemock.InnerClassVisitor;
import com.agitar.concretemock.MockBytecodeUtil;
import com.agitar.concretemock.MockClassVisitor;
import com.agitar.concretemock.Mocker;
import com.agitar.concretemock.RealClassVisitor;
import com.agitar.lib.ConcreteMock;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class MergeClassMocker
extends Mocker {
    public static final int ADJUSTABLE = 144;
    private static final int FIELD_MASK = 3951;
    private static final int METHOD_MASK = 8;
    private final ClassNode realClass;
    private final ClassNode mockClass;
    private final String realName;
    private final String mockName;
    private final ClassFileWriter cfw;

    public MergeClassMocker(String realClass, String mockClass, Logger log, ClassFileWriter cfw) throws ClassNotFoundException {
        this(MockBytecodeUtil.parseClass(realClass), MockBytecodeUtil.parseClass(mockClass), log, cfw);
    }

    public MergeClassMocker(ClassNode realClass, ClassNode mockClass, Logger log, ClassFileWriter cfw) {
        super(log, MockBytecodeUtil.dotify(realClass.name));
        this.realClass = realClass;
        this.mockClass = mockClass;
        this.realName = MockBytecodeUtil.dotify(realClass.name);
        this.mockName = MockBytecodeUtil.dotify(mockClass.name);
        this.cfw = cfw;
    }

    public void run() {
        String[] roommates = new String[]{};
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (int i = 0; i < roommates.length; ++i) {
            String roommate = roommates[i];
            if (roommate.equals(this.realName) || roommate.indexOf(36) <= 0) continue;
            String newName = roommate + "Mock";
            replacements.put(MockBytecodeUtil.slashify(roommate), MockBytecodeUtil.slashify(newName));
        }
        HashSet inners = new HashSet(replacements.entrySet());
        this.replaceClass(replacements);
        replacements.put(MockBytecodeUtil.slashify(this.mockName), MockBytecodeUtil.slashify(this.realName));
        Iterator iterator = inners.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String innerMockName = (String)entry.getKey();
            String innerRealName = (String)entry.getValue();
            try {
                InputStream mockClassIn = MockBytecodeUtil.getClassLoader().getResourceAsStream(this.filename(innerMockName));
                ClassReader mockReader = new ClassReader(mockClassIn);
                ClassWriter writer = new ClassWriter(true, true);
                InnerClassVisitor innerClassVisitor = new InnerClassVisitor((ClassVisitor)writer, replacements);
                mockReader.accept((ClassVisitor)innerClassVisitor, AsmUtil.getDefaultAttributes(), false);
                mockClassIn.close();
                this.cfw.writeClass(innerRealName.replace('/', '.'), writer);
                Diagnostics.getKey((String)"mocks.used").set(ClassName.get((String)innerRealName), innerMockName);
            }
            catch (IOException e) {
                this.logError(e, DiagnosticResources.getResource((String)"problem.mock.exception", (Object[])new Object[]{this.realName, this.mockName, e.getMessage()}));
            }
        }
    }

    private String filename(String innerMockName) {
        return ClassName.get((String)innerMockName).getClassFileName();
    }

    private void replaceClass(Map replacements) {
        try {
            DescriptorAdjuster adjuster = new DescriptorAdjuster(this.realClass, this.mockClass);
            this.checkCompatibility(this.realClass, this.mockClass, adjuster);
            InputStream realClassIn = MockBytecodeUtil.getClassLoader().getResourceAsStream(this.filename(this.realName));
            InputStream mockClassIn = MockBytecodeUtil.getClassLoader().getResourceAsStream(this.filename(this.mockName));
            ClassReader realReader = new ClassReader(realClassIn);
            ClassReader mockReader = new ClassReader(mockClassIn);
            ClassWriter writer = new ClassWriter(true, true);
            InnerClassVisitor replacer = new InnerClassVisitor((ClassVisitor)writer, replacements);
            int version = Math.max(realReader.readInt(4), mockReader.readInt(4));
            this.visitHeader((ClassVisitor)replacer, this.realClass, this.mockClass, version);
            RealClassVisitor realClassVisitor = new RealClassVisitor((ClassVisitor)replacer, this.realClass, this.mockClass, adjuster);
            SerialIDInstrumenter serial = new SerialIDInstrumenter();
            serial.setNext((ClassVisitor)realClassVisitor);
            realReader.accept((ClassVisitor)serial, AsmUtil.getDefaultAttributes(), false);
            MockClassVisitor mockClassVisitor = new MockClassVisitor((ClassVisitor)replacer, this.realClass, realClassVisitor.getRealBodies(), adjuster);
            mockReader.accept((ClassVisitor)mockClassVisitor, AsmUtil.getDefaultAttributes(), false);
            this.visitFooter((ClassVisitor)writer);
            realClassIn.close();
            mockClassIn.close();
            this.cfw.writeClass(this.realName, writer);
            Diagnostics.getKey((String)"mocks.used").set(this.getRealName(), this.mockName);
        }
        catch (IncompatibleMockException e) {
            this.logError(null, DiagnosticResources.getResource((String)"problem.mock.incompatible", (Object[])new Object[]{this.realName, this.mockName, e.getMessage()}));
        }
        catch (RuntimeException e) {
            this.logError(e, DiagnosticResources.getResource((String)"problem.mock.exception", (Object[])new Object[]{this.realName, this.mockName, e.getMessage()}));
        }
        catch (IOException e) {
            this.logError(e, DiagnosticResources.getResource((String)"problem.mock.exception", (Object[])new Object[]{this.realName, this.mockName, e.getMessage()}));
        }
    }

    private void visitHeader(ClassVisitor writer, ClassNode realClass, ClassNode mockClass, int version) {
        HashSet<String> interfaceNames = new HashSet<String>();
        interfaceNames.addAll(realClass.interfaces);
        interfaceNames.addAll(mockClass.interfaces);
        interfaceNames.add(MockBytecodeUtil.slashify(ConcreteMock.class.getName()));
        writer.visit(version, realClass.access, realClass.name, realClass.superName, StringUtility.strings(interfaceNames), "ConcreteMock");
    }

    private void visitFooter(ClassVisitor writer) {
        writer.visitEnd();
    }

    private void checkCompatibility(ClassNode realClass, ClassNode mockClass, DescriptorAdjuster adjuster) throws IncompatibleMockException {
        if (realClass.name.equals(mockClass.name)) {
            throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.same"));
        }
        if (!realClass.superName.equals(mockClass.superName)) {
            throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.superclass"));
        }
        if (MockBytecodeUtil.findClass(realClass.name).getFile().indexOf("/rt.jar") >= 0) {
            throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.system"));
        }
        this.checkFieldCompatibility(realClass, mockClass, adjuster);
        this.checkMethodCompatibility(realClass, mockClass, adjuster);
    }

    private void checkMethodCompatibility(ClassNode realClass, ClassNode mockClass, DescriptorAdjuster adjuster) throws IncompatibleMockException {
        Iterator realMethodIterator = realClass.methods.iterator();
        while (realMethodIterator.hasNext()) {
            MethodNode realMethod = (MethodNode)realMethodIterator.next();
            if ((realMethod.access & 0x1000) != 0) continue;
            Iterator mockMethodIterator = mockClass.methods.iterator();
            while (mockMethodIterator.hasNext()) {
                MethodNode mockMethod = (MethodNode)mockMethodIterator.next();
                if (!mockMethod.name.equals(realMethod.name)) continue;
                this.compareMethods(realMethod, mockMethod, adjuster);
            }
        }
    }

    private void compareMethods(MethodNode realMethod, MethodNode mockMethod, DescriptorAdjuster adjuster) throws IncompatibleMockException {
        String adjustedDesc = adjuster.adjust(mockMethod.desc);
        Type realReturnType = Type.getReturnType((String)realMethod.desc);
        Type mockReturnType = Type.getReturnType((String)adjustedDesc);
        Object[] realParamTypes = Type.getArgumentTypes((String)realMethod.desc);
        Object[] mockParamTypes = Type.getArgumentTypes((String)adjustedDesc);
        if (Arrays.equals(mockParamTypes, realParamTypes)) {
            int mockModifiers = mockMethod.access & 8;
            int realModifiers = realMethod.access & 8;
            if (mockModifiers != realModifiers && (mockMethod.access & 0x400) == 0) {
                throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.method.modifiers", (Object[])new Object[]{realMethod.name}));
            }
            if (!realReturnType.equals((Object)mockReturnType)) {
                throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.method.return", (Object[])new Object[]{realMethod.name}));
            }
        }
    }

    private void checkFieldCompatibility(ClassNode realClass, ClassNode mockClass, DescriptorAdjuster adjuster) throws IncompatibleMockException {
        Iterator realFieldIterator = realClass.fields.iterator();
        while (realFieldIterator.hasNext()) {
            FieldNode realField = (FieldNode)realFieldIterator.next();
            if ((realField.access & 0x1000) != 0) continue;
            Iterator mockFieldIterator = mockClass.fields.iterator();
            while (mockFieldIterator.hasNext()) {
                FieldNode mockField = (FieldNode)mockFieldIterator.next();
                if (!mockField.name.equals(realField.name)) continue;
                this.compareFields(realField, mockField, adjuster);
            }
        }
    }

    private void compareFields(FieldNode realField, FieldNode mockField, DescriptorAdjuster adjuster) throws IncompatibleMockException {
        int mockMods = mockField.access & 0xF6F;
        int realMods = realField.access & 0xF6F;
        if (mockMods != realMods) {
            throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.field.modifiers", (Object[])new Object[]{realField.name}));
        }
        String mockDesc = mockField.desc;
        String realDesc = realField.desc;
        if (!adjuster.adjust(mockDesc).equals(realDesc)) {
            throw new IncompatibleMockException(DiagnosticResources.getResource((String)"problem.mock.incompatible.field.type", (Object[])new Object[]{realField.name}));
        }
    }
}

