/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class InnerClassVisitor
extends ClassAdapter {
    private final Map mockToFinalName;

    public InnerClassVisitor(ClassVisitor classVisitor, Map mockToFinalName) {
        super(classVisitor);
        this.mockToFinalName = mockToFinalName;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        super.visit(version, access, this.replace(name), this.replace(superName), this.replace(interfaces), sourceFile);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, this.replace(outerName), this.replace(innerName), access);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        super.visitField(access, name, this.replace(desc), value, attrs);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        return new CodeAdapter(super.visitMethod(access, name, this.replace(desc), exceptions, attrs)){

            public void visitTypeInsn(int opcode, String desc) {
                super.visitTypeInsn(opcode, InnerClassVisitor.this.replace(desc));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                super.visitFieldInsn(opcode, InnerClassVisitor.this.replace(owner), name, InnerClassVisitor.this.replace(desc));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                super.visitMethodInsn(opcode, InnerClassVisitor.this.replace(owner), name, InnerClassVisitor.this.replace(desc));
            }

            public void visitMultiANewArrayInsn(String desc, int dims) {
                super.visitMultiANewArrayInsn(InnerClassVisitor.this.replace(desc), dims);
            }

            public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
                super.visitLocalVariable(name, InnerClassVisitor.this.replace(desc), start, end, index);
            }
        };
    }

    String replace(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("(")) {
            Type[] args = Type.getArgumentTypes((String)name);
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            for (int i = 0; i < args.length; ++i) {
                buf.append(this.replaceType(args[i]));
            }
            buf.append(')');
            buf.append(this.replaceType(Type.getReturnType((String)name)));
            return buf.toString();
        }
        if (name.endsWith(";")) {
            return this.replaceType(Type.getType((String)name));
        }
        if (this.mockToFinalName.containsKey(name)) {
            return (String)this.mockToFinalName.get(name);
        }
        return name;
    }

    String replaceType(Type arg) {
        if (arg.getSort() == 10) {
            return 'L' + this.replace(arg.getInternalName()) + ';';
        }
        return arg.getDescriptor();
    }

    String[] replace(String[] names) {
        if (names == null) {
            return null;
        }
        String[] replacements = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            replacements[i] = this.replace(names[i]);
        }
        return replacements;
    }
}

