/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.types.ClassName;
import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

class DescriptorAdjuster {
    private final String realNameSlashed;
    private final String mockNameSlashed;
    private final boolean toInner;

    public DescriptorAdjuster(ClassNode realClass, ClassNode mockClass) {
        this.realNameSlashed = realClass.name.replace('.', '/');
        this.mockNameSlashed = mockClass.name.replace('.', '/');
        if (ClassName.get((String)this.realNameSlashed).isInnerClass()) {
            boolean hasInnerThis = false;
            Iterator iterator = realClass.fields.iterator();
            while (iterator.hasNext()) {
                FieldNode field = (FieldNode)iterator.next();
                if (!field.name.equals("this$0")) continue;
                hasInnerThis = true;
            }
            this.toInner = hasInnerThis;
        } else {
            this.toInner = false;
        }
    }

    public boolean isToInner() {
        return this.toInner;
    }

    public String getRealNameSlashed() {
        return this.realNameSlashed;
    }

    public String getMockNameSlashed() {
        return this.mockNameSlashed;
    }

    public String getOuterDescriptor() {
        ClassName realCN = ClassName.get((String)this.realNameSlashed);
        ClassName outerCN = realCN.getContainingClass();
        return outerCN == null ? null : outerCN.getBytecodeName();
    }

    public String adjust(String desc) {
        if (desc.equals(this.mockNameSlashed)) {
            return this.realNameSlashed;
        }
        if (desc.equals('L' + this.mockNameSlashed + ';')) {
            return 'L' + this.realNameSlashed + ';';
        }
        if (desc.startsWith("[") && desc.endsWith('L' + this.mockNameSlashed + ';')) {
            return desc.substring(0, desc.indexOf(76)) + 'L' + this.realNameSlashed + ';';
        }
        if (desc.charAt(0) != '(') {
            return desc;
        }
        return this.replaceMockWithReal(desc);
    }

    public String adjust(String name, String desc) {
        if (this.toInner && name.equals("<init>")) {
            int paramStart = desc.indexOf(40) + 1;
            return this.adjust(desc.substring(0, paramStart) + this.getOuterDescriptor() + desc.substring(paramStart));
        }
        return this.adjust(desc);
    }

    public String adjust(String owner, String name, String desc) {
        if (this.toInner && owner.equals(this.mockNameSlashed) && name.equals("<init>")) {
            int paramStart = desc.indexOf(40) + 1;
            return this.adjust(desc.substring(0, paramStart) + this.getOuterDescriptor() + desc.substring(paramStart));
        }
        return this.adjust(desc);
    }

    private String replaceMockWithReal(String desc) {
        Type returnType = Type.getReturnType((String)desc);
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        StringBuffer buf = new StringBuffer(256);
        buf.append('(');
        for (int i = 0; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            buf.append(this.adjust(argType.getDescriptor()));
        }
        buf.append(')');
        buf.append(this.adjust(returnType.getDescriptor()));
        return buf.toString();
    }
}

