/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.types.ClassName;
import java.util.Comparator;

public class ConcreteMockInfo {
    public static final String TOMBSTONE = "null";
    public static final String AUTO = "(auto)";
    private ClassName realClassName;
    private ClassName mockClassName;
    private boolean inherited;
    private boolean enabled = true;
    public static final Comparator SORT_BY_REAL_NAME = new Comparator(){

        public int compare(Object o1, Object o2) {
            ConcreteMockInfo cmi1 = (ConcreteMockInfo)o1;
            ConcreteMockInfo cmi2 = (ConcreteMockInfo)o2;
            return ClassName.COMPARE_BY_NAME.compare(cmi1.getRealClassName(), cmi2.getRealClassName());
        }
    };

    public ConcreteMockInfo(ConcreteMockInfo cmi) {
        this.realClassName = cmi.realClassName;
        this.mockClassName = cmi.mockClassName;
        this.inherited = cmi.inherited;
        this.enabled = cmi.enabled;
    }

    public ConcreteMockInfo(String realClassName, String mockClassName) {
        this.realClassName = ClassName.get((String)realClassName);
        this.mockClassName = ClassName.get((String)mockClassName);
    }

    public ClassName getRealClassName() {
        return this.realClassName;
    }

    public void setRealClassName(ClassName realClassName) {
        this.realClassName = realClassName;
    }

    public ClassName getMockClassName() {
        return this.mockClassName;
    }

    public void setMockClassName(ClassName mockClassName) {
        this.mockClassName = mockClassName;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.inherited ? "INH" : "LOC");
        buf.append(' ');
        buf.append(this.enabled ? "[X]" : "[ ]");
        buf.append(' ');
        buf.append(this.realClassName);
        buf.append(" -> ");
        buf.append(this.mockClassName);
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConcreteMockInfo) {
            ConcreteMockInfo cmi = (ConcreteMockInfo)o;
            return this.enabled == cmi.enabled && this.realClassName.equals((Object)cmi.realClassName) && this.mockClassName.equals((Object)cmi.mockClassName);
        }
        return false;
    }

    public int hashCode() {
        return this.realClassName.hashCode() ^ this.mockClassName.hashCode();
    }
}

