/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.StringUtility;
import com.agitar.concretemock.ClassFileWriter;
import com.agitar.concretemock.MockBytecodeUtil;
import com.agitar.concretemock.Mocker;
import com.agitar.lib.ConcreteMock;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class AutoInterfaceMocker
extends Mocker {
    private final ClassNode realClass;
    private final ClassName mockClassName;
    private final ClassFileWriter cfw;

    public AutoInterfaceMocker(ClassNode realClass, Logger log, ClassFileWriter cfw) {
        super(log, MockBytecodeUtil.dotify(realClass.name));
        if (realClass == null || cfw == null) {
            throw new NullPointerException();
        }
        this.realClass = realClass;
        this.cfw = cfw;
        ClassName cn = ClassName.get((String)realClass.name);
        this.mockClassName = cn.getPackageName().equals("") ? ClassName.get((String)(cn + "$Agitator_autoMock_class$1")) : ClassName.get((String)(cn.getPackageName() + "." + cn.getNameWithoutPackage() + "$Agitator_autoMock_class$1"));
    }

    public ClassName getMockClassName() {
        return this.mockClassName;
    }

    public void run() {
        ClassWriter writer = new ClassWriter(true, true);
        String className = MockBytecodeUtil.slashify(this.mockClassName);
        ArrayList<String> interfaces = new ArrayList<String>(this.realClass.interfaces);
        interfaces.add(this.realClass.name);
        interfaces.add(ConcreteMock.class.getName());
        String[] combinedInterfaces = MockBytecodeUtil.slashify(StringUtility.strings(interfaces));
        writer.visit(48, 1, className, "java/lang/Object", combinedInterfaces, "synthetic");
        List methods = this.realClass.methods;
        try {
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                MethodNode method = (MethodNode)iterator.next();
                if (Modifier.isPrivate(method.access) || Modifier.isStatic(method.access) || !Modifier.isAbstract(method.access)) continue;
                MockBytecodeUtil.generateMethodImpl(this.realClass, method, (ClassVisitor)writer);
            }
            AutoInterfaceMocker.generateDefaultConstructor(writer);
            writer.visitEnd();
            this.cfw.writeClass(this.mockClassName.toString(), writer);
            Diagnostics.getKey((String)"mocks.used").set(this.getRealName(), "(auto)");
        }
        catch (Exception e) {
            this.logError(e, DiagnosticResources.getResource((String)"problem.mock.exception.auto", (Object[])new Object[]{this.getRealName(), e.getMessage()}));
        }
    }

    private static void generateDefaultConstructor(ClassWriter writer) {
        CodeVisitor cv = writer.visitMethod(1, "<init>", "()V", new String[0], null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }
}

