/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.concretemock;

import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.util.StringUtility;
import com.agitar.concretemock.ClassFileWriter;
import com.agitar.concretemock.MockBytecodeUtil;
import com.agitar.concretemock.Mocker;
import com.agitar.lib.ConcreteMock;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AutoClassMocker
extends Mocker {
    private ClassNode realClass;
    private final ClassFileWriter cfw;

    public AutoClassMocker(ClassNode realClass, Logger log, ClassFileWriter cfw) {
        super(log, MockBytecodeUtil.dotify(realClass.name));
        if (realClass == null || cfw == null) {
            throw new NullPointerException();
        }
        this.realClass = realClass;
        this.cfw = cfw;
    }

    public void run() {
        ClassWriter writer = new ClassWriter(true, true);
        String className = MockBytecodeUtil.slashify(this.realClass.name);
        String superClassName = MockBytecodeUtil.slashify(this.realClass.superName);
        ArrayList<String> interfaces = new ArrayList<String>(this.realClass.interfaces);
        interfaces.add(ConcreteMock.class.getName());
        String[] combinedInterfaces = MockBytecodeUtil.slashify(StringUtility.strings(interfaces));
        writer.visit(48, this.realClass.access, className, superClassName, combinedInterfaces, "synthetic.java");
        try {
            this.copyMethods(writer);
            this.copyFields(writer);
            writer.visitEnd();
            this.cfw.writeClass(this.realClass.name.replace('/', '.'), writer);
            Diagnostics.getKey((String)"mocks.used").set(this.getRealName(), "(auto)");
        }
        catch (Exception e) {
            this.logError(e, DiagnosticResources.getResource((String)"problem.mock.exception.auto", (Object[])new Object[]{this.getRealName(), e.getMessage()}));
        }
    }

    private void copyMethods(ClassWriter writer) throws ClassNotFoundException {
        List methods = this.realClass.methods;
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            MockBytecodeUtil.generateMethodImpl(this.realClass, method, (ClassVisitor)writer);
        }
    }

    private void copyFields(ClassWriter writer) {
        List fields = this.realClass.fields;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldNode field = (FieldNode)iterator.next();
            if (Modifier.isPrivate(field.access)) continue;
            writer.visitField(field.access, field.name, field.desc, null, null);
        }
    }
}

