/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage.util;

import com.agitar.common.util.IOUtility;
import com.agitar.eclipse.core.AgUIException;
import com.agitar.eclipse.core.util.PluginUtils;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.launching.IVMInstall;

public class VMInformation {
    private String version;
    private String vendor;
    private String bootClassPath;
    private String extDirs;
    private String endorsedDirs;
    private String javaHome;
    private static final String UNKOWN_VERSION = "0.0";
    private static HashMap vmInfoCache = new HashMap();
    private static final String[] candidateJavaLocations = new String[]{"bin" + File.separatorChar + "java", "bin" + File.separatorChar + "java.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "java", "jre" + File.separatorChar + "bin" + File.separatorChar + "java.exe"};

    private VMInformation() {
    }

    public static VMInformation getVMInformation(IVMInstall vmInstall) {
        File javaHome = vmInstall.getInstallLocation();
        File java = VMInformation.findJavaExecutable(javaHome);
        return VMInformation.getVMInformation(javaHome, java);
    }

    public static File findJavaExecutable(File vmInstallLocation) {
        for (int i = 0; i < candidateJavaLocations.length; ++i) {
            File javaFile = new File(vmInstallLocation, candidateJavaLocations[i]);
            if (!javaFile.isFile()) continue;
            return javaFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VMInformation getVMInformation(File javaHomeFile, File javaExecutable) {
        VMInformation info = null;
        try {
            if (javaExecutable == null) {
                throw new AgUIException("Couldn't find java executable.");
            }
            String javaHome = IOUtility.getCanonicalPath((File)javaHomeFile);
            if (vmInfoCache.containsKey(javaHome)) {
                return (VMInformation)vmInfoCache.get(javaHome);
            }
            Path path = PluginUtils.findFileInPlugin((String)"com.agitar.eclipse.coverage", (String)"lib/jvmdetector.jar");
            File file = path.toFile();
            if (file.exists()) {
                String javaExecutablePath = javaExecutable.getAbsolutePath();
                String[] cmdLine = new String[]{javaExecutablePath, "-classpath", file.getAbsolutePath(), "agitar.eclipse.project.JVMDetector"};
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(cmdLine);
                    IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"JVM Detection");
                    for (int i = 0; i < 200 && !process.isTerminated(); ++i) {
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    info = VMInformation.parseVMInfo(process);
                }
                finally {
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            if (info == null) {
                throw new AgUIException("Failed to retrieve default libraries for " + javaHome);
            }
            vmInfoCache.put(javaHome, info);
            return info;
        }
        catch (Exception ex) {
            PluginUtils.logExceptionInfo((Throwable)ex, (String)"com.agitar.eclipse.coverage");
            info = new VMInformation();
            info.vendor = "unknown";
            info.version = UNKOWN_VERSION;
            info.endorsedDirs = "";
            info.extDirs = "";
            info.bootClassPath = "";
            info.javaHome = javaHomeFile.getAbsolutePath();
            return info;
        }
    }

    public boolean isUnknown() {
        return UNKOWN_VERSION.equals(this.version);
    }

    private static VMInformation parseVMInfo(IProcess process) throws AgUIException {
        String[] parts;
        VMInformation info = new VMInformation();
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if ((parts = text.split("\\|\\|")).length != 6) {
            throw new AgUIException("Invalid format from JVMDetector process: " + text);
        }
        info.javaHome = parts[0];
        info.version = parts[1];
        info.vendor = parts[2];
        info.bootClassPath = parts[3];
        info.extDirs = parts[4];
        info.endorsedDirs = parts[5];
        return info;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String getEndorsedDirs() {
        return this.endorsedDirs;
    }

    public String getExtDirs() {
        return this.extDirs;
    }

    public String getJavaHome() {
        return this.javaHome;
    }
}

