/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.common.util.ArrayUtil;
import com.agitar.eclipse.core.resources.DotAgitatorFile;
import com.agitar.eclipse.core.util.AgSimpleListEditor;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;

public class ExclusionsEditor
extends AgSimpleListEditor {
    private static final String EXCLUSION_MESSAGE = "Enter a pattern for excluding files from upload to the server. Allowed wildcards are '*', '?' and '**'. Examples: 'java/util/A*.java', 'java/util/', '**/Test*'. All paths are relative to ";
    DotAgitatorFile daf;
    private IProject project;

    public ExclusionsEditor(IProject project, DotAgitatorFile daf, String labelText, Composite parent) {
        super("exclusions", labelText, parent);
        this.daf = daf;
        this.project = project;
    }

    protected String createList(String[] items) {
        return null;
    }

    protected String getNewInputObject() {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return "Error: Pattern cannot be empty.";
                }
                Path path = new Path(newText);
                if (path.isAbsolute() || path.getDevice() != null) {
                    return "Error: Path must be relative.";
                }
                return null;
            }
        };
        InputDialog dlg = new InputDialog(this.getShell(), "Exclusion Pattern", "Enter a pattern for excluding files from upload to the server. Allowed wildcards are '*', '?' and '**'. Examples: 'java/util/A*.java', 'java/util/', '**/Test*'. All paths are relative to '/" + this.project.getName() + "'.", "", validator);
        dlg.create();
        dlg.open();
        return dlg.getReturnCode() == 1 ? null : dlg.getValue();
    }

    protected String[] parseString(String stringList) {
        return null;
    }

    protected void doLoad() {
        if (this.list != null) {
            String[] array = this.daf.getExclusionPatterns().toArray(new String[0]);
            for (int i = 0; i < array.length; ++i) {
                this.list.add(array[i]);
            }
        }
    }

    protected void doStore() {
        HashSet<String> set = new HashSet<String>();
        String[] items = this.list.getItems();
        for (int i = 0; i < items.length; ++i) {
            set.add(items[i]);
        }
        this.daf.setExclusionPatterns(set);
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            this.daf.setExclusionPatterns(ArrayUtil.EMPTYSET);
        }
    }
}

