/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.coverage.CoverageSummaryViewerSorter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class CoverageTreeWrapper {
    static /* synthetic */ Class class$java$lang$String;

    public static void updateSortState(CoverageSummaryViewerSorter sorter, TreeViewer viewer, int col, int dir) throws Exception {
        if (!PluginUtils.isEclipse32()) {
            return;
        }
        Tree tree = viewer.getTree();
        Class<?> clazz = tree.getClass();
        String treeColName = "org.eclipse.swt.widgets.TreeColumn";
        Class<?> treeColClazz = clazz.getClassLoader().loadClass(treeColName);
        Method sortColumnMethod = clazz.getDeclaredMethod("setSortColumn", treeColClazz);
        Method sortDirectionMethod = clazz.getDeclaredMethod("setSortDirection", Integer.TYPE);
        Object[] sortArgs = new Object[1];
        Object[] dirArgs = new Object[1];
        Object[] cols = CoverageTreeWrapper.getTreeColumnsForTree(tree);
        if (cols == null || cols.length < 2) {
            return;
        }
        sortArgs[0] = cols[col];
        dirArgs[0] = new Integer(dir);
        if (sortArgs[0] != null) {
            sortColumnMethod.invoke((Object)tree, sortArgs);
        }
        if (dirArgs[0] != null) {
            sortDirectionMethod.invoke((Object)tree, dirArgs);
        }
    }

    public static void addTreeColumns(final TreeViewer treeViewer, String[] colNames, int[] colAligns, int[] colWidths, final CoverageSummaryViewerSorter viewSorter) {
        if (PluginUtils.isEclipse30()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.widgets.TreeColumn");
            Listener nameSortListener = new Listener(){

                public void handleEvent(Event event) {
                    if (viewSorter != null && treeViewer != null) {
                        viewSorter.flipNameSortState();
                        treeViewer.refresh(true);
                    }
                }
            };
            Listener covSortListener = new Listener(){

                public void handleEvent(Event event) {
                    if (viewSorter != null && treeViewer != null) {
                        viewSorter.flipCovSortState();
                        treeViewer.refresh(true);
                    }
                }
            };
            for (int i = 0; i < colNames.length; ++i) {
                Object treeCol = CoverageTreeWrapper.getNewTreeColumn(treeViewer.getTree());
                Method setTextMethod = clazz.getDeclaredMethod("setText", class$java$lang$String == null ? CoverageTreeWrapper.class$("java.lang.String") : class$java$lang$String);
                Method setWidthMethod = clazz.getDeclaredMethod("setWidth", Integer.TYPE);
                Method setAlignmentMethod = clazz.getDeclaredMethod("setAlignment", Integer.TYPE);
                if (treeCol instanceof Widget) {
                    if (i == 0) {
                        ((Widget)treeCol).addListener(13, nameSortListener);
                    } else if (i == 1) {
                        ((Widget)treeCol).addListener(13, covSortListener);
                    }
                }
                setTextMethod.invoke(treeCol, colNames[i]);
                setWidthMethod.invoke(treeCol, new Integer(colWidths[i]));
                setAlignmentMethod.invoke(treeCol, new Integer(colAligns[i]));
            }
            Method setHeaderVisMethod = treeViewer.getTree().getClass().getDeclaredMethod("setHeaderVisible", Boolean.TYPE);
            Method setLinesVisMethod = treeViewer.getTree().getClass().getDeclaredMethod("setLinesVisible", Boolean.TYPE);
            setHeaderVisMethod.invoke((Object)treeViewer.getTree(), new Boolean(true));
            setLinesVisMethod.invoke((Object)treeViewer.getTree(), new Boolean(true));
            viewSorter.resort();
        }
        catch (Exception e) {
            PluginUtils.displayExceptionInfo((Shell)treeViewer.getControl().getShell(), (Throwable)e, (String)"com.agitar.eclipse.coverage");
        }
    }

    private static Object getNewTreeColumn(Tree tree) throws Exception {
        Class<?> clazz = Class.forName("org.eclipse.swt.widgets.TreeColumn");
        Class[] constructorParams = new Class[]{Tree.class, Integer.TYPE};
        Constructor<?> tcConsructor = clazz.getDeclaredConstructor(constructorParams);
        return tcConsructor.newInstance(tree, new Integer(16384));
    }

    private static Object[] getTreeColumnsForTree(Tree tree) throws Exception {
        Method getColumnsMethod = tree.getClass().getMethod("getColumns", new Class[0]);
        return (Object[])getColumnsMethod.invoke((Object)tree, new Object[0]);
    }

    public static void resizeColumns(Composite parent, int covColWidth, int covColumn, int nameColumn, TreeViewer coverageTableTree) {
        if (PluginUtils.isEclipse30()) {
            return;
        }
        Rectangle area = parent.getClientArea();
        Point preferredSize = coverageTableTree.getTree().computeSize(-1, -1);
        int width = area.width - 2 * coverageTableTree.getTree().getBorderWidth() - 5;
        int height = area.height - 2 * coverageTableTree.getTree().getBorderWidth() - 5;
        if (preferredSize.y > area.height) {
            Point vBarSize = coverageTableTree.getTree().getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        if (preferredSize.y > area.width) {
            Point hBarSize = coverageTableTree.getTree().getHorizontalBar().getSize();
            height -= hBarSize.x;
        }
        Point oldSize = coverageTableTree.getTree().getSize();
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.widgets.TreeColumn");
            Object[] treeColumns = CoverageTreeWrapper.getTreeColumnsForTree(coverageTableTree.getTree());
            Method setWidthMethod = clazz.getDeclaredMethod("setWidth", Integer.TYPE);
            if (oldSize.x > area.width) {
                setWidthMethod.invoke(treeColumns[covColumn], new Integer(covColWidth));
                setWidthMethod.invoke(treeColumns[nameColumn], new Integer(width - (covColWidth + 15)));
                coverageTableTree.getTree().setSize(area.width - 10, area.height - 10);
            } else {
                coverageTableTree.getTree().setSize(area.width - 10, area.height - 10);
                setWidthMethod.invoke(treeColumns[covColumn], new Integer(covColWidth));
                setWidthMethod.invoke(treeColumns[nameColumn], new Integer(width - (covColWidth + 15)));
            }
        }
        catch (Exception e) {
            PluginUtils.displayExceptionInfo((Shell)coverageTableTree.getControl().getShell(), (Throwable)e, (String)"com.agitar.eclipse.coverage");
        }
    }
}

