/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.eclipse.core.util.JavaElementLabelsWrapper;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.coverage.AgitatorCoveragePlugin;
import com.agitar.eclipse.coverage.CoverageHelper;
import com.agitar.eclipse.coverage.CoverageTreeWrapper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class CoverageSummaryViewerSorter
extends ViewerSorter {
    private static final Integer NO_COV_INT = new Integer(-2);
    public static final int SORT_NAME_UP = 0;
    public static final int SORT_NAME_DOWN = 1;
    public static final int SORT_COV_UP = 2;
    public static final int SORT_COV_DOWN = 3;
    private boolean nameUp = true;
    private boolean covUp = true;
    private int sortState;
    private TreeViewer view;

    public CoverageSummaryViewerSorter(TreeViewer view) {
        this.view = view;
        this.sortState = AgitatorCoveragePlugin.getDefault().getPreferenceStore().getInt("coverageSortDirection");
        this.setSortColumn(this.sortState);
    }

    private void setSortColumn(int state) {
        switch (state) {
            case 2: {
                this.updateSortColumn(1, 128);
                break;
            }
            case 3: {
                this.updateSortColumn(1, 1024);
                break;
            }
            case 1: {
                this.updateSortColumn(0, 1024);
                break;
            }
            case 0: {
                this.updateSortColumn(0, 128);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        switch (this.sortState) {
            case 2: {
                return this.sortByCoverage(true, e1, e2, true);
            }
            case 3: {
                return this.sortByCoverage(false, e1, e2, true);
            }
            case 1: {
                return this.sortByName(false, e1, e2, true);
            }
        }
        return this.sortByName(true, e1, e2, true);
    }

    public int sortByCoverage(boolean up, Object e1, Object e2, boolean keepGoing) {
        Integer e2CovInt;
        Integer e1CovInt;
        String e1Cov = this.getCoverage(e1);
        String e2Cov = this.getCoverage(e2);
        try {
            e1CovInt = new Integer(e1Cov);
        }
        catch (Exception e) {
            e1CovInt = NO_COV_INT;
        }
        try {
            e2CovInt = new Integer(e2Cov);
        }
        catch (Exception e) {
            e2CovInt = NO_COV_INT;
        }
        if (e1CovInt.equals(e2CovInt)) {
            if (keepGoing) {
                return this.sortByName(this.nameUp, e1, e2, false);
            }
        } else {
            return up ? e1CovInt.compareTo(e2CovInt) : e2CovInt.compareTo(e1CovInt);
        }
        return 0;
    }

    public String getCoverage(Object object) {
        if (object instanceof IJavaElement) {
            return CoverageHelper.getCoverage(null, (IJavaElement)object);
        }
        return "";
    }

    public int sortByName(boolean up, Object e1, Object e2, boolean keepGoing) {
        block9: {
            String name1 = null;
            String name2 = null;
            if (e1 instanceof IType && e2 instanceof IType) {
                name1 = ((IType)e1).getFullyQualifiedName();
                name2 = ((IType)e2).getFullyQualifiedName();
            } else if (e1 instanceof IMethod && e2 instanceof IMethod) {
                name1 = JavaElementLabelsWrapper.getElementDisplayName((IJavaElement)((IJavaElement)e1));
                name2 = JavaElementLabelsWrapper.getElementDisplayName((IJavaElement)((IJavaElement)e2));
            } else if (e1 instanceof IJavaElement && e2 instanceof IJavaElement) {
                name1 = ((IJavaElement)e1).getElementName();
                name2 = ((IJavaElement)e2).getElementName();
            }
            try {
                int result;
                int n = result = up ? name1.compareTo(name2) : name2.compareTo(name1);
                if (result == 0) {
                    if (keepGoing) {
                        return this.sortByCoverage(this.covUp, e1, e2, false);
                    }
                    break block9;
                }
                return result;
            }
            catch (Exception e) {
                if (!keepGoing) break block9;
                return this.sortByCoverage(this.covUp, e1, e2, false);
            }
        }
        return 0;
    }

    public void flipNameSortState() {
        this.nameUp = !this.nameUp;
        int state = this.nameUp ? 0 : 1;
        this.setSortState(state);
        this.setSortColumn(state);
    }

    private void setSortState(int state) {
        this.sortState = state;
        AgitatorCoveragePlugin.getDefault().getPreferenceStore().setValue("coverageSortDirection", this.sortState);
    }

    public void flipCovSortState() {
        this.covUp = !this.covUp;
        int state = this.covUp ? 2 : 3;
        this.setSortState(state);
        this.setSortColumn(state);
    }

    public void updateSortColumn(int col, int dir) {
        try {
            CoverageTreeWrapper.updateSortState(this, this.view, col, dir);
        }
        catch (Exception e) {
            PluginUtils.logExceptionInfo((Throwable)e, (String)"com.agitar.eclipse.coverage");
        }
    }

    public void resort() {
        this.setSortColumn(this.sortState);
    }
}

