/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.eclipse.core.util.AgSWTUtilities;
import com.agitar.eclipse.core.util.HelpUtils;
import com.agitar.eclipse.core.util.JavaElementUtils;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.coverage.AgitatorCoveragePlugin;
import com.agitar.eclipse.coverage.CoverageHelper;
import com.agitar.eclipse.coverage.CoverageSummary30LabelProvider;
import com.agitar.eclipse.coverage.CoverageSummaryLabelProvider;
import com.agitar.eclipse.coverage.CoverageSummaryViewerFilter;
import com.agitar.eclipse.coverage.CoverageSummaryViewerSorter;
import com.agitar.eclipse.coverage.CoverageSummaryViewerSorter30;
import com.agitar.eclipse.coverage.CoverageTreeWrapper;
import com.agitar.icon.IconUtility;
import com.agitar.lib.NoObfuscation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class CoverageSummaryView
extends ViewPart
implements NoObfuscation,
IPartListener2,
IResourceChangeListener,
ISelectionProvider,
ISelectionChangedListener {
    public static final String ID = "com.agitar.eclipse.coverage.CoverageSummaryView";
    public static final String NO_COV_STR = "";
    private TreeViewer coverageTableTree;
    public static final String[] COL_NAMES = new String[]{"Name", "Cov. %"};
    private static final int[] COL_ALIGNMENTS = new int[]{16384, 0x1000000};
    private static final int[] COL_WIDTHS = new int[]{400, 120};
    public static final int COV_COLUMN = 1;
    public static final int NAME_COLUMN = 0;
    private Composite summaryComposite;
    private GoToAction goToAction;
    private LinkAction linkAction;
    private Composite mainComposite;
    private CoverageSummaryViewerSorter viewSorter;
    private Action expandAllAction;
    private Action collapseAllAction;
    private boolean listening;
    private IJavaElement[] visibleElements;
    private IJavaElement sourceElementForCurrentVisibleElements;
    private HashMap selectionMap = new HashMap();
    private HashMap expansionMap = new HashMap();
    private boolean isLinked;
    private ArrayList treeContents = new ArrayList();
    private ISelection currSel;
    private static final int COV_COL_WIDTH = 100;

    private IJavaElement[] getChildrenForElement(IJavaElement element) throws JavaModelException {
        if (!(element instanceof IParent)) {
            return new IJavaElement[0];
        }
        if (element instanceof IJavaProject) {
            IPackageFragmentRoot[] frags = ((IJavaProject)element).getPackageFragmentRoots();
            ArrayList<IPackageFragmentRoot> fragList = new ArrayList<IPackageFragmentRoot>();
            for (int i = 0; i < frags.length; ++i) {
                if (frags[i].getKind() != 1) continue;
                fragList.add(frags[i]);
            }
            return fragList.toArray(new IPackageFragmentRoot[fragList.size()]);
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getChildren();
        }
        if (element instanceof IPackageFragment) {
            return ((IPackageFragment)element).getCompilationUnits();
        }
        if (element instanceof ICompilationUnit) {
            IType type = ((ICompilationUnit)element).findPrimaryType();
            if (type == null) {
                return new IJavaElement[0];
            }
            return type.getMethods();
        }
        if (element instanceof IType) {
            ICompilationUnit unit = ((IType)element).getCompilationUnit();
            if (unit == null) {
                return new IJavaElement[0];
            }
            IType[] allTypes = unit.getAllTypes();
            for (int i = 0; i < allTypes.length; ++i) {
                if (!allTypes[i].equals(element)) continue;
                return allTypes[i].getMethods();
            }
            IType type = unit.findPrimaryType();
            if (type == null) {
                return new IJavaElement[0];
            }
            return type.getMethods();
        }
        return new IJavaElement[0];
    }

    public Composite createMainPage(Composite parent) {
        HelpUtils.setHelp((Control)parent, (String)this.getHelpID());
        this.mainComposite = new Composite(parent, 0);
        this.setPartName("Coverage Summary");
        GridLayout layout = new GridLayout(1, false);
        this.mainComposite.setLayout((Layout)layout);
        this.coverageTableTree = new TreeViewer(this.mainComposite, 68352);
        this.coverageTableTree.setAutoExpandLevel(2);
        GridData gd = new GridData(4, 4, true, true);
        this.coverageTableTree.getControl().setLayoutData((Object)gd);
        this.coverageTableTree.setContentProvider((IContentProvider)new CoverageSummaryContentProvider());
        if (PluginUtils.isEclipse30()) {
            this.coverageTableTree.setLabelProvider((IBaseLabelProvider)new CoverageSummary30LabelProvider(this, this.coverageTableTree.getControl().getFont()));
        } else {
            this.coverageTableTree.setLabelProvider((IBaseLabelProvider)new CoverageSummaryLabelProvider(this, this.coverageTableTree.getControl().getFont()));
        }
        if (PluginUtils.isEclipse30()) {
            this.coverageTableTree.setSorter((ViewerSorter)new CoverageSummaryViewerSorter30());
        } else {
            this.viewSorter = new CoverageSummaryViewerSorter(this.coverageTableTree);
            this.coverageTableTree.setSorter((ViewerSorter)this.viewSorter);
        }
        this.coverageTableTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                this.updateAfterChange();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.updateAfterChange();
            }

            private void updateAfterChange() {
                Object[] elems;
                if (CoverageSummaryView.this.sourceElementForCurrentVisibleElements != null && (elems = CoverageSummaryView.this.coverageTableTree.getExpandedElements()) != null) {
                    CoverageSummaryView.this.expansionMap.put(CoverageSummaryView.this.sourceElementForCurrentVisibleElements.getHandleIdentifier(), elems);
                }
            }
        });
        this.coverageTableTree.addFilter((ViewerFilter)new CoverageSummaryViewerFilter());
        this.makeActions();
        this.coverageTableTree.addSelectionChangedListener((ISelectionChangedListener)this.goToAction);
        this.coverageTableTree.addSelectionChangedListener((ISelectionChangedListener)this);
        CoverageTreeWrapper.addTreeColumns(this.coverageTableTree, COL_NAMES, COL_ALIGNMENTS, COL_WIDTHS, this.viewSorter);
        this.mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CoverageSummaryView.this.resizeColumns(CoverageSummaryView.this.mainComposite);
            }
        });
        this.contributeToActionBars();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.addListeners();
        this.setInitialSelection();
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)AgitatorCoveragePlugin.getDefault());
        return this.summaryComposite;
    }

    private void setInitialSelection() {
        AgSWTUtilities.safeExecuteOnEventQueue((Runnable)new Runnable(){

            public void run() {
                ISelection sel = CoverageSummaryView.this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
                AgitatorCoveragePlugin.getDefault().setInitialSelection(CoverageSummaryView.this, sel);
            }
        });
    }

    private void addListeners() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.setWindowListener();
    }

    private void setWindowListener() {
        if (this.getViewSite() == null || this.getViewSite().getPage() == null) {
            return;
        }
        this.getViewSite().getPage().addPartListener((IPartListener2)this);
    }

    private void removeWindowListener() {
        if (this.getViewSite() == null || this.getViewSite().getPage() == null) {
            return;
        }
        this.getViewSite().getPage().removePartListener((IPartListener2)this);
    }

    private void makeActions() {
        this.goToAction = new GoToAction();
        this.linkAction = new LinkAction();
        this.expandAllAction = new ExpandAllAction();
        this.collapseAllAction = new CollapseAllAction();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.goToAction);
        manager.add((IAction)this.linkAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.fillContextMenu(manager);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.goToAction);
        manager.add((IAction)this.linkAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CoverageSummaryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.coverageTableTree.getControl());
        this.coverageTableTree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.coverageTableTree);
    }

    public String getHelpID() {
        return "com.agitar.eclipse.help.panel_coverageSummary";
    }

    public void focusRequested() {
        this.coverageTableTree.getControl().setFocus();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.removeWindowListener();
        super.dispose();
    }

    private void hookDoubleClickAction() {
        this.coverageTableTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    CoverageSummaryView.this.goToSelection();
                }
                catch (Exception e) {
                    PluginUtils.displayExceptionInfo((Shell)CoverageSummaryView.this.getSite().getShell(), (Throwable)e, (String)"com.agitar.eclipse.coverage");
                }
            }
        });
    }

    private IJavaElement getSelectedIJavaElement() {
        IStructuredSelection sel = (IStructuredSelection)this.coverageTableTree.getSelection();
        if (sel == null || sel.getFirstElement() == null) {
            return null;
        }
        IJavaElement element = (IJavaElement)sel.getFirstElement();
        return element;
    }

    public void goToSelection() {
        IJavaElement element = this.getSelectedIJavaElement();
        try {
            if (element instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)element).findPrimaryType();
                if (type == null) {
                    return;
                }
                PluginUtils.openInEditor((IType)type);
            } else if (element instanceof IType) {
                PluginUtils.openInEditor((IType)((IType)element));
            } else if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                if (method == null) {
                    return;
                }
                ISourceRange range = null;
                range = method.getNameRange();
                ITextEditor textEditor = null;
                textEditor = (ITextEditor)JavaUI.openInEditor((IJavaElement)method);
                if (range != null) {
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        CoverageHelper.clearCoverageMap();
        if (this.coverageTableTree.getContentProvider() != null) {
            this.setTreeContents(null, new ArrayList(), true);
        }
    }

    public void createPartControl(Composite parent) {
        this.createMainPage(parent);
    }

    public void setFocus() {
        this.coverageTableTree.getControl().setFocus();
    }

    public void setSelection(final boolean ignoreSameSelection) {
        AgSWTUtilities.safeExecuteOnEventQueue((Runnable)new Runnable(){

            public void run() {
                try {
                    CoverageSummaryView.this.updateSelection(ignoreSameSelection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRebuildOfCurrentSelection(boolean careIfListening) {
        if (!this.isListening() && careIfListening) {
            return;
        }
        Object[] elems = this.getExpansionForElement(this.sourceElementForCurrentVisibleElements);
        ISelection sel = this.getSelectionForElement(this.sourceElementForCurrentVisibleElements);
        try {
            this.setTreeContents(this.sourceElementForCurrentVisibleElements, this.treeContents, true);
            if (elems != null) {
                this.coverageTableTree.setExpandedElements(elems);
            } else {
                this.coverageTableTree.expandToLevel(2);
            }
        }
        finally {
            this.restoreSelection(sel);
            CoverageHelper.clearCoverageMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialSelectionAndForceRebuild() {
        if (this.coverageTableTree == null || this.coverageTableTree.getControl().isDisposed()) {
            return;
        }
        IJavaElement currentSelection = AgitatorCoveragePlugin.getDefault().getCurrentSelection();
        this.visibleElements = this.getVisibleElement(currentSelection);
        this.treeContents.clear();
        for (int i = 0; i < this.visibleElements.length; ++i) {
            this.treeContents.add(this.visibleElements[i]);
        }
        try {
            this.setTreeContents(currentSelection, this.treeContents, false);
        }
        finally {
            CoverageHelper.clearCoverageMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(boolean ignoreSameSelection) {
        if (this.coverageTableTree == null || this.coverageTableTree.getControl().isDisposed()) {
            return;
        }
        IJavaElement currentSelection = AgitatorCoveragePlugin.getDefault().getCurrentSelection();
        Object[] oldElements = this.visibleElements;
        this.visibleElements = this.getVisibleElement(currentSelection);
        if (!this.isLinkedAndListening()) {
            return;
        }
        if (ignoreSameSelection && oldElements != null && currentSelection != null && Arrays.equals(oldElements, this.visibleElements)) {
            if (this.currSel != null && !this.currSel.isEmpty()) {
                this.sourceElementForCurrentVisibleElements = currentSelection;
                this.selectionMap.put(currentSelection.getHandleIdentifier(), this.currSel);
                Object[] elems = this.coverageTableTree.getExpandedElements();
                if (elems != null) {
                    this.expansionMap.put(currentSelection.getHandleIdentifier(), elems);
                }
            }
            return;
        }
        this.treeContents.clear();
        for (int i = 0; i < this.visibleElements.length; ++i) {
            this.treeContents.add(this.visibleElements[i]);
        }
        Object[] elems = this.getExpansionForElement(currentSelection);
        ISelection sel = this.getSelectionForElement(currentSelection);
        try {
            this.setTreeContents(currentSelection, this.treeContents, true);
            if (elems != null) {
                this.coverageTableTree.setExpandedElements(elems);
            } else {
                this.coverageTableTree.expandToLevel(2);
            }
        }
        finally {
            this.restoreSelection(sel);
            CoverageHelper.clearCoverageMap();
        }
    }

    private void setTreeContents(IJavaElement sourceOfContents, List treeContents, boolean loadCoverage) {
        this.sourceElementForCurrentVisibleElements = sourceOfContents;
        this.coverageTableTree.setInput((Object)treeContents);
        if (loadCoverage) {
            CoverageHelper.loadCoverage(this, treeContents);
        }
    }

    public ISelection getSelectionForElement(IJavaElement element) {
        if (element == null) {
            return null;
        }
        return (ISelection)this.selectionMap.get(element.getHandleIdentifier());
    }

    public Object[] getExpansionForElement(IJavaElement element) {
        if (element == null) {
            return null;
        }
        return (Object[])this.expansionMap.get(element.getHandleIdentifier());
    }

    private void restoreSelection(ISelection sel) {
        if (sel != null) {
            this.coverageTableTree.setSelection(sel);
        } else if (this.coverageTableTree != null && this.coverageTableTree.getTree().getItemCount() > 0) {
            TreeItem[] items = this.coverageTableTree.getTree().getItems();
            this.coverageTableTree.getTree().setSelection(new TreeItem[]{items[0]});
        }
    }

    private IJavaElement[] getAllTopLevelTypes(ICompilationUnit unit) {
        try {
            if (unit == null) {
                return null;
            }
            if (unit == null) {
                return null;
            }
            IType[] types = unit.getAllTypes();
            ArrayList<IType> typeList = new ArrayList<IType>();
            for (int i = 0; i < types.length; ++i) {
                if (types[i].isAnonymous()) continue;
                typeList.add(types[i]);
            }
            if (typeList.size() > 0) {
                return typeList.toArray(new IJavaElement[typeList.size()]);
            }
            return null;
        }
        catch (JavaModelException jme) {
            return null;
        }
    }

    public IJavaElement[] getVisibleElement(IJavaElement element) {
        if (element == null) {
            return new IJavaElement[0];
        }
        if (element.getElementType() > 5) {
            if (element.getParent() != null) {
                IMember type = JavaElementUtils.getContainer((IJavaElement)element.getParent());
                if (type != null && type instanceof IType) {
                    IJavaElement[] elems = this.getAllTopLevelTypes(((IType)type).getCompilationUnit());
                    if (elems != null) {
                        return elems;
                    }
                    return new IJavaElement[]{element};
                }
                return new IJavaElement[]{element};
            }
            return new IJavaElement[]{JavaElementUtils.getContainer((IJavaElement)element)};
        }
        if (element.getElementType() == 5) {
            try {
                IType type = ((ICompilationUnit)element).findPrimaryType();
                if (type != null) {
                    IJavaElement[] elems = this.getAllTopLevelTypes(type.getCompilationUnit());
                    if (elems != null) {
                        return elems;
                    }
                    return new IJavaElement[]{element};
                }
                return new IJavaElement[]{element};
            }
            catch (Exception e) {
                return new IJavaElement[]{element};
            }
        }
        return new IJavaElement[]{element};
    }

    public void setLinked(boolean link) {
        this.isLinked = link;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public boolean isLinkedAndListening() {
        return this.isLinked() && this.isListening();
    }

    public void setListening(boolean listen) {
        this.listening = listen;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if (partRef.getId() != null && partRef.getId().equals(ID)) {
            this.setListening(false);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getId() != null && partRef.getId().equals(ID)) {
            this.setListening(false);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef != null && partRef.getId() != null && partRef.getId().equals(ID)) {
            this.setListening(true);
            if (this.isLinked()) {
                this.setSelection(false);
            } else {
                this.forceRebuildOfCurrentSelection(false);
            }
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() != null) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new CoverageResourceVisitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        AgSWTUtilities.safeExecuteOnEventQueue((Runnable)new Runnable(){

            public void run() {
                if (CoverageSummaryView.this.coverageTableTree == null || CoverageSummaryView.this.coverageTableTree.getControl().isDisposed()) {
                    return;
                }
                if (CoverageSummaryView.this.isListening()) {
                    CoverageSummaryView.this.forceRebuildOfCurrentSelection(true);
                }
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.currSel;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.currSel = event.getSelection();
        if (this.currSel != null && !this.currSel.isEmpty() && this.sourceElementForCurrentVisibleElements != null) {
            this.selectionMap.put(this.sourceElementForCurrentVisibleElements.getHandleIdentifier(), this.currSel);
        }
    }

    public void resizeColumns(Composite parent) {
        CoverageTreeWrapper.resizeColumns(parent, 100, 1, 0, this.coverageTableTree);
    }

    public void refreshElement(final IJavaElement element) {
        AgSWTUtilities.safeExecuteOnEventQueue((Runnable)new Runnable(){

            public void run() {
                if (CoverageSummaryView.this.isListening()) {
                    CoverageSummaryView.this.coverageTableTree.update((Object)element, null);
                }
            }
        });
    }

    public void resort() {
        AgSWTUtilities.safeExecuteOnEventQueue((Runnable)new Runnable(){

            public void run() {
                if (CoverageSummaryView.this.coverageTableTree != null && !CoverageSummaryView.this.coverageTableTree.getControl().isDisposed()) {
                    CoverageSummaryView.this.coverageTableTree.refresh(false);
                }
            }
        });
    }

    class CoverageResourceVisitor
    implements IResourceDeltaVisitor {
        CoverageResourceVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if (delta.getFlags() == 65536) {
                return true;
            }
            if (delta.getResource() instanceof IFile) {
                IFile file = (IFile)delta.getResource();
                switch (delta.getKind()) {
                    case 2: 
                    case 4: {
                        IJavaElement element = JavaCore.create((IFile)file);
                        try {
                            CoverageHelper.clearCoverageMap();
                            CoverageHelper.removeElementFromCaches(element);
                        }
                        catch (Exception e) {
                            CoverageHelper.clearElementMap();
                        }
                        break;
                    }
                }
                return false;
            }
            if (delta.getResource() instanceof IFolder) {
                return true;
            }
            return true;
        }
    }

    public class GoToAction
    extends Action
    implements ISelectionChangedListener {
        public static final String GO_TO_IMG = "goto.gif";

        public GoToAction() {
            ImageDescriptor id = AgSWTUtilities.getImageDescriptor((AbstractUIPlugin)AgitatorCoveragePlugin.getDefault(), (String)GO_TO_IMG);
            this.setDisabledImageDescriptor(AgSWTUtilities.getImageDescriptor((AbstractUIPlugin)AgitatorCoveragePlugin.getDefault(), (String)IconUtility.getDisabledImageName((String)GO_TO_IMG)));
            this.setImageDescriptor(id);
            this.setText("&Go To");
            this.setToolTipText("Go to the selected class or method.");
            this.setEnabled(false);
        }

        public void run() {
            CoverageSummaryView.this.goToSelection();
        }

        private boolean canGoToElement(IJavaElement element) {
            if (element == null) {
                return false;
            }
            return element.getElementType() >= 5;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IJavaElement element = CoverageSummaryView.this.getSelectedIJavaElement();
            this.setEnabled(this.canGoToElement(element));
        }
    }

    public class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setText("&Collapse All");
            this.setToolTipText("Collapse all items.");
        }

        public void run() {
            CoverageSummaryView.this.coverageTableTree.collapseAll();
        }
    }

    public class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText("&Expand All");
            this.setToolTipText("Expand all items.");
        }

        public void run() {
            CoverageSummaryView.this.coverageTableTree.expandAll();
        }
    }

    public class LinkAction
    extends Action {
        public static final String LINK_IMG = "link.gif";

        public LinkAction() {
            super("&Link with Selection", 2);
            ImageDescriptor id = AgSWTUtilities.getImageDescriptor((AbstractUIPlugin)AgitatorCoveragePlugin.getDefault(), (String)LINK_IMG);
            this.setDisabledImageDescriptor(AgSWTUtilities.getImageDescriptor((AbstractUIPlugin)AgitatorCoveragePlugin.getDefault(), (String)IconUtility.getDisabledImageName((String)LINK_IMG)));
            this.setImageDescriptor(id);
            this.setToolTipText("Link with the current selection (Package Explorer, Editor, etc).");
            this.setChecked(this.getSavedLinkState());
            CoverageSummaryView.this.setLinked(this.isChecked());
        }

        private boolean getSavedLinkState() {
            return AgitatorCoveragePlugin.getDefault().getPreferenceStore().getBoolean("linkCoverageSummaryToSelection");
        }

        public void run() {
            boolean linked = this.getSavedLinkState();
            AgitatorCoveragePlugin.getDefault().getPreferenceStore().setValue("linkCoverageSummaryToSelection", !linked);
            boolean refresh = false;
            if (!linked) {
                refresh = true;
            }
            CoverageSummaryView.this.setLinked(!linked);
            this.setChecked(!linked);
            if (refresh) {
                CoverageSummaryView.this.setSelection(false);
            }
        }
    }

    class CoverageSummaryContentProvider
    implements ITreeContentProvider {
        CoverageSummaryContentProvider() {
        }

        public Object[] getChildren(Object element) {
            try {
                return CoverageSummaryView.this.getChildrenForElement((IJavaElement)element);
            }
            catch (Exception exception) {
                return new Object[0];
            }
        }

        public Object getParent(Object element) {
            if (element instanceof IJavaElement) {
                return ((IJavaElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (!(element instanceof IJavaElement)) {
                return false;
            }
            try {
                if (element instanceof IParent) {
                    if (element instanceof IMethod) {
                        return false;
                    }
                    if (element instanceof IType) {
                        return ((IType)element).getMethods() != null && ((IType)element).getMethods().length > 0;
                    }
                    return ((IParent)element).hasChildren();
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray(new Object[list.size()]);
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

