/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.MultiMap;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.ClassCoverageUtils;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.CoveragePoint;
import com.agitar.coverage.SourceLine;
import com.agitar.eclipse.core.resources.DotAgitatorFile;
import com.agitar.eclipse.core.util.AgSWTUtilities;
import com.agitar.eclipse.core.util.EclipseClassUtility;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.coverage.AgitatorCoveragePlugin;
import com.agitar.eclipse.coverage.CoverageFileLocator;
import com.agitar.eclipse.coverage.CoverageHelper;
import com.agitar.eclipse.coverage.CoverageHover;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.themes.IThemeManager;

public class CoverageRulerColumn
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IPropertyChangeListener {
    private static MultiMap resourceToRulersMap = new MultiMap();
    public static final String COVERAGE_FONT_PREFERENCE = "com.agitar.eclipse.coverage.textfont";
    public static final String COVERAGE_PASS_COLOR_PREFERENCE = "com.agitar.eclipse.coverage.passcolor";
    public static final String COVERAGE_FAIL_COLOR_PREFERENCE = "com.agitar.eclipse.coverage.failcolor";
    public static final String COVERAGE_DARKPASS_COLOR_PREFERENCE = "com.agitar.eclipse.testrunner.coverage.darkpasscolor";
    public static final String COVERAGE_DARKFAIL_COLOR_PREFERENCE = "com.agitar.eclipse.testrunner.coverage.darkfailcolor";
    private int[] highLightLines;
    public File coverageDir;
    private CompositeRuler parentRuler;
    private ITextViewer cachedTextViewer;
    private StyledText cachedStyledTextWidget;
    private Canvas canvas;
    private int scrollPos;
    private Image bufferImage;
    private InternalListener internalListener = new InternalListener();
    private Font columnFont;
    private int[] indentationCache;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color errorBackgroundColor;
    private int cachedNumberOfDigits = -1;
    private boolean relayoutRequired = false;
    private Color uncoveredColor;
    private Color coveredColor;
    private ICompilationUnit compilationUnit;
    IEditorPart editorPart;
    private Color darkCoveredColor;
    private Color darkUncoveredColor;
    private String errorCondition;
    private SourceLine[] lines;
    private String[] percentages;
    CoverageHover coverageHover = new CoverageHover(this);

    public static CoverageRulerColumn[] getAllRulers() {
        Collection values = resourceToRulersMap.values();
        return values == null ? new CoverageRulerColumn[]{} : values.toArray(new CoverageRulerColumn[0]);
    }

    public static void refreshAllRulers() {
        CoverageRulerColumn[] rulers = CoverageRulerColumn.getAllRulers();
        for (int i = 0; i < rulers.length; ++i) {
            rulers[i].reload();
        }
    }

    public static CoverageRulerColumn[] getRulersForResource(IResource r) {
        Set s = resourceToRulersMap.get((Object)r);
        if (s == null) {
            return new CoverageRulerColumn[0];
        }
        return s.toArray(new CoverageRulerColumn[0]);
    }

    public static boolean refresh(IResource resource) {
        Set s = resourceToRulersMap.get((Object)resource);
        if (s == null) {
            return false;
        }
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            CoverageRulerColumn ruler = (CoverageRulerColumn)iter.next();
            ruler.reload();
        }
        return true;
    }

    public CoverageRulerColumn(IEditorPart editorPart) {
        this.editorPart = editorPart;
        IJavaElement je = (IJavaElement)editorPart.getEditorInput().getAdapter(IJavaElement.class);
        if (je instanceof ICompilationUnit) {
            this.compilationUnit = (ICompilationUnit)je;
            if (this.hasDotAgitatorFile()) {
                try {
                    DotAgitatorFile agitatorFile = new DotAgitatorFile(this.compilationUnit.getJavaProject().getProject());
                    this.coverageDir = agitatorFile.getCoverageDir();
                }
                catch (Exception ex) {
                    PluginUtils.logExceptionInfo((Throwable)ex, (String)"com.agitar.eclipse.coverage");
                    this.coverageDir = null;
                }
            }
            resourceToRulersMap.put((Object)this.compilationUnit.getResource(), (Object)this);
        } else {
            this.compilationUnit = null;
        }
    }

    public File getCoverageDir() {
        return this.coverageDir;
    }

    public void setForeground(Color foreground) {
        this.foregroundColor = foreground;
    }

    protected Color getForeground() {
        return this.foregroundColor;
    }

    public void setBackground(Color background) {
        this.backgroundColor = background;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setBackground(this.getBackground(this.canvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.backgroundColor == null) {
            return display.getSystemColor(25);
        }
        return this.backgroundColor;
    }

    public Control getControl() {
        return this.canvas;
    }

    public int getWidth() {
        return this.indentationCache == null ? 2 : this.indentationCache[0];
    }

    private boolean updateNumberOfDigits() {
        if (this.cachedTextViewer == null) {
            return false;
        }
        int digits = this.computeNumberOfDigits();
        if (this.cachedNumberOfDigits != digits) {
            this.cachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    public int getCoverageMode() {
        IPreferenceStore store = AgitatorCoveragePlugin.getDefault().getPreferenceStore();
        return store.getInt("coverageRulerType");
    }

    private int computeNumberOfDigits() {
        int mode = this.getCoverageMode();
        if (mode == 0) {
            return 1;
        }
        if (mode == 1) {
            return 2;
        }
        if (this.lines == null) {
            return 2;
        }
        int max = -1;
        for (int i = 0; i < this.lines.length; ++i) {
            SourceLine sl = this.lines[i];
            if (sl == null) continue;
            max = Math.max(max, sl.getCounterText().length());
        }
        return max;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.relayoutRequired = true;
            return;
        }
        this.relayoutRequired = false;
        if (this.cachedTextViewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)this.cachedTextViewer).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeIndentations() {
        if (this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this.canvas);
        try {
            gc.setFont(this.canvas.getFont());
            this.indentationCache = new int[this.cachedNumberOfDigits + 1];
            String foo = "";
            for (int i = 0; i < this.cachedNumberOfDigits; ++i) {
                foo = foo + "9";
            }
            Point p = gc.stringExtent(foo);
            this.indentationCache[0] = p.x;
            for (int i = 1; i <= this.cachedNumberOfDigits; ++i) {
                foo = foo.substring(1);
                p = gc.stringExtent(foo);
                this.indentationCache[i] = p.x;
            }
        }
        finally {
            gc.dispose();
        }
    }

    public Control createControl(CompositeRuler ruler, Composite parentControl) {
        this.parentRuler = ruler;
        this.cachedTextViewer = this.parentRuler.getTextViewer();
        this.cachedStyledTextWidget = this.cachedTextViewer.getTextWidget();
        this.canvas = new Canvas(parentControl, 0);
        this.canvas.setBackground(this.getBackground(this.canvas.getDisplay()));
        this.canvas.setForeground(this.foregroundColor);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (CoverageRulerColumn.this.cachedTextViewer != null) {
                    CoverageRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CoverageRulerColumn.this.handleDispose();
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseHandler());
        IThemeManager mgr = AgitatorCoveragePlugin.getDefault().getWorkbench().getThemeManager();
        if (this.cachedTextViewer != null) {
            if (this.cachedTextViewer.getDocument() != null) {
                this.cachedTextViewer.getDocument().addDocumentListener((IDocumentListener)this.internalListener);
            }
            this.cachedTextViewer.addViewportListener((IViewportListener)this.internalListener);
            this.cachedTextViewer.addTextListener((ITextListener)this.internalListener);
            this.cachedTextViewer.addTextInputListener((ITextInputListener)this.internalListener);
            if (this.cachedStyledTextWidget != null && !this.cachedStyledTextWidget.isDisposed()) {
                AgitatorCoveragePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
                mgr.addPropertyChangeListener((IPropertyChangeListener)this);
                this.columnFont = mgr.getCurrentTheme().getFontRegistry().get(COVERAGE_FONT_PREFERENCE);
                Font f = mgr.getCurrentTheme().getFontRegistry().get("org.eclipse.jface.textfont");
                if (!this.columnFont.isDisposed() && !f.isDisposed() && this.columnFont.getFontData()[0].toString().equals(f.getFontData()[0].toString())) {
                    this.columnFont = AgSWTUtilities.deriveFont((Font)this.columnFont, (int)0, (int)(this.columnFont.getFontData()[0].getHeight() - 2));
                }
            }
        }
        if (this.columnFont != null) {
            this.canvas.setFont(this.columnFont);
        }
        this.coveredColor = mgr.getCurrentTheme().getColorRegistry().get(COVERAGE_PASS_COLOR_PREFERENCE);
        this.uncoveredColor = mgr.getCurrentTheme().getColorRegistry().get(COVERAGE_FAIL_COLOR_PREFERENCE);
        this.darkCoveredColor = mgr.getCurrentTheme().getColorRegistry().get(COVERAGE_DARKPASS_COLOR_PREFERENCE);
        this.darkUncoveredColor = mgr.getCurrentTheme().getColorRegistry().get(COVERAGE_DARKFAIL_COLOR_PREFERENCE);
        this.errorBackgroundColor = new Color((Device)Display.getDefault(), 245, 245, 245);
        try {
            this.initCoverage();
        }
        catch (Exception ex) {
            PluginUtils.displayExceptionInfo((Shell)this.getControl().getShell(), (Throwable)ex, (String)"com.agitar.eclipse.coverage");
        }
        return this.canvas;
    }

    public String getErrorCondition() {
        return this.errorCondition;
    }

    private void clearCoverage(String error) {
        this.errorCondition = error;
        this.lines = null;
        this.percentages = null;
        this.updateNumberOfDigits();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CoverageRulerColumn.this.computeIndentations();
                CoverageRulerColumn.this.layout(true);
            }
        });
        this.postRedraw();
    }

    private boolean hasDotAgitatorFile() {
        if (this.compilationUnit == null || this.compilationUnit.getJavaProject() == null || this.compilationUnit.getJavaProject().getProject() == null) {
            return false;
        }
        return AgitatorCoveragePlugin.hasDotAgitatorFileForProject(this.compilationUnit.getJavaProject().getProject());
    }

    private void initCoverage() {
        try {
            this.errorCondition = null;
            this.lines = null;
            this.percentages = null;
            if (this.cachedTextViewer == null || this.canvas == null || this.canvas.isDisposed() || this.compilationUnit == null || !this.compilationUnit.exists()) {
                return;
            }
            if (this.compilationUnit.getTypes().length == 0) {
                return;
            }
            if (!this.hasDotAgitatorFile()) {
                return;
            }
            if (this.getCoverageMode() == 0) {
                try {
                    this.clearCoverage(null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            IType[] topLevelTypes = this.compilationUnit.getTypes();
            if (topLevelTypes == null) {
                return;
            }
            String[] topLevelNames = new String[topLevelTypes.length];
            for (int i = 0; i < topLevelTypes.length; ++i) {
                topLevelNames[i] = topLevelTypes[i].getFullyQualifiedName();
            }
            ClassCoverageUtils.CoverageInfo info = ClassCoverageUtils.getClassCoverages((String[])topLevelNames, (File)this.coverageDir, (ClassCoverageUtils.FileLocator)this.getFileLocator(this.compilationUnit));
            if (!info.isCoverageValid()) {
                if (CoverageHelper.coverageMapIsAllInvalid(info)) {
                    this.clearCoverage("No coverage shown, source no longer matches the coverage.");
                }
            } else if (this.classCoverageMapIsEmpty(info)) {
                this.clearCoverage(null);
            }
            Map classCoverageMap = info.getCoverageMap();
            IDocument document = this.cachedTextViewer.getDocument();
            int lineCount = document == null ? 0 : document.getNumberOfLines();
            this.lines = new SourceLine[lineCount];
            this.percentages = new String[lineCount];
            for (int i = 0; i < this.cachedTextViewer.getDocument().getNumberOfLines(); ++i) {
                String lineText = "";
                try {
                    IRegion region = this.cachedTextViewer.getDocument().getLineInformation(i);
                    lineText = this.cachedTextViewer.getDocument().get(region.getOffset(), region.getLength());
                }
                catch (BadLocationException e) {
                    continue;
                }
                this.lines[i] = new SourceLine(lineText);
            }
            try {
                this.fillInSourceLines(classCoverageMap, this.compilationUnit, this.lines);
            }
            catch (Exception exception) {
                this.clearCoverage("Coverage failed to load");
                PluginUtils.logExceptionInfo((Throwable)exception, (String)"com.agitar.eclipse.coverage");
                return;
            }
            this.updateNumberOfDigits();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    CoverageRulerColumn.this.computeIndentations();
                    CoverageRulerColumn.this.layout(true);
                }
            });
            this.postRedraw();
        }
        catch (Exception e) {
            this.clearCoverage("Error initializing coverage.");
            PluginUtils.logExceptionInfo((Throwable)e, (String)"com.agitar.eclipse.coverage");
        }
    }

    private boolean classCoverageMapIsEmpty(ClassCoverageUtils.CoverageInfo info) {
        if (info == null) {
            return true;
        }
        Map classCoverageMap = info.getCoverageMap();
        Set keySet = classCoverageMap.entrySet();
        return keySet == null || keySet.size() == 0;
    }

    public ClassCoverageUtils.FileLocator getFileLocator(ICompilationUnit unit) {
        return new CoverageFileLocator(unit);
    }

    protected void handleDispose() {
        IThemeManager mgr = AgitatorCoveragePlugin.getDefault().getWorkbench().getThemeManager();
        mgr.removePropertyChangeListener((IPropertyChangeListener)this);
        AgitatorCoveragePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        Font f = mgr.getCurrentTheme().getFontRegistry().get(COVERAGE_FONT_PREFERENCE);
        if (this.columnFont != null && !this.columnFont.equals((Object)f)) {
            this.columnFont.dispose();
        }
        if (this.compilationUnit != null) {
            resourceToRulersMap.remove((Object)this.compilationUnit.getResource(), (Object)this);
        }
        if (this.cachedTextViewer != null) {
            this.cachedTextViewer.removeViewportListener((IViewportListener)this.internalListener);
            this.cachedTextViewer.removeTextListener((ITextListener)this.internalListener);
        }
        if (this.bufferImage != null) {
            this.bufferImage.dispose();
            this.bufferImage = null;
        }
        if (this.errorBackgroundColor != null) {
            this.errorBackgroundColor.dispose();
        }
        this.cachedTextViewer = null;
        this.cachedStyledTextWidget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doubleBufferPaint(GC dest) {
        Point size = this.canvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.bufferImage != null) {
            Rectangle r = this.bufferImage.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.bufferImage.dispose();
                this.bufferImage = null;
            }
        }
        if (this.bufferImage == null) {
            this.bufferImage = new Image((Device)this.canvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.bufferImage);
        gc.setFont(this.canvas.getFont());
        if (this.foregroundColor != null) {
            gc.setForeground(this.foregroundColor);
        }
        try {
            gc.setBackground(this.getBackground(this.canvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.cachedTextViewer instanceof ITextViewerExtension5) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.bufferImage, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        Rectangle clArea = this.cachedStyledTextWidget.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / this.cachedStyledTextWidget.getLineHeight();
        }
        return -1;
    }

    private void doPaint(GC gc) {
        if (this.cachedTextViewer == null) {
            return;
        }
        if (this.cachedStyledTextWidget == null) {
            return;
        }
        if (this.indentationCache == null) {
            return;
        }
        int firstLine = 0;
        int topLine = this.cachedTextViewer.getTopIndex() - 1;
        int bottomLine = this.cachedTextViewer.getBottomIndex() + 1;
        try {
            int lastLine;
            IRegion region = this.cachedTextViewer.getVisibleRegion();
            IDocument doc = this.cachedTextViewer.getDocument();
            if (doc == null) {
                return;
            }
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine) {
                topLine = firstLine;
            }
            if ((lastLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < bottomLine) {
                bottomLine = lastLine;
            }
        }
        catch (BadLocationException x) {
            return;
        }
        int lineheight = this.cachedStyledTextWidget.getLineHeight();
        this.scrollPos = this.cachedStyledTextWidget.getTopPixel();
        int canvasheight = this.canvas.getSize().y;
        int y = (topLine - firstLine) * lineheight - this.scrollPos + this.cachedTextViewer.getTopInset();
        for (int line = topLine; line <= bottomLine && y < canvasheight; ++line, y += lineheight) {
            this.paintLine(line, y, lineheight, gc, this.cachedStyledTextWidget.getDisplay());
            String s = this.createDisplayString(line);
            int indentation = this.indentationCache[s.length()];
            gc.drawString(s, indentation, y, true);
        }
    }

    protected String createDisplayString(int line) {
        if (this.lines == null || line >= this.lines.length || this.getCoverageMode() != 2) {
            return "";
        }
        SourceLine sourceLine = this.lines[line];
        if (sourceLine == null) {
            return "";
        }
        return sourceLine.getCounterText();
    }

    private void doPaint1(GC gc) {
        if (this.cachedTextViewer == null) {
            return;
        }
        ITextViewerExtension5 extension = (ITextViewerExtension5)this.cachedTextViewer;
        int firstLine = 0;
        int widgetTopLine = this.cachedStyledTextWidget.getTopIndex();
        if (widgetTopLine > 0) {
            --widgetTopLine;
        }
        int topLine = extension.widgetLine2ModelLine(widgetTopLine);
        int bottomLine = this.cachedTextViewer.getBottomIndex();
        if (bottomLine >= 0) {
            ++bottomLine;
        }
        if (this.indentationCache == null) {
            return;
        }
        try {
            int lastLine;
            IRegion region = extension.getModelCoverage();
            IDocument doc = this.cachedTextViewer.getDocument();
            if (doc == null) {
                return;
            }
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine || topLine == -1) {
                topLine = firstLine;
            }
            if ((lastLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < bottomLine || bottomLine == -1) {
                bottomLine = lastLine;
            }
        }
        catch (BadLocationException x) {
            return;
        }
        int lineheight = this.cachedStyledTextWidget.getLineHeight();
        this.scrollPos = this.cachedStyledTextWidget.getTopPixel();
        int canvasheight = this.canvas.getSize().y;
        int y = widgetTopLine * lineheight - this.scrollPos + this.cachedTextViewer.getTopInset();
        for (int modelLine = topLine; modelLine <= bottomLine && y < canvasheight; ++modelLine) {
            int widgetLine = extension.modelLine2WidgetLine(modelLine);
            if (widgetLine == -1) continue;
            this.paintLine(modelLine, y, lineheight, gc, this.cachedStyledTextWidget.getDisplay());
            String s = this.createDisplayString(modelLine);
            int index = s.length() >= this.indentationCache.length ? this.indentationCache.length - 1 : s.length();
            int indentation = this.indentationCache[index];
            gc.drawString(s, indentation, y, true);
            y += lineheight;
        }
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        if (this.errorCondition != null) {
            gc.setBackground(this.errorBackgroundColor);
            gc.fillRectangle(0, y, this.getWidth(), lineheight);
            return;
        }
        if (this.lines == null || line >= this.lines.length) {
            return;
        }
        Color bg = this.getLineBackground(line);
        if (bg == null) {
            return;
        }
        gc.setBackground(bg);
        gc.fillRectangle(0, y, this.getWidth(), lineheight);
        if (this.getCoverageMode() == 2) {
            Color old = gc.getForeground();
            if (line > 0 && this.getLineBackground(line - 1) != bg) {
                gc.setForeground(Display.getDefault().getSystemColor(15));
                gc.drawLine(0, y, this.getWidth(), y);
            }
            if (line + 1 < this.lines.length && this.getLineBackground(line + 1) != bg) {
                gc.setForeground(Display.getDefault().getSystemColor(15));
                gc.drawLine(0, y + lineheight, this.getWidth(), y + lineheight);
            }
            gc.setForeground(old);
        }
    }

    protected Color getLineBackground(int line) {
        if (this.lines == null || line >= this.lines.length || this.lines[line] == null) {
            return null;
        }
        List points = this.lines[line].getCoveragePoints();
        int minCoverage = -1;
        Iterator iterator = points.iterator();
        while (iterator.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator.next();
            if (minCoverage >= 0 && minCoverage <= point.getTimesReached()) continue;
            minCoverage = point.getTimesReached();
        }
        if (minCoverage == 0) {
            if (this.lineIsInTest(line)) {
                return this.darkUncoveredColor;
            }
            return this.uncoveredColor;
        }
        if (!points.isEmpty()) {
            if (this.lineIsInTest(line)) {
                return this.darkCoveredColor;
            }
            return this.coveredColor;
        }
        return null;
    }

    protected final void postRedraw() {
        Display d;
        if (this.canvas != null && !this.canvas.isDisposed() && (d = this.canvas.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    CoverageRulerColumn.this.redraw();
                }
            });
        }
    }

    public void redraw() {
        if (this.relayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            GC gc = new GC((Drawable)this.canvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.columnFont = font;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setFont(this.columnFont);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    protected CompositeRuler getParentRuler() {
        return this.parentRuler;
    }

    public SourceLine[] getLines() {
        return this.lines;
    }

    public IAnnotationHover getHover() {
        return this.coverageHover;
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.parentRuler.getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.parentRuler.toDocumentLineNumber(y_coordinate);
    }

    public IAnnotationModel getModel() {
        return this.parentRuler.getModel();
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public boolean makerUpdateNeeded(String className) {
        return true;
    }

    public void reload() {
        Runnable r = new Runnable(){

            public void run() {
                CoverageRulerColumn.this.initCoverage();
                CoverageRulerColumn.this.layout(true);
                CoverageRulerColumn.this.postRedraw();
            }
        };
        if (this.getControl().isDisposed() || this.getControl().getDisplay() == null) {
            Set s = resourceToRulersMap.removeValue((Object)this);
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                resourceToRulersMap.removeKey(iter.next());
            }
            return;
        }
        this.getControl().getDisplay().asyncExec(r);
    }

    public void refresh() {
        Runnable r = new Runnable(){

            public void run() {
                CoverageRulerColumn.this.layout(true);
                CoverageRulerColumn.this.postRedraw();
            }
        };
        if (this.getControl().isDisposed() || this.getControl().getDisplay() == null) {
            Set s = resourceToRulersMap.removeValue((Object)this);
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                resourceToRulersMap.removeKey(iter.next());
            }
            return;
        }
        this.getControl().getDisplay().asyncExec(r);
    }

    public void propertyChange(PropertyChangeEvent event) {
        IThemeManager mgr;
        if (COVERAGE_FAIL_COLOR_PREFERENCE.equals(event.getProperty()) || COVERAGE_PASS_COLOR_PREFERENCE.equals(event.getProperty())) {
            mgr = AgitatorCoveragePlugin.getDefault().getWorkbench().getThemeManager();
            this.coveredColor = mgr.getCurrentTheme().getColorRegistry().get(COVERAGE_PASS_COLOR_PREFERENCE);
            this.uncoveredColor = mgr.getCurrentTheme().getColorRegistry().get(COVERAGE_FAIL_COLOR_PREFERENCE);
            this.refresh();
        }
        if (COVERAGE_FONT_PREFERENCE.equals(event.getProperty())) {
            if (this.cachedStyledTextWidget != null && !this.cachedStyledTextWidget.isDisposed()) {
                mgr = AgitatorCoveragePlugin.getDefault().getWorkbench().getThemeManager();
                this.setFont(mgr.getCurrentTheme().getFontRegistry().get(COVERAGE_FONT_PREFERENCE));
                this.layout(true);
            }
        } else if ("coverageRulerType".equals(event.getProperty())) {
            this.initCoverage();
        }
    }

    private void fillInSourceLines(Map classCoverageMap, ICompilationUnit cu, SourceLine[] lines) throws Exception {
        Set keySet = classCoverageMap.keySet();
        Iterator keyIter = keySet.iterator();
        IJavaProject javaProject = this.compilationUnit.getJavaProject();
        while (keyIter.hasNext()) {
            String dotName;
            String className = (String)keyIter.next();
            ClassCoverage cov = (ClassCoverage)classCoverageMap.get(className);
            IType type = javaProject.findType(className);
            if (type == null && (type = javaProject.findType(dotName = className.replace('$', '.'))) == null || cov == null) continue;
            this.buildCoveragePercentages(type, cov);
            SourceLine.mergeWithCoverage((ClassCoverage)cov, (SourceLine[])lines);
        }
        for (int i = 0; i < lines.length - 1; ++i) {
            lines[i].postProcess(lines[i + 1]);
        }
    }

    private void buildCoveragePercentages(IType type, ClassCoverage cc) throws Exception {
        String[] keys = cc.getMethodNames();
        MethodSignature[] sigs = cc.getMethodSignatures();
        IDocument document = this.cachedTextViewer.getDocument();
        int classLine = document.getLineOfOffset(type.getNameRange().getOffset());
        int classCoverage = cc.getCoveragePercent();
        if (classLine < this.percentages.length) {
            this.percentages[classLine] = "Class Coverage: " + classCoverage + "%";
        }
        for (int i = 0; i < sigs.length; ++i) {
            IMethod method = EclipseClassUtility.findMethod((IType)type, (MethodSignature)sigs[i]);
            if (method == null) continue;
            int offset = method.getNameRange().getOffset();
            int line = document.getLineOfOffset(offset);
            int percent = cc.getMethodCoveragePercent(keys[i]);
            if (line >= this.percentages.length) continue;
            this.percentages[line] = "Method Coverage: " + percent + "%";
        }
    }

    private boolean innerClassHasCoverageFilesToLoad(ICompilationUnit cu) throws Exception {
        IType[] types = cu.getTypes();
        long sourceModified = cu.getResource().getLocalTimeStamp();
        String packageName = types[0].getPackageFragment().getElementName();
        File acovDir = new File(this.coverageDir, packageName.replace('.', File.separatorChar));
        for (int i = 0; types != null && i < types.length; ++i) {
            final String className = this.toSimpleClassName(types[i].getFullyQualifiedName());
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    if (f.isDirectory()) {
                        return false;
                    }
                    if (!name.endsWith(".acov")) {
                        return false;
                    }
                    return name.startsWith(className + "$");
                }
            };
            File[] acovs = acovDir.listFiles(filter);
            for (int j = 0; acovs != null && j < acovs.length; ++j) {
                String cn = packageName + "." + acovs[j].getName().substring(0, acovs[j].getName().length() - ".acov".length());
                ClassCoverage rc = new ClassCoverage(cn, this.coverageDir);
                File acovFile = rc.locateCoverageFile();
                long origTime = 0L;
                if (acovFile.exists()) {
                    rc.read();
                    origTime = acovFile.lastModified();
                    if (rc.locateCoverageFile() == null || rc.locateCoverageFile().lastModified() < CoverageManager.getLastModified() || origTime != 0L && sourceModified > origTime + 1000L) continue;
                }
                return true;
            }
        }
        return false;
    }

    private boolean lineIsInTest(int line) {
        return this.highLightLines == null ? false : Arrays.binarySearch(this.highLightLines, line) >= 0;
    }

    public void setHightlightedLines(int[] lines) {
        this.highLightLines = lines;
        this.refresh();
    }

    private String toSimpleClassName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(46);
        if (idx <= 0) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public String getCoveragePercentage(int line) {
        if (this.percentages != null && this.percentages.length > 0 && line < this.percentages.length) {
            return this.percentages[line];
        }
        return null;
    }

    static /* synthetic */ SourceLine[] access$102(CoverageRulerColumn x0, SourceLine[] x1) {
        x0.lines = x1;
        return x1;
    }

    static /* synthetic */ String[] access$202(CoverageRulerColumn x0, String[] x1) {
        x0.percentages = x1;
        return x1;
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private int cachedViewportSize;
        private IRegion startLine;
        private int startLineNumber;
        private int autoScrollDirection;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 1) {
                this.stopSelecting();
                this.stopAutoScroll();
            }
        }

        public void mouseDown(MouseEvent event) {
            CoverageRulerColumn.this.parentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            if (event.button == 1) {
                this.startSelecting();
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
            CoverageRulerColumn.this.parentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent event) {
            if (!this.autoScroll(event)) {
                int newLine = CoverageRulerColumn.this.parentRuler.toDocumentLineNumber(event.y);
                this.expandSelection(newLine);
            }
        }

        public void mouseEnter(MouseEvent event) {
        }

        public void mouseExit(MouseEvent event) {
        }

        public void mouseHover(MouseEvent event) {
        }

        private void startSelecting() {
            try {
                IDocument document = CoverageRulerColumn.this.cachedTextViewer.getDocument();
                this.startLineNumber = CoverageRulerColumn.this.parentRuler.getLineOfLastMouseButtonActivity();
                this.startLine = document.getLineInformation(this.startLineNumber);
                CoverageRulerColumn.this.cachedTextViewer.setSelectedRange(this.startLine.getOffset(), this.startLine.getLength());
                this.cachedViewportSize = CoverageRulerColumn.this.getVisibleLinesInViewport();
                CoverageRulerColumn.this.canvas.addMouseMoveListener((MouseMoveListener)this);
                CoverageRulerColumn.this.canvas.addMouseTrackListener((MouseTrackListener)this);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void stopSelecting() {
            CoverageRulerColumn.this.canvas.removeMouseMoveListener((MouseMoveListener)this);
            CoverageRulerColumn.this.canvas.removeMouseTrackListener((MouseTrackListener)this);
        }

        private void expandSelection(int lineNumber) {
            try {
                IDocument document = CoverageRulerColumn.this.cachedTextViewer.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber);
                int start = Math.min(this.startLine.getOffset(), lineInfo.getOffset());
                int end = Math.max(this.startLine.getOffset() + this.startLine.getLength(), lineInfo.getOffset() + lineInfo.getLength());
                if (lineNumber < this.startLineNumber) {
                    CoverageRulerColumn.this.cachedTextViewer.setSelectedRange(end, start - end);
                } else {
                    CoverageRulerColumn.this.cachedTextViewer.setSelectedRange(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void stopAutoScroll() {
            this.autoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent event) {
            Rectangle area = CoverageRulerColumn.this.canvas.getClientArea();
            if (event.y > area.height) {
                this.autoScroll(1024);
                return true;
            }
            if (event.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int direction) {
            if (this.autoScrollDirection == direction) {
                return;
            }
            int TIMER_INTERVAL = 5;
            Display display = CoverageRulerColumn.this.canvas.getDisplay();
            Runnable timer = null;
            switch (direction) {
                case 128: {
                    timer = new Runnable(this, display){
                        private final /* synthetic */ Display val$display;
                        private final /* synthetic */ MouseHandler this$1;
                        {
                            this.this$1 = this$1;
                            this.val$display = val$display;
                        }

                        public void run() {
                            int top;
                            if (MouseHandler.access$1000(this.this$1) == 128 && (top = MouseHandler.access$1100(this.this$1)) > 0) {
                                CoverageRulerColumn.access$800(MouseHandler.access$1200(this.this$1)).setTopIndex(top - 1);
                                MouseHandler.access$1300(this.this$1, top - 1);
                                this.val$display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    timer = new Runnable(this, display){
                        private final /* synthetic */ Display val$display;
                        private final /* synthetic */ MouseHandler this$1;
                        {
                            this.this$1 = this$1;
                            this.val$display = val$display;
                        }

                        public void run() {
                            if (MouseHandler.access$1000(this.this$1) == 1024) {
                                int top = MouseHandler.access$1100(this.this$1);
                                CoverageRulerColumn.access$800(MouseHandler.access$1200(this.this$1)).setTopIndex(top + 1);
                                MouseHandler.access$1300(this.this$1, top + 1 + MouseHandler.access$1400(this.this$1));
                                this.val$display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
            }
            if (timer != null) {
                this.autoScrollDirection = direction;
                display.timerExec(5, timer);
            }
        }

        private int getInclusiveTopIndex() {
            if (CoverageRulerColumn.this.cachedStyledTextWidget != null && !CoverageRulerColumn.this.cachedStyledTextWidget.isDisposed()) {
                int top = CoverageRulerColumn.this.cachedTextViewer.getTopIndex();
                if (CoverageRulerColumn.this.cachedStyledTextWidget.getTopPixel() % CoverageRulerColumn.this.cachedStyledTextWidget.getLineHeight() != 0) {
                    --top;
                }
                return top;
            }
            return -1;
        }

        static /* synthetic */ int access$1000(MouseHandler x0) {
            return x0.autoScrollDirection;
        }

        static /* synthetic */ int access$1100(MouseHandler x0) {
            return x0.getInclusiveTopIndex();
        }

        static /* synthetic */ CoverageRulerColumn access$1200(MouseHandler x0) {
            return x0.CoverageRulerColumn.this;
        }

        static /* synthetic */ void access$1300(MouseHandler x0, int x1) {
            x0.expandSelection(x1);
        }

        static /* synthetic */ int access$1400(MouseHandler x0) {
            return x0.cachedViewportSize;
        }
    }

    class InternalListener
    implements IViewportListener,
    ITextListener,
    ITextInputListener,
    IDocumentListener {
        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (verticalPosition != CoverageRulerColumn.this.scrollPos) {
                CoverageRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            if (CoverageRulerColumn.this.lines != null && event.getDocumentEvent() != null) {
                CoverageRulerColumn.access$102(CoverageRulerColumn.this, null);
            }
            if (CoverageRulerColumn.this.percentages != null && event.getDocumentEvent() != null) {
                CoverageRulerColumn.access$202(CoverageRulerColumn.this, null);
            }
            CoverageRulerColumn.this.postRedraw();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (CoverageRulerColumn.this.compilationUnit != null) {
                resourceToRulersMap.remove((Object)CoverageRulerColumn.this.compilationUnit.getResource(), (Object)CoverageRulerColumn.this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            IJavaElement je;
            if (oldInput != null) {
                oldInput.removeDocumentListener((IDocumentListener)CoverageRulerColumn.this.internalListener);
            }
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)CoverageRulerColumn.this.internalListener);
            }
            if (CoverageRulerColumn.this.compilationUnit != null) {
                resourceToRulersMap.remove((Object)CoverageRulerColumn.this.compilationUnit.getResource(), (Object)CoverageRulerColumn.this);
            }
            if ((je = (IJavaElement)CoverageRulerColumn.this.editorPart.getEditorInput().getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = CoverageRulerColumn.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) instanceof ICompilationUnit) {
                CoverageRulerColumn.this.compilationUnit = (ICompilationUnit)je;
                if (CoverageRulerColumn.this.compilationUnit != null) {
                    resourceToRulersMap.put((Object)CoverageRulerColumn.this.compilationUnit.getResource(), (Object)CoverageRulerColumn.this);
                    if (CoverageRulerColumn.this.hasDotAgitatorFile()) {
                        try {
                            DotAgitatorFile agitatorFile = new DotAgitatorFile(CoverageRulerColumn.this.compilationUnit.getJavaProject().getProject());
                            CoverageRulerColumn.this.coverageDir = agitatorFile.getCoverageDir();
                        }
                        catch (Exception ex) {
                            PluginUtils.logExceptionInfo((Throwable)ex, (String)"com.agitar.eclipse.coverage");
                            CoverageRulerColumn.this.coverageDir = null;
                        }
                    }
                }
            } else {
                CoverageRulerColumn.this.compilationUnit = null;
            }
            CoverageRulerColumn.this.reload();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (CoverageRulerColumn.this.lines != null) {
                CoverageRulerColumn.access$102(CoverageRulerColumn.this, null);
            }
            if (CoverageRulerColumn.this.percentages != null) {
                CoverageRulerColumn.access$202(CoverageRulerColumn.this, null);
            }
            CoverageRulerColumn.this.postRedraw();
        }
    }
}

