/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.coverage.CoveragePoint;
import com.agitar.eclipse.coverage.CoverageRulerColumn;
import com.agitar.eclipse.coverage.HTMLPrinter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;

class CoverageHover
implements IAnnotationHover {
    private final CoverageRulerColumn column;

    CoverageHover(CoverageRulerColumn column) {
        this.column = column;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int line) {
        if (this.column.getErrorCondition() != null) {
            return this.column.getErrorCondition();
        }
        String percent = this.column.getCoveragePercentage(line);
        if (percent == null && (this.column.getLines() == null || line < 0 || line >= this.column.getLines().length || this.column.getLines()[line].getCoveragePoints().isEmpty() || this.column.getLineBackground(line) == null)) {
            return null;
        }
        int conditionCount = 0;
        StringBuffer buf = new StringBuffer();
        ArrayList<String> lines = new ArrayList<String>();
        Iterator iterator = this.column.getLines()[line].getCoveragePoints().iterator();
        Object lineReached = null;
        if (percent != null) {
            buf.append(percent);
        }
        block5: while (iterator.hasNext()) {
            if (buf.length() > 6) {
                lines.add(buf.toString());
                buf.setLength(0);
            }
            CoveragePoint point = (CoveragePoint)iterator.next();
            switch (point.getType()) {
                case 1: {
                    CoveragePoint p2 = (CoveragePoint)iterator.next();
                    buf.append("Condition #").append(++conditionCount).append(" true ").append(p2.getTimesReached());
                    buf.append(", false ").append(point.getTimesReached());
                    buf.append(" (total ").append(point.getTimesReached() + p2.getTimesReached()).append(')');
                    continue block5;
                }
                case 2: {
                    CoveragePoint p2 = (CoveragePoint)iterator.next();
                    buf.append("Condition #").append(++conditionCount).append(" true ").append(point.getTimesReached());
                    buf.append(", false ").append(p2.getTimesReached());
                    buf.append(" (total ").append(point.getTimesReached() + p2.getTimesReached()).append(')');
                    continue block5;
                }
                case 0: {
                    String s = "Line reached " + point.getTimesReached() + "x";
                    buf.append(s);
                    continue block5;
                }
            }
            buf.append("Unknown type ").append(point.getTimesReached());
        }
        String s = buf.toString().trim();
        if (s.length() > 0) {
            lines.add(buf.toString());
            if (lineReached != null) {
                lines.add(0, (String)lineReached);
            }
            return this.formatMultipleMessages(lines);
        }
        return null;
    }

    private String formatMultipleMessages(List messages) {
        Iterator e = messages.iterator();
        if (!e.hasNext()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        HTMLPrinter.startBulletList(buffer);
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }
}

