/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.StringUtility;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.ClassCoverageUtils;
import com.agitar.eclipse.core.resources.DotAgitatorFile;
import com.agitar.eclipse.core.util.MappingHelper;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.coverage.CoverageFileLocator;
import com.agitar.eclipse.coverage.CoverageSummaryView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CoverageHelper {
    private static final String CALC_STRING = "reading...";
    public static final String INTERFACE_COV_STR = "N/A";
    private static HashMap agiMap = new HashMap();
    private static HashMap elementCoverageMap = new HashMap();
    private static HashMap methodMap = new HashMap();
    private static HashMap coverageMap;

    private static File getCoverageDirForElement(IJavaElement element) {
        IJavaProject javaProj = element.getJavaProject();
        DotAgitatorFile daf = null;
        try {
            daf = (DotAgitatorFile)agiMap.get(javaProj.getElementName());
            if (daf == null) {
                daf = new DotAgitatorFile(javaProj.getProject());
                agiMap.put(javaProj.getElementName(), daf);
            }
            if (daf == null) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return daf.getCoverageDir();
    }

    public static void loadCoverage(CoverageSummaryView view, List javaElements) {
        LoadJob job = new LoadJob(view, javaElements);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.schedule();
    }

    public static void loadCoverageForForKids(CoverageSummaryView view, IJavaElement[] kids, IProgressMonitor monitor) {
        for (int i = 0; kids != null && i < kids.length; ++i) {
            CoverageHelper.loadCoverageForElement(view, kids[i], monitor);
        }
    }

    public static boolean coverageMapIsAllInvalid(ClassCoverageUtils.CoverageInfo info) {
        try {
            if (info.getCoverageMap() != null) {
                Collection values = info.getCoverageMap().values();
                Iterator valIter = values.iterator();
                while (valIter.hasNext()) {
                    if (valIter.next() == null) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void loadCoverageForElement(CoverageSummaryView view, IJavaElement element, IProgressMonitor monitor) {
        if (element == null || monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            Object kids = null;
            if (element instanceof IJavaProject) {
                kids = ((IJavaProject)element).getPackageFragmentRoots();
            } else if (element instanceof IPackageFragmentRoot) {
                if (((IPackageFragmentRoot)element).getKind() != 1) {
                    return;
                }
                kids = ((IPackageFragmentRoot)element).getChildren();
            } else if (element instanceof IPackageFragment) {
                kids = ((IPackageFragment)element).getCompilationUnits();
            } else if (element instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)element).findPrimaryType();
                kids = type == null ? null : type.getMethods();
            } else if (element instanceof IType) {
                ICompilationUnit unit = ((IType)element).getCompilationUnit();
                kids = unit == null ? null : ((IType)element).getMethods();
            }
            CoverageHelper.loadCoverageForForKids(view, (IJavaElement[])kids, monitor);
            File covDir = CoverageHelper.getCoverageDirForElement(element);
            CoverageHelper.getCoverageStringFromMap(element, covDir);
            view.refreshElement(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCoverage(CoverageSummaryView view, IJavaElement element) {
        String id = CoverageHelper.getIdForElement(element);
        String covStr = (String)elementCoverageMap.get(id);
        if (covStr != null) {
            return covStr;
        }
        return CALC_STRING;
    }

    private static String getIdForElement(IJavaElement element) {
        return element.getHandleIdentifier();
    }

    private static String getCoverageStringFromMap(IJavaElement element, File coverageDir) {
        String id = CoverageHelper.getIdForElement(element);
        String covStr = (String)elementCoverageMap.get(id);
        if (covStr == null) {
            covStr = CoverageHelper.getCoverageForElement(element, coverageDir);
            elementCoverageMap.put(id, covStr);
        }
        return covStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCoverageForElement(IJavaElement element, File coverageDir) {
        block8: {
            block7: {
                if (!(element instanceof ICompilationUnit)) break block7;
                String string = CoverageHelper.getCoverageStringForIType(element, coverageDir);
                return string;
            }
            if (!(element instanceof IType)) break block8;
            String string = CoverageHelper.getCoverageStringForClass(CoverageHelper.getClassCoverage((IType)element, coverageDir));
            return string;
        }
        try {
            if (element instanceof IMethod) {
                String string = CoverageHelper.getCoverageStringForIMethod(element, coverageDir);
                return string;
            }
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        return "";
    }

    private static String getCoverageStringForIType(IJavaElement element, File coverageDir) throws JavaModelException, IOException {
        IType type = ((ICompilationUnit)element).findPrimaryType();
        if (type.isInterface()) {
            return INTERFACE_COV_STR;
        }
        if (type == null) {
            return "";
        }
        return CoverageHelper.getCoverageStringForClass(CoverageHelper.getClassCoverage(type, coverageDir));
    }

    public static void clearElementMap() {
        methodMap.clear();
        elementCoverageMap.clear();
    }

    private static MethodSignature getMethodSignatureFromMap(IMethod method) {
        try {
            String id = method.getHandleIdentifier() + method.getSignature();
            MethodSignature msig = (MethodSignature)methodMap.get(id);
            if (msig == null) {
                msig = MappingHelper.getAgitarMethodSignature((IMethod)method);
                methodMap.put(id, msig);
            }
            return msig;
        }
        catch (Exception e) {
            PluginUtils.log((String)"Error getting agitar method sig from method for coverage.", (String)"com.agitar.eclipse.coverage");
            PluginUtils.logExceptionInfo((Throwable)e, (String)"com.agitar.eclipse.coverage");
            return null;
        }
    }

    private static String getCoverageStringForIMethod(IJavaElement element, File coverageDir) throws JavaModelException, CoreException, IOException {
        IMethod method = (IMethod)element;
        IType type = method.getDeclaringType();
        if (type.isInterface()) {
            return INTERFACE_COV_STR;
        }
        if (method != null && Flags.isAbstract((int)method.getFlags())) {
            return INTERFACE_COV_STR;
        }
        MethodSignature msig = CoverageHelper.getMethodSignatureFromMap((IMethod)element);
        if (msig == null) {
            return "";
        }
        return CoverageHelper.getCoverageStringForMethod(CoverageHelper.getClassCoverage(type, coverageDir), msig);
    }

    public static void clearCoverageMap() {
        if (coverageMap != null) {
            coverageMap.clear();
        }
    }

    public static HashMap getCoverageMap() {
        if (coverageMap == null) {
            coverageMap = new HashMap();
        }
        return coverageMap;
    }

    protected static ClassCoverage getClassCoverage(IType type, File coverageDir) throws IOException, JavaModelException {
        ClassCoverage cc;
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        ICompilationUnit unit = type.getCompilationUnit();
        if (unit.getTypes() != null && unit.getTypes().length > 1) {
            IType[] types = unit.getTypes();
            for (int i = 0; i < types.length; ++i) {
                CoverageHelper.getCoverageMap().remove(types[i].getFullyQualifiedName());
            }
        }
        if ((cc = (ClassCoverage)CoverageHelper.getCoverageMap().get(type.getFullyQualifiedName())) == null) {
            IType[] topLevelTypes = unit.getTypes();
            String[] topLevelNames = new String[topLevelTypes.length];
            for (int i = 0; i < topLevelTypes.length; ++i) {
                topLevelNames[i] = topLevelTypes[i].getFullyQualifiedName();
            }
            ClassCoverageUtils.CoverageInfo info = ClassCoverageUtils.getClassCoverages((String[])topLevelNames, (File)coverageDir, (ClassCoverageUtils.FileLocator)new CoverageFileLocator(unit));
            if (!CoverageHelper.coverageMapIsAllInvalid(info)) {
                Set keySet = info.getCoverageMap().keySet();
                Iterator keyIter = keySet.iterator();
                while (keyIter.hasNext()) {
                    ClassCoverage cov;
                    String dotName;
                    String className = (String)keyIter.next();
                    IJavaProject project = type.getJavaProject();
                    IType currType = project.findType(className);
                    if (currType == null && (currType = project.findType(dotName = className.replace('$', '.'))) == null || (cov = (ClassCoverage)info.getCoverageMap().get(currType.getFullyQualifiedName())) == null) continue;
                    CoverageHelper.getCoverageMap().put(currType.getFullyQualifiedName(), cov);
                }
            }
            cc = (ClassCoverage)CoverageHelper.getCoverageMap().get(type.getFullyQualifiedName());
        }
        if (cc == null) {
            return null;
        }
        return cc;
    }

    protected static String getCoverageStringForClass(ClassCoverage cc) {
        if (cc == null) {
            return "";
        }
        return CoverageHelper.getCovStr(cc.getCoveragePercent());
    }

    protected static String getCovStr(int cov) {
        return "" + cov;
    }

    protected static String getCoverageStringForMethod(ClassCoverage cc, MethodSignature msig) {
        if (cc == null) {
            return "";
        }
        int percent = cc.getMethodCoveragePercent(msig.getKey());
        return CoverageHelper.getCovStr(percent);
    }

    public static void removeElementFromCaches(IJavaElement element) throws Exception {
        if (element == null || elementCoverageMap.size() == 0) {
            return;
        }
        IType type = null;
        String fullyQualifiedName = null;
        if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
            fullyQualifiedName = type.getFullyQualifiedName();
        }
        if (type == null) {
            return;
        }
        CoverageHelper.removeNameFromMaps(fullyQualifiedName);
    }

    private static void removeNameFromMaps(String name) {
        String fullyQualifiedName = name;
        try {
            if (name != null && fullyQualifiedName.lastIndexOf(46) > 0) {
                fullyQualifiedName = StringUtility.toSimpleClassName((String)name);
            }
        }
        catch (Exception e) {
            fullyQualifiedName = name;
        }
        if (fullyQualifiedName != null) {
            Set keys = elementCoverageMap.keySet();
            ArrayList<String> list = new ArrayList<String>();
            Iterator keyIter = keys.iterator();
            while (keyIter.hasNext()) {
                String id = (String)keyIter.next();
                if (id == null || id.lastIndexOf(fullyQualifiedName) < 0) continue;
                list.add(id);
            }
            for (int i = 0; i < list.size(); ++i) {
                elementCoverageMap.remove(list.get(i));
            }
        }
    }

    public static void removeClassFromMaps(String[] className) {
        for (int i = 0; className != null && i < className.length; ++i) {
            CoverageHelper.removeNameFromMaps(className[i]);
        }
    }

    static class LoadJob
    extends WorkspaceJob {
        private List javaElements;
        private CoverageSummaryView view;

        public LoadJob(CoverageSummaryView view, List javaElements) {
            super("Loading coverage...");
            this.javaElements = javaElements;
            this.view = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) {
            IStatus iStatus;
            try {
                for (int i = 0; this.javaElements != null && i < this.javaElements.size(); ++i) {
                    if (monitor.isCanceled()) {
                        iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IJavaElement element = (IJavaElement)this.javaElements.get(i);
                    CoverageHelper.loadCoverageForElement(this.view, element, monitor);
                }
                this.view.resort();
            }
            catch (Throwable e) {
                iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

