/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.coverage.ClassCoverageUtils;
import com.agitar.eclipse.core.util.PluginUtils;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

public class CoverageFileLocator
implements ClassCoverageUtils.FileLocator {
    private ICompilationUnit compilationUnit;

    public CoverageFileLocator(ICompilationUnit unit) {
        this.compilationUnit = unit;
    }

    public File getClassFile(String className) {
        try {
            String dotName;
            IJavaProject project = this.compilationUnit.getJavaProject();
            if (project == null) {
                return null;
            }
            IType sourceType = project.findType(className);
            if (sourceType == null && (sourceType = project.findType(dotName = className.replace('$', '.'))) == null) {
                return null;
            }
            IClasspathEntry[] entries = project.getResolvedClasspath(true);
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].getEntryKind() != 3 || !entries[i].getPath().isPrefixOf(sourceType.getPath())) continue;
                try {
                    String outPathStr;
                    IPath aPath;
                    IFile resFile;
                    String outputStr;
                    IPath outputPath = entries[i].getOutputLocation();
                    if (outputPath == null && (outputStr = PluginUtils.makeRealAbsolutePath((IPath)(outputPath = project.getOutputLocation()))) != null) {
                        String fullName = className.replace('.', File.separatorChar);
                        String fullPath = outputStr + File.separatorChar + fullName + ".class";
                        File fullPathFile = new File(fullPath);
                        if (fullPathFile == null || !fullPathFile.exists()) continue;
                        return fullPathFile;
                    }
                    if (outputPath == null || (resFile = ResourcesPlugin.getWorkspace().getRoot().getFile(outputPath)) == null || (aPath = resFile.getRawLocation()) == null || (outPathStr = aPath.toString()) == null) continue;
                    String fullName = className.replace('.', File.separatorChar);
                    String fullPath = outPathStr + File.separatorChar + fullName + ".class";
                    File fullPathFile = new File(fullPath);
                    if (fullPathFile == null || !fullPathFile.exists()) continue;
                    return fullPathFile;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception e) {
            PluginUtils.log((String)("Unable to find source file for ruler: " + className), (String)"com.agitar.eclipse.coverage");
            PluginUtils.logExceptionInfo((Throwable)e, (String)"com.agitar.eclipse.coverage");
            return null;
        }
    }

    public File getSourceFile(String className) {
        try {
            String dotName;
            IJavaProject project = this.compilationUnit.getJavaProject();
            if (project == null) {
                return null;
            }
            IType sourceType = project.findType(className);
            if ((sourceType == null || sourceType.getResource() == null) && (sourceType = project.findType(dotName = className.replace('$', '.'))) == null) {
                return null;
            }
            IPath fullPath = sourceType.getResource().getLocation();
            if (fullPath == null) {
                return null;
            }
            return fullPath.toFile();
        }
        catch (Exception e) {
            PluginUtils.log((String)("Unable to find source file for ruler: " + className), (String)"com.agitar.eclipse.coverage");
            PluginUtils.logExceptionInfo((Throwable)e, (String)"com.agitar.eclipse.coverage");
            return null;
        }
    }

    public boolean isAutoBuildOn() {
        return true;
    }
}

