/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.coverage.CoverageManager;
import com.agitar.eclipse.core.AgUIException;
import com.agitar.eclipse.core.resources.DotAgitatorFile;
import com.agitar.eclipse.coverage.AgitatorCoveragePlugin;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ClearCoverageJob
extends WorkspaceJob {
    public ClearCoverageJob(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            this.clearCoverage();
            AgitatorCoveragePlugin.getDefault().refreshCoverage(null);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCoverage() throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        File currCovDir = CoverageManager.getCoverageDir();
        try {
            for (int i = 0; projects != null && i < projects.length; ++i) {
                try {
                    if (!projects[i].isOpen() || !projects[i].hasNature("org.eclipse.jdt.core.javanature")) continue;
                    this.clearCoverageForProject(projects[i]);
                    continue;
                }
                catch (Exception e) {
                    Status status = new Status(4, "com.agitar.eclipse.coverage", 0, "Error clearing coverage for project: " + projects[i], (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }
        finally {
            if (currCovDir != null) {
                CoverageManager.setCoverageDir((File)currCovDir);
            }
        }
    }

    protected void clearCoverageForProject(IProject project) throws AgUIException, IOException {
        if (!AgitatorCoveragePlugin.hasDotAgitatorFileForProject(project)) {
            return;
        }
        DotAgitatorFile dotAgitatorFile = new DotAgitatorFile(project);
        if (dotAgitatorFile == null || dotAgitatorFile.getAgitarDir() == null) {
            return;
        }
        File covDir = new File(dotAgitatorFile.getAgitarDir() + "/.results");
        CoverageManager.setCoverageDir((File)covDir);
        CoverageManager.setLastModified();
    }
}

