/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.common.util.IOUtility;
import com.agitar.eclipse.core.resources.DotAgitatorFile;
import com.agitar.eclipse.core.util.BeanPreferenceStore;
import com.agitar.eclipse.core.util.HelpUtils;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.coverage.ExclusionsEditor;
import com.agitar.lib.NoObfuscation;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class AgitatorProjectPropertiesPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage,
NoObfuscation {
    private IProject project;
    private DirectoryFieldEditor agitarDirectoryEditor;
    private StringFieldEditor chargeBackCode;
    private DotAgitatorFile dotAgitarFile;
    private ExclusionsEditor exclusions;

    protected void initialize() {
        super.initialize();
    }

    public void performHelp() {
        HelpUtils.displayHelp((String)"com.agitar.eclipse.help.dialog_projectProperties_Agitator");
    }

    public AgitatorProjectPropertiesPage() {
        super("Agitation", 1);
    }

    protected void createFieldEditors() {
        HelpUtils.setHelp((Control)this.getFieldEditorParent().getParent(), (String)"com.agitar.eclipse.help.dialog_projectProperties_Agitator");
        try {
            this.dotAgitarFile = new DotAgitatorFile(this.project);
            this.setPreferenceStore((IPreferenceStore)new BeanPreferenceStore((Object)this.dotAgitarFile));
        }
        catch (Exception e) {
            PluginUtils.displayExceptionInfo((Shell)this.getShell(), (Throwable)e, (String)"com.agitar.eclipse.coverage");
        }
        this.agitarDirectoryEditor = new AgDirectoryFieldEditor("agitarDir", "Agitar &directory:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.agitarDirectoryEditor);
        this.chargeBackCode = new StringFieldEditor("chargebackCode", "&Charge ID:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.chargeBackCode);
        this.exclusions = new ExclusionsEditor(this.project, this.dotAgitarFile, "Upload e&xclusions:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.exclusions);
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            try {
                this.dotAgitarFile.save((Object)this.getShell());
            }
            catch (Exception e) {
                PluginUtils.displayExceptionInfo((Shell)this.getShell(), (Throwable)e, (String)"com.agitar.eclipse.coverage");
                return false;
            }
            return true;
        }
        return false;
    }

    private class AgDirectoryFieldEditor
    extends DirectoryFieldEditor {
        String defaultErrorMessage;

        public AgDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.defaultErrorMessage = this.getErrorMessage();
        }

        public Text getTextControl(Composite parent) {
            this.setValidateStrategy(0);
            return super.getTextControl(parent);
        }

        protected boolean doCheckState() {
            this.setErrorMessage(this.defaultErrorMessage);
            String fileName = this.getTextControl().getText();
            fileName = fileName.trim();
            if (fileName.length() == 0) {
                return false;
            }
            File file = new File(fileName);
            if (file.exists() && !file.isDirectory()) {
                return false;
            }
            try {
                File projectDir = PluginUtils.getFile((IResource)AgitatorProjectPropertiesPage.this.project);
                String projectDirStr = IOUtility.getCanonicalPath((File)projectDir);
                String fileStr = IOUtility.getCanonicalPath((File)file);
                if (!"agitar".equals(file.getName())) {
                    this.setErrorMessage("Agitar directory must be named \"agitar\"");
                    return false;
                }
                this.setErrorMessage("Agitar directory must be within project directory.");
                return fileStr.length() > projectDirStr.length() + 1 && fileStr.startsWith(projectDirStr);
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

