/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.coverage;

import com.agitar.common.util.EvilTwin;
import com.agitar.common.util.StringUtility;
import com.agitar.eclipse.core.resources.DotAgitatorFile;
import com.agitar.eclipse.core.util.AgSWTUtilities;
import com.agitar.eclipse.core.util.JavaElementUtils;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.core.util.ReflectionHelper;
import com.agitar.eclipse.coverage.CoverageHelper;
import com.agitar.eclipse.coverage.CoverageRulerColumn;
import com.agitar.eclipse.coverage.CoverageSummaryView;
import com.agitar.lib.NoObfuscation;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.osgi.framework.BundleContext;

public class AgitatorCoveragePlugin
extends AbstractUIPlugin
implements NoObfuscation,
IWindowListener,
IPartListener,
ISelectionListener {
    public static final String ID = "com.agitar.eclipse.coverage";
    public static final String LINK_COV_SUMMARY = "linkCoverageSummaryToSelection";
    public static final String COV_SORT_DIR = "coverageSortDirection";
    private static AgitatorCoveragePlugin plugin;
    private IJavaElement currentSelection;
    private IJavaElement lastSelection;

    public void refreshCoverage(final String[] classNames) {
        AgSWTUtilities.safeExecuteOnEventQueue((Runnable)new Runnable(){

            public void run() {
                CoverageRulerColumn.refreshAllRulers();
                CoverageSummaryView view = AgitatorCoveragePlugin.this.getCoverageSummaryView();
                if (view != null) {
                    if (classNames == null) {
                        CoverageHelper.clearElementMap();
                    } else {
                        CoverageHelper.removeClassFromMaps(classNames);
                    }
                    if (view.isListening()) {
                        view.forceRebuildOfCurrentSelection(true);
                    }
                } else if (classNames == null) {
                    CoverageHelper.clearElementMap();
                } else {
                    CoverageHelper.removeClassFromMaps(classNames);
                }
            }
        });
    }

    public void setInitialSelection(CoverageSummaryView view, ISelection selection) {
        IJavaElement je = JavaElementUtils.getJavaElementFromSelection((ISelection)selection);
        if (je == null) {
            return;
        }
        this.currentSelection = je;
        try {
            if (view != null) {
                view.setInitialSelectionAndForceRebuild();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IJavaElement je = JavaElementUtils.getJavaElementFromSelection((ISelection)selection);
        if (je == null) {
            return;
        }
        if (part != null && part instanceof CoverageSummaryView) {
            return;
        }
        if (this.currentSelection != null) {
            this.lastSelection = this.currentSelection;
        }
        this.currentSelection = je;
        try {
            this.getCoverageSummaryView().setSelection(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public IJavaElement getLastSelection() {
        return this.lastSelection;
    }

    public IJavaElement getCurrentSelection() {
        return this.currentSelection;
    }

    public AgitatorCoveragePlugin() {
        plugin = this;
        if (EvilTwin.isMe()) {
            System.setProperty("OPLA", "");
        }
    }

    private CoverageSummaryView getCoverageSummaryView() {
        try {
            return (CoverageSummaryView)this.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.agitar.eclipse.coverage.CoverageSummaryView");
        }
        catch (Exception e) {
            return null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("coverageRulerType", 1);
        this.getPreferenceStore().setDefault("showCoverage", true);
        this.getPreferenceStore().setDefault(LINK_COV_SUMMARY, true);
        this.getPreferenceStore().setDefault(COV_SORT_DIR, 0);
        if (PlatformUI.isWorkbenchRunning()) {
            this.getWorkbench().addWindowListener((IWindowListener)this);
            IWorkbenchWindow[] windows = this.getWorkbench().getWorkbenchWindows();
            for (int i = 0; windows != null && i < windows.length; ++i) {
                this.windowOpened(windows[i]);
                windows[i].getSelectionService().addPostSelectionListener((ISelectionListener)this);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow[] windows = this.getWorkbench().getWorkbenchWindows();
            for (int i = 0; windows != null && i < windows.length; ++i) {
                windows[i].getSelectionService().removePostSelectionListener((ISelectionListener)this);
            }
        }
        super.stop(context);
        plugin = null;
    }

    public static AgitatorCoveragePlugin getDefault() {
        return plugin;
    }

    public void partActivated(IWorkbenchPart part) {
        this.partOpened(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        block8: {
            if (part instanceof AbstractTextEditor) {
                ReflectionHelper.hookMenuListener((AbstractTextEditor)((AbstractTextEditor)part));
            }
            if (part instanceof IEditorPart) {
                try {
                    IEditorPart editorPart;
                    IJavaElement je;
                    if (!(part instanceof IEditorPart) || !((je = (IJavaElement)(editorPart = (IEditorPart)part).getEditorInput().getAdapter(IJavaElement.class)) instanceof ICompilationUnit)) break block8;
                    try {
                        IVerticalRuler ruler = (IVerticalRuler)editorPart.getAdapter(IVerticalRulerInfo.class);
                        if (ruler instanceof CompositeRuler) {
                            CompositeRuler cRuler = (CompositeRuler)ruler;
                            Iterator it = cRuler.getDecoratorIterator();
                            while (it.hasNext()) {
                                if (!(it.next() instanceof CoverageRulerColumn)) continue;
                                return;
                            }
                            cRuler.addDecorator(10, (IVerticalRulerColumn)new CoverageRulerColumn(editorPart));
                        }
                    }
                    catch (Exception e) {
                        PluginUtils.logExceptionInfo((Throwable)e, (String)ID);
                    }
                }
                catch (Exception e) {
                    PluginUtils.logExceptionInfo((Throwable)e, (String)ID);
                }
            }
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (window instanceof ApplicationWindow) {
            window.getPartService().addPartListener((IPartListener)this);
            final IWorkbenchPart part = window.getPartService().getActivePart();
            if (part != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        AgitatorCoveragePlugin.this.partActivated(part);
                    }
                });
            }
        }
    }

    public static boolean hasDotAgitatorFileForProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            DotAgitatorFile daf = new DotAgitatorFile(project);
            if (daf == null) {
                return false;
            }
            return !StringUtility.nullOrEmpty((String)daf.getAgitarDir());
        }
        catch (Exception e) {
            return false;
        }
    }
}

