/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.CleanupDomainDeadUsersLuw;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.GetMatchingDomainsLuw;
import com.vs.ils.GetMatchingProductsLuw;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class UserCleanupJob
extends IlsJob {
    static final String USER_CLEANUP_JOB_NAME = "UserCleanup";
    static final String USER_CLEANUP_JOB_EXTERNAL_NAME = "User Cleanup";
    private static IlsUtil.Semaphore _$28656 = new IlsUtil.Semaphore(1);
    long cleanedUserCount;

    public String getJobName() {
        return USER_CLEANUP_JOB_NAME;
    }

    public String getJobExternalName() {
        return USER_CLEANUP_JOB_EXTERNAL_NAME;
    }

    public IlsJob.ParamData[] getJobParams() {
        IlsJob.ParamData[] paramDataArray = new IlsJob.ParamData[1];
        try {
            paramDataArray[0] = new IlsJob.ParamData("Product:Domain Pattern List", 2, this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : "%:%");
        }
        catch (WdoBaseException wdoBaseException) {
            paramDataArray = null;
        }
        return paramDataArray;
    }

    public String getJobParamsString() {
        String string = null;
        try {
            string = "Product:Domain Pattern List=" + (this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : "%:%");
        }
        catch (WdoBaseException wdoBaseException) {
            String string2 = null;
            return string2;
        }
        return string;
    }

    public String[] getAllowedJobSchedules() {
        String[] stringArray = new String[]{"Never", "Now", "Every Interval"};
        return stringArray;
    }

    public String[] getAllowedJobEventTriggers() {
        String[] stringArray = new String[]{"None", "Schedule"};
        return stringArray;
    }

    protected boolean updateJobSpecificParams(IlsJob.ParamData[] paramDataArray, Boolean[] booleanArray) {
        try {
            if (booleanArray[0].booleanValue()) {
                this.theJobData.setParam1(paramDataArray[0].paramValue);
            }
        }
        catch (WdoBaseException wdoBaseException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected boolean doTheJob() {
        Date date = new Date();
        IlsJob.ParamData[] paramDataArray = this.getJobParams();
        boolean bl = false;
        String string = paramDataArray[0].paramValue;
        String[] stringArray = this._$36408(string);
        this.cleanedUserCount = 0L;
        String string2 = "jobcmd=" + this.getJobName() + "Job&patterns=" + string;
        this.cmdArgs.setRequest(string2);
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n].split(":");
            Vector vector = this._$36431(stringArray2[0]);
            if (vector == null) {
                return false;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                block14: {
                    block13: {
                        try {
                            if (!((Product)vector.elementAt(n2)).getName().equals("system")) break block13;
                            break block14;
                        }
                        catch (WdoBaseException wdoBaseException) {
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    long l = 0L;
                    while (true) {
                        Vector vector2;
                        if ((vector2 = this._$36451((Product)vector.elementAt(n2), stringArray2[1], l, 100)) == null) {
                            return false;
                        }
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            block16: {
                                Domain domain;
                                block15: {
                                    domain = (Domain)vector2.elementAt(n3);
                                    try {
                                        if (!domain.getName().equals("system")) break block15;
                                        break block16;
                                    }
                                    catch (WdoBaseException wdoBaseException) {
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                }
                                bl = this._$36792((Product)vector.elementAt(n2), domain);
                                if (!bl) {
                                    return false;
                                }
                            }
                            ++n3;
                        }
                        if (vector2.size() < 100) break;
                        try {
                            l = ((Domain)vector2.elementAt(vector2.size() - 1)).getDomainId();
                        }
                        catch (WdoBaseException wdoBaseException) {
                            l = Long.MAX_VALUE;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        long l = (date.getTime() - this.startTime.getTime()) / (long)1000;
        this.cmdArgs.setStatusInfo(0, "Number of dead checkouts cleaned up: " + this.cleanedUserCount + ".  Elapsed time: " + l + " seconds.");
        return true;
    }

    protected boolean abortTheJob() {
        System.out.println("UserCleanup Job: Doing Dummy Job Abort.");
        return true;
    }

    private Vector _$36431(String string) {
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        if (!this.processLuwCmd(new GetMatchingProductsLuw(), objectArray, false)) {
            return null;
        }
        Vector vector = (Vector)objectArray[1];
        return vector;
    }

    private String[] _$36408(String string) {
        String[] stringArray = null;
        if (string == null || string.trim().equals("")) {
            stringArray = new String[]{"%:%"};
        } else {
            String string2 = ",";
            if (string.indexOf(";") > 0) {
                string2 = ";";
            }
            stringArray = string.trim().split(string2);
        }
        return stringArray;
    }

    private Vector _$36451(Product product, String string) {
        return this._$36451(product, string, 0L, 1000);
    }

    private Vector _$36451(Product product, String string, long l, int n) {
        Object[] objectArray = new Object[5];
        objectArray[0] = product;
        objectArray[1] = string;
        objectArray[2] = new Long(l);
        objectArray[3] = new Integer(n);
        if (!this.processLuwCmd(new GetMatchingDomainsLuw(), objectArray, false)) {
            return null;
        }
        Vector vector = (Vector)objectArray[4];
        return vector;
    }

    private boolean _$36792(Product product, Domain domain) {
        long l;
        block6: {
            try {
                IlsUtil.Trace(7, "UserCleanupJob", "cleanupDomainDeadUsers: enter for product [" + product.getName() + "] domain [" + domain.getName() + "]");
            }
            catch (WdoBaseException wdoBaseException) {
                // empty catch block
            }
            Object[] objectArray = new Object[]{this.cmdArgs, product, domain, null, null};
            l = 0L;
            long l2 = 0L;
            do {
                objectArray[3] = new Long(l2);
                if (!this.processLuwCmd(new CleanupDomainDeadUsersLuw(), objectArray, false)) {
                    return false;
                }
                l2 = (Long)objectArray[3];
                long l3 = (Long)objectArray[4];
                IlsUtil.Trace(7, "UserCleanupJob", "cleanupDomainDeadUsers: got currCleanupCount=" + l3);
                if (l3 == (long)0) break block6;
                l += l3;
            } while (IlsUtil.Sleep(1000));
            IlsUtil.Trace(7, "UserCleanupJob", "cleanupDomainDeadUsers: exiting wait loop due to interruption.");
            this.cmdArgs.setStatusInfo(-501, "User cleanup job was interrupted");
            return false;
        }
        try {
            IlsUtil.Trace(7, "UserCleanupJob", "CleanupDomainDeadUsers: done.  Service: " + this.serviceName + ", product: " + product.getName() + ", domain: " + domain.getName() + ", cleanup count: " + l);
        }
        catch (WdoBaseException wdoBaseException) {
            // empty catch block
        }
        this.cleanedUserCount += l;
        return true;
    }

    public static boolean DoingUserCleanup(IlsCmdArgs ilsCmdArgs) {
        if (!_$28656.wait(false)) {
            IlsUtil.Trace(3, "UserCleanupJob", "DoingUserCleanup: error waiting for critical-section semaphore.");
            ilsCmdArgs.setStatusInfo(1000, "UserCleanupJob: error waiting for critical section semaphore.");
            return false;
        }
        return true;
    }

    public static void DoneUserCleanup() {
        _$28656.signal();
    }

    public static boolean CleanupOneDeadCheckoutUser(Date date, DomainLicenseCacheEntry domainLicenseCacheEntry, Product product, Domain domain, User user) throws WdoBaseException {
        if (!IlsCmdAPI.CheckUserCheckedOutAndDead(date, user)) {
            return false;
        }
        IlsUtil.Trace(7, "UserCleanupJob", "CleanupOneDeadCheckoutUser: cleaning up dead user [" + user.getName() + "] id=" + user.getUserId() + "\nComplete state:\n" + user.toXML());
        if (domainLicenseCacheEntry == null) {
            domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
        }
        if (domainLicenseCacheEntry.anonDomain) {
            domainLicenseCacheEntry.adjustWatermark(date, domain, -user.getPoints(), true);
            User.Drop((long)user.getUserId());
        } else {
            domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, -user.getPoints(), true);
            user.getCheckoutInfo().setCheckedOut(false);
            user.getCheckoutInfo().lastChkOutTsUndefine();
            user.setIsDirty(true);
        }
        return true;
    }

    public static long CleanupDeadCheckoutUserBatch(IlsCmdArgs ilsCmdArgs, Date date, DomainLicenseCacheEntry domainLicenseCacheEntry, Product product, Domain domain, Vector vector) throws WdoBaseException {
        if (!UserCleanupJob.DoingUserCleanup(ilsCmdArgs)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        long l = 0L;
        try {
            if (domainLicenseCacheEntry == null) {
                domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                User user = (User)enumeration.nextElement();
                if (!UserCleanupJob.CleanupOneDeadCheckoutUser(date, domainLicenseCacheEntry, product, domain, user)) continue;
                ++l;
            }
            IlsUtil.Trace(7, "UserCleanupJob", "CleanupDeadCheckoutUserBatch: cleaned up " + l + " out of a batch of " + vector.size());
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            UserCleanupJob.DoneUserCleanup();
            throw throwable;
        }
        UserCleanupJob.DoneUserCleanup();
        return l;
    }
}

