/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AddUserLuw;
import com.vs.ils.AlerterJob;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

class RegisterLuw
implements WdoUnitOfWork {
    RegisterLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
        Date date = new Date();
        String string = ilsCmdArgs.getUser();
        Object var7_7 = null;
        Object var8_8 = null;
        long l = 0L;
        boolean bl = false;
        IlsToken ilsToken = ilsCmdAPI.parseToken(true);
        ilsCmdArgs.setToken(null);
        IlsUtil.Trace(10, "RegisterCmd", "RegisterLuw: domain name after parseToken: " + ilsCmdArgs.getDomain());
        Product product = ilsCmdAPI.checkGetProduct();
        long l2 = product.getProductId();
        IlsUtil.Trace(10, "RegisterCmd", "RegisterLuw: domain name just before checkgetdomain: " + ilsCmdArgs.getDomain());
        Domain domain = ilsCmdAPI.checkGetDomain(product);
        long l3 = domain.getDomainId();
        if (ilsToken.getAuthLevel() < 2 || ilsToken.getAuthLevel() == 2 && string.startsWith("useradmin")) {
            ilsCmdArgs.setStatusInfo(31, "Registering a public named user requires user administration privileges at a minimum.  If the named user to be registered is a user administrator, product administration privileges are required at a minimum.", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (ilsToken.getAuthLevel() == 2 && l3 != ilsToken.getDomainId()) {
            ilsCmdArgs.setStatusInfo(31, "Insufficient privileges to perform user registration on domain '" + domain.getName() + "'.  Your domain administration privileges are limited to your assigned domain '" + Domain.GetDomain((long)ilsToken.getDomainId()).getName(), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (!(bl = domain.getLicenseModel().equals("IUSER")) && !string.equals("useradmin")) {
            ilsCmdArgs.setStatusInfo(19, "Users can only be registered to a named-user type of domain.  Domain: " + domain.getName(), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        User user = null;
        l = User.FindByNameXNoAuth((String)product.getName(), (String)domain.getName(), (String)string, (boolean)true);
        if (l == (long)0 || ilsCmdArgs.getUpdateOk()) {
            long l4;
            LicenseParamInfo licenseParamInfo;
            ProductLicenseCacheEntry productLicenseCacheEntry = null;
            DomainLicenseCacheEntry domainLicenseCacheEntry = null;
            if (l == (long)0) {
                productLicenseCacheEntry = IlsLicenseCache.getProductCacheEntry(date, product);
                if (!productLicenseCacheEntry.checkLimit(date, product, 1, product.getUserLimit())) {
                    ilsCmdArgs.setStatusInfo(26, "Concurrent license limit of " + product.getUserLimit() + " points for product " + product.getName() + " exceeded", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                if (!(domainLicenseCacheEntry = productLicenseCacheEntry.getDomainEntry(date, domain, !bl)).checkLimit(date, ilsCmdArgs, product, domain, 1, domain.getUserLimit())) {
                    ilsCmdArgs.setStatusInfo(26, "License limit of " + domain.getUserLimit() + " users for license domain " + domain.getName() + " (product " + product.getName() + ")" + " exceeded", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
            } else {
                user = User.GetUser((long)l);
            }
            IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(ilsCmdAPI.getServiceName(), ilsCmdArgs.getToken(), ilsCmdArgs);
            LicenseParamInfo licenseParamInfo2 = licenseParamInfo = l == (long)0 ? (LicenseParamInfo)domain.getLicenseParams().clone() : (LicenseParamInfo)user.getLicenseParams().clone();
            if (ilsCmdArgs.getQuotaCap() >= (long)0) {
                l4 = ilsCmdArgs.getQuotaCap();
                if (licenseParamInfo.getQuotaLimited()) {
                    if (licenseParamInfo.getQuota() != (long)-1 && licenseParamInfo.getQuota() < l4) {
                        ilsCmdArgs.setStatusInfo(-104, "User quota limit is truncated to the owning domain's quota limit of " + licenseParamInfo.getQuota(), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
                        l4 = licenseParamInfo.getQuota();
                    }
                } else {
                    licenseParamInfo.setQuotaLimited(true);
                }
                licenseParamInfo.setQuota(l4);
            } else if (l == (long)0 || ilsCmdArgs.getQuotaCap() == (long)-2) {
                licenseParamInfo.setQuotaLimited(false);
                licenseParamInfo.setQuota(-1L);
            }
            if (ilsCmdArgs.getUserExpTs() > (long)0) {
                if (ilsCmdArgs.getUserExpTs() < date.getTime()) {
                    licenseParamInfo.setExpDays(ilsCmdArgs.getUserExpTs() / (long)1000);
                    licenseParamInfo.expDateUndefine();
                    licenseParamInfo.setTimeLimitType("RELT");
                } else {
                    l4 = ilsCmdArgs.getUserExpTs();
                    licenseParamInfo.setExpDate(new Timestamp(l4));
                    licenseParamInfo.setTimeLimitType("ABST");
                }
            } else if (l == (long)0 || ilsCmdArgs.getUserExpTs() == (long)-2) {
                licenseParamInfo.expDateUndefine();
                licenseParamInfo.setExpDays(-1L);
                licenseParamInfo.setTimeLimitType("NONE");
            }
            if (ilsCmdArgs.getOptions() != null) {
                licenseParamInfo.setOptions(ilsCmdArgs.getOptions());
            }
            AddUserLuw.addUser(ilsAdminAPI, product, domain, l, string, ilsCmdArgs.getPasswd(), ilsCmdArgs.getParams(), ilsCmdArgs.getAppCtx(), licenseParamInfo, ilsCmdArgs.getEnable(), "RegisterCmd", ilsCmdArgs.getCheckedOut(), ilsCmdArgs.getQuota() >= (long)0 ? new Long(ilsCmdArgs.getQuota()) : null, ilsToken.getAuthLevel());
            if (l == (long)0 && bl) {
                domainLicenseCacheEntry.adjustWatermark(date, domain, 1, true);
            }
            IlsUtil.Trace(1, "RegisterCmd", "RegisterLuw: added / updated user '" + ilsCmdArgs.getUser() + "' for domain '" + domain.getName() + "', product '" + product.getName() + "'");
        } else {
            user = User.GetUser((long)l);
            ilsCmdArgs.setStatusInfo(21, "User was already registered on date: " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss z").format(new Date(user.getAdminInfo().getCreationDate().getTime())), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
        }
    }
}

