/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.ilsdb.AuditTrail;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;

class RecordUsageSampleLuw
implements WdoUnitOfWork {
    RecordUsageSampleLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsJob ilsJob = (IlsJob)objectArray[0];
        objectArray = (Object[])objectArray[1];
        Product product = (Product)objectArray[0];
        Domain domain = (Domain)objectArray[1];
        Date date = new Date();
        ProductLicenseCacheEntry productLicenseCacheEntry = IlsLicenseCache.getProductCacheEntry(date, product);
        DomainLicenseCacheEntry domainLicenseCacheEntry = productLicenseCacheEntry.getDomainEntry(date, domain, true);
        int n2 = domainLicenseCacheEntry.getPeakUsageSample();
        AuditTrail auditTrail = AuditTrail.GetAuditTrail();
        auditTrail.setEventDate(new Timestamp(date.getTime()));
        auditTrail.setEventTs(date.getTime());
        auditTrail.setSource("INT");
        auditTrail.setCategory("SYS");
        auditTrail.setUserName("sysadmin");
        auditTrail.setDomainName(domain.getName());
        auditTrail.setProductName(product.getName());
        auditTrail.setMachineName("N/A");
        auditTrail.setSeverity(1);
        auditTrail.setViewAuthLevel(4);
        auditTrail.setViewDetailLevel(3);
        auditTrail.setCmd("UsageSample");
        auditTrail.setEventCode(n2);
        String string = ilsJob.getJobParamsString();
        auditTrail.setRequestMsg(string);
        auditTrail.setResponseMsg("");
        auditTrail.setEventStatusMsg("");
        IlsUtil.Trace(10, "UsageSamplerJob", "RecordUsageSampleLuw: creating entry in db.  Service: " + ilsJob.serviceName + ", product: " + product.getName() + ", domain: " + domain.getName() + ", sample value: " + n2);
        AuditTrail.Create((AuditTrail)auditTrail);
        IlsUtil.Trace(10, "UsageSamplerJob", "RecordUsageSampleLuw: done.  Service: " + ilsJob.serviceName + ", product: " + product.getName() + ", domain: " + domain.getName() + ", sample value: " + n2);
    }
}

